/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.Rafflesia;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.RafflesiaPart;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5575;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.tslat.smartbrainlib.util.BrainUtils;

public class RafflesiaPitcher
extends RafflesiaPart {
    private static final class_243 OFFSET = new class_243(-1.0, 0.0, 0.2);
    private final AnimationHandler<RafflesiaPitcher> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public RafflesiaPitcher(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    public RafflesiaPitcher(class_1937 level, Rafflesia parent) {
        super((class_1299<? extends class_1308>)((class_1299)RuneCraftoryEntities.RAFFLESIA_PITCHER.get()), level, parent);
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            this.getAnimationHandler().runIfNotNull(anim -> {
                if (anim.isAt("attack")) {
                    RafflesiaPitcher.rafflesiaSpawning(this);
                }
            });
        }
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }

    public static void rafflesiaSpawning(RafflesiaPart part) {
        if (part.method_37908().field_9236 || part.getOwner() == null) {
            return;
        }
        List nearby = part.method_37908().method_18023(class_5575.method_31795(class_1308.class), part.getOwner().arenaAABB(), m -> {
            if (!m.method_5864().method_20210(RunecraftoryTags.EntityTypes.RAFFLESIA_SUMMONS)) {
                return false;
            }
            if (m instanceof class_6025) {
                class_6025 ownableEntity = (class_6025)m;
                class_1657 player = null;
                if (part.getOwner() != null) {
                    if (part.getOwner().method_6139() == null) {
                        return true;
                    }
                    player = part.getOwner().getOwner();
                }
                if (player != null) {
                    return player.method_5667().equals(ownableEntity.method_6139());
                }
            }
            return true;
        });
        if (nearby.size() < 5) {
            int rand = 1 + (part.method_59922().method_43056() ? 1 : 0);
            class_2338 summonPos = part.method_24515();
            for (int i = 0; i < rand; ++i) {
                class_2338 pos = summonPos.method_10069(part.method_59922().method_43048(8) - 4, part.method_59922().method_43048(2), part.method_59922().method_43048(8) - 4);
                Optional opt = class_7923.field_41177.method_40266(RunecraftoryTags.EntityTypes.RAFFLESIA_SUMMONS).flatMap(named -> named.method_40243(part.method_59922()).map(class_6880::comp_349));
                opt.ifPresent(type -> {
                    class_3218 serverLevel = (class_3218)part.method_37908();
                    class_1297 e = type.method_5888(serverLevel, null, pos, class_3730.field_16471, true, true);
                    if (e != null) {
                        Object mob;
                        Rafflesia owner = part.getOwner();
                        if (e instanceof class_1308) {
                            mob = (class_1308)e;
                            BrainUtils.setTargetOfEntity((class_1309)mob, (class_1309)part.method_5968());
                            if (owner != null && owner.method_18410()) {
                                mob.method_18408(owner.method_24515(), (int)owner.method_18413() + 1);
                            }
                        }
                        if (e instanceof IBaseMob) {
                            mob = (IBaseMob)e;
                            if (owner != null) {
                                int level = part.getOwner().xpLevel().getLevel();
                                mob.setXPLevel(level + (int)((part.method_59922().method_43058() - 0.5) * (double)level * 0.1));
                            }
                        }
                        for (int p = 0; p < 5; ++p) {
                            serverLevel.method_14199((class_2394)class_2398.field_11204, e.method_23322(1.0), e.method_23319(), e.method_23325(1.0), 1, serverLevel.method_8409().method_43059() * 0.1, serverLevel.method_8409().method_43059() * 0.1, serverLevel.method_8409().method_43059() * 0.1, 0.0);
                        }
                        part.method_37908().method_8649(e);
                    }
                });
            }
        }
    }

    @Override
    public RafflesiaPart.PartType getPartType() {
        return RafflesiaPart.PartType.PITCHER;
    }

    @Override
    public class_243 offset() {
        return OFFSET;
    }

    @Override
    public String attackAnim() {
        return RafflesiaPart.PITCHER_ACTION;
    }

    @Override
    public int cooldown() {
        return this.method_59922().method_43048(60) + 120;
    }
}

