/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.WeaponHandler;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCDataManager;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.FollowEntityEx;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetWalkTargetFromMemory;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.AcquirePOITask;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.InvalidatePOITask;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.LookAtInteractingPlayer;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackActions;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.OpenDoors;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SetRainShelterTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SetWalkAroundPoiTarget;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SleepInBed;
import io.github.flemmli97.runecraftory.common.entities.npc.DailyNPCUpdater;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCFriendPoints;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCRelationManager;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCSchedule;
import io.github.flemmli97.runecraftory.common.entities.npc.PlaceHolderComponent;
import io.github.flemmli97.runecraftory.common.entities.npc.QuestConversationContext;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SizeFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.entities.pathing.NPCWalkNodeEvaluator;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateHolder;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateTracker;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShop;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerShop;
import io.github.flemmli97.runecraftory.common.items.BabySpawnEgg;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CNPCLook;
import io.github.flemmli97.runecraftory.common.network.S2CNpcDialogue;
import io.github.flemmli97.runecraftory.common.network.S2COpenNPCGui;
import io.github.flemmli97.runecraftory.common.network.S2CUpdateNPCData;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.NPCTalkTracker;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryActivities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.NPCHandler;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.runecraftory.common.world.data.family.FamilyEntry;
import io.github.flemmli97.runecraftory.common.world.data.family.FamilyHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.quest.QuestState;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetMoveToRestriction;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.particle.data.ScaleData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1408;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1829;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_3908;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_4168;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_47;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5569;
import net.minecraft.class_5575;
import net.minecraft.class_5862;
import net.minecraft.class_5863;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7477;
import net.minecraft.class_8103;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.AvoidEntity;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class NPCEntity
extends class_1296
implements class_1655,
IBaseMob,
AnimatedEntity,
TargetableOpponent,
MobAttackExt,
SmartBrainOwner<NPCEntity>,
SyncedMobDataHandler,
MoveStateHolder {
    public static final float PATH_FIND_LENGTH = 100.0f;
    private static final class_2940<Boolean> PLAY_DEATH_STATE = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> MALE = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BEHAVIOUR_DATA = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> MOVE_FLAGS = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13319);
    public static final TypedResource<TargetPosition> TARGET_POSITION = new TypedResource(RuneCraftory.modRes("target_position"));
    public final Predicate<class_1309> targetPred = e -> {
        if (e != this) {
            class_6025 ownable;
            if (this.followEntity() == null) {
                return false;
            }
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            if (e instanceof class_1308 && this == ((class_1308)e).method_5968()) {
                return true;
            }
            return e instanceof class_1569;
        }
        return false;
    };
    public final Predicate<class_1309> hitPred = e -> {
        if (e != this) {
            class_1308 mob;
            if (e == this.method_5968() || e instanceof class_1308 && this == (mob = (class_1308)e).method_5968()) {
                return true;
            }
            if (this.method_5626((class_1297)e) || !e.method_33190()) {
                return false;
            }
            class_1657 follow = this.followEntity();
            if (follow != null && e instanceof class_6025) {
                class_6025 ownable = (class_6025)e;
                if (follow.method_5667().equals(ownable.method_6139())) {
                    return false;
                }
            }
            return e instanceof class_1569;
        }
        return false;
    };
    private final AnimationHandler<NPCEntity> animationHandler = new AnimationHandler((class_1297)this, PlayerModelAnimations.ANIMS).withChangeListener(anim -> {
        if (!this.method_37908().field_9236) {
            if (anim != null) {
                if (this.method_5968() != null) {
                    this.method_5951((class_1297)this.method_5968(), 360.0f, 90.0f);
                    this.setTargetPosition(TargetPosition.of((class_1309)this.method_5968()));
                }
            } else {
                this.setTargetPosition(null);
            }
        }
        return false;
    });
    private final SyncedDataContainer<NPCEntity> syncedDataContainer = SyncedDataContainer.builder((class_1297)this).define(TARGET_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.TARGET_POS.get(), null).build();
    private final XpLevelHolder levelPair = new XpLevelHolder();
    private NPCProfession profession = (NPCProfession)RuneCraftoryNPCProfessions.NONE.get();
    private ReloadableHolder<NPCData> data = NPCData.DEFAULT;
    private ReloadableHolder<NPCLook> look = NPCLook.DEFAULT;
    public final NPCFeatureContainer lookFeatures = new NPCFeatureContainer();
    private ReloadableHolder<NPCAttackActions> attackActions;
    private Pair<Season, Integer> birthday = Pair.of((Object)((Object)Season.SPRING), (Object)1);
    private Map<String, ReloadableHolder<GiftData>> gifts;
    private final Random dataRandom = new Random();
    private int foodBuffTick;
    private int playDeathTick;
    private final NPCRelationManager relationManager = new NPCRelationManager();
    private int procreationCooldown;
    private int procreationProgress;
    private class_1297 procreationEntity;
    private Behaviour behaviour = Behaviour.WANDER;
    private class_1657 entityToFollow;
    private UUID entityToFollowUUID;
    private int tpCooldown;
    private final List<class_3222> interactingPlayers = new ArrayList<class_3222>();
    private int interactionMoveCooldown;
    private final NPCSchedule schedule = new NPCSchedule(this, this.method_59922());
    public final DailyNPCUpdater updater = new DailyNPCUpdater(this);
    public final WeaponHandler<NPCEntity> weaponHandler = new WeaponHandler<NPCEntity>(this, this::getAnimationHandler);
    private final MoveStateTracker moveStateTracker = new MoveStateTracker((class_1309)this, 5, MOVE_FLAGS, this::calculateMoveType);

    public NPCEntity(class_1299<? extends NPCEntity> type, class_1937 level) {
        super(type, level);
        this.levelPair.setLevel(1, lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl));
        this.applyAttributes(true);
    }

    public static class_5132.class_5133 createAttributes() {
        class_5132.class_5133 map = class_1588.method_26918().method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23717, 32.0);
        for (RegistryEntrySupplier<class_1320, ?> att : RuneCraftoryAttributes.ENTITY_ATTRIBUTES) {
            map.method_26867(att.asHolder());
        }
        for (RegistryEntrySupplier<class_1320, ?> att : RuneCraftoryAttributes.PLAYER_ATTRIBUTES) {
            map.method_26867(att.asHolder());
        }
        map.method_26868(RuneCraftoryAttributes.ATTACK_RANGE.asHolder(), 1.5);
        return map;
    }

    protected class_1408 method_5965(class_1937 level) {
        SmoothGroundNavigation nav = new SmoothGroundNavigation(this, (class_1308)this, level){

            @Nullable
            protected class_11 method_35142(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy) {
                return this.method_18416(targets, regionOffset, offsetUpward, accuracy, 100.0f);
            }

            protected class_13 method_6336(int i) {
                this.field_6678 = new NPCWalkNodeEvaluator();
                this.field_6678.method_15(true);
                return new class_13(this.field_6678, i);
            }
        };
        nav.method_6363(true);
        return nav;
    }

    protected void applyAttributes(boolean regenHealth) {
        if (this.data != null && this.data.value().baseStats() != null) {
            this.data.value().baseStats().forEach((att, d) -> {
                class_1324 inst = this.method_5996((class_6880)att);
                if (inst != null) {
                    inst.method_6192(d.doubleValue());
                    if (regenHealth && att == class_5134.field_23716) {
                        this.method_6033(this.method_6063());
                    }
                }
            });
            return;
        }
        class_1324 inst = this.method_5996(class_5134.field_23716);
        if (inst != null) {
            inst.method_6192(20.0);
            if (regenHealth) {
                this.method_6033(this.method_6063());
            }
        }
        if ((inst = this.method_5996(class_5134.field_23721)) != null) {
            inst.method_6192(1.0);
        }
        if ((inst = this.method_5996(RuneCraftoryAttributes.DEFENCE.asHolder())) != null) {
            inst.method_6192(0.0);
        }
        if ((inst = this.method_5996(RuneCraftoryAttributes.MAGIC_ATTACK.asHolder())) != null) {
            inst.method_6192(1.0);
        }
        if ((inst = this.method_5996(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder())) != null) {
            inst.method_6192(0.0);
        }
    }

    public void recalcStatsFull() {
        this.applyAttributes(true);
        this.updateStatsToLevel();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PLAY_DEATH_STATE, (Object)false);
        builder.method_56912(MALE, (Object)false);
        builder.method_56912(BEHAVIOUR_DATA, (Object)0);
        builder.method_56912(MOVE_FLAGS, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.method_37908().field_9236 && key.equals(BEHAVIOUR_DATA)) {
            try {
                this.behaviour = Behaviour.values()[(Integer)this.field_6011.method_12789(BEHAVIOUR_DATA)];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public SyncedDataContainer<?> getDataContainer() {
        return this.syncedDataContainer;
    }

    public List<? extends ExtendedSensor<? extends NPCEntity>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.targetPred.test((class_1309)target)).setScanRate(e -> 10), new HurtBySensor());
    }

    public BrainActivityGroup<? extends NPCEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FloatToSurfaceOfFluid(), new InvalidatePOITask<NPCEntity>((class_4140<class_4208>)class_4140.field_18438, (class_5321<class_4158>)class_7477.field_39291, NPCEntity::releaseBedPoi).isStillValid(AcquirePOITask.bedPredicate()), new AcquirePOITask<NPCEntity>((class_4140<class_4208>)class_4140.field_18438, (class_5321<class_4158>)class_7477.field_39291).canAquire(AcquirePOITask.bedPredicate().and(AcquirePOITask.withinRangeOf(NPCEntity::getWorkPlace))).onAqcuire(e -> e.method_37908().method_8421((class_1297)this, (byte)14)), new InvalidatePOITask<NPCEntity>((class_4140<class_4208>)class_4140.field_18439, m -> this.getProfession().matches((class_6880<class_4158>)m), NPCEntity::releaseWorkplacePoi), new AcquirePOITask<NPCEntity>((class_4140<class_4208>)class_4140.field_18439, m -> this.getProfession().matches((class_6880<class_4158>)m)).canAquire(AcquirePOITask.withinRangeOf(NPCEntity::getBedPos)).onAqcuire(e -> e.method_37908().method_8421((class_1297)this, (byte)15)).startCondition(m -> m.getProfession().hasPoi()), new InvalidatePOITask<NPCEntity>((class_4140<class_4208>)class_4140.field_18440, (class_5321<class_4158>)class_7477.field_39292, NPCEntity::releaseMeetingPoi), new AcquirePOITask((class_4140<class_4208>)class_4140.field_18440, (class_5321<class_4158>)class_7477.field_39292), new InvalidateMemory(class_4140.field_19008).invalidateIf((e, p) -> !e.method_37908().method_8419()), new FollowEntityEx<NPCEntity, class_1657>().startFollowingWhen((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 8.0 : 12.0).ignoreIfTargetingTill(20.0).stopFollowingWithin((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 2.0 : 6.0).teleportToTargetAfter((e, f) -> e.behaviourState() == Behaviour.FOLLOW ? 20.0 : 24.0).following(NPCEntity::followEntity).speedMod(1.05f).speedMod(1.1f).startCondition(m -> m.behaviourState() == Behaviour.FOLLOW || m.behaviourState() == Behaviour.FOLLOW_DISTANCE), new OpenDoors(), new AvoidEntity().avoiding(p -> p == BrainUtils.getMemory((class_1309)this, (class_4140)class_4140.field_18452)).speedModifier(1.2f).startCondition(m -> m.followEntity() == null), this.lookBehaviour(), new LookAtTarget().runFor(entity -> entity.method_59922().method_39332(40, 100)).whenStopping(m -> BrainUtils.clearMemory((class_1309)m, (class_4140)class_4140.field_18446))});
    }

    protected ExtendedBehaviour<? extends NPCEntity> lookBehaviour() {
        return new AllApplicableBehaviours(new ExtendedBehaviour[]{new LookAtInteractingPlayer(), new LookAtAttackTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomLookTarget().lookChance((class_5863)class_5862.method_33908((float)1.0f)), new SetPlayerLookTarget()}).startCondition(m -> (double)m.method_59922().method_43057() < 0.1 && !BrainUtils.hasMemory((class_1309)m, (class_4140)class_4140.field_18445))}).startCondition(e -> !BrainUtils.hasMemory((class_1309)e, (class_4140)class_4140.field_22355) && !e.method_6113() && !e.playDeath());
    }

    public BrainActivityGroup<? extends NPCEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{MonsterBehaviourUtils.moveTo(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetRainShelterTarget(), new TargetOrRetaliate(), new SetMoveToRestriction(), new SetRandomWalkTarget().startCondition(m -> m.method_59922().method_43048(120) == 0)})});
    }

    public BrainActivityGroup<? extends NPCEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget(), this.getAttackActions().value().create()});
    }

    public Map<class_4168, BrainActivityGroup<? extends NPCEntity>> getAdditionalTasks() {
        HashMap<class_4168, BrainActivityGroup<? extends NPCEntity>> map = new HashMap<class_4168, BrainActivityGroup<? extends NPCEntity>>();
        map.put((class_4168)RuneCraftoryActivities.STAY.get(), new BrainActivityGroup((class_4168)RuneCraftoryActivities.STAY.get()).priority(20).onlyStartWithMemoryStatus((class_4140)RuneCraftoryMemoryTypes.STAYING.get(), class_4141.field_18456).behaviours(new class_4097[]{new Idle()}));
        map.put(class_4168.field_18597, new BrainActivityGroup(class_4168.field_18597).priority(15).onlyStartWithMemoryStatus(class_4140.field_18438, class_4141.field_18456).behaviours(new class_4097[]{new SleepInBed(), new SetWalkTargetFromMemory<NPCEntity>((class_4140<class_4208>)class_4140.field_18438, NPCEntity::releaseBedPoi), MonsterBehaviourUtils.moveTo()}));
        map.put((class_4168)RuneCraftoryActivities.EARLY_IDLE.get(), new BrainActivityGroup((class_4168)RuneCraftoryActivities.EARLY_IDLE.get()).priority(15).onlyStartWithMemoryStatus(class_4140.field_18438, class_4141.field_18456).behaviours(new class_4097[]{new SetWalkTargetFromMemory<NPCEntity>((class_4140<class_4208>)class_4140.field_18438, NPCEntity::releaseBedPoi).closeEnough(10), MonsterBehaviourUtils.moveTo(), new SetWalkAroundPoiTarget((class_4140<class_4208>)class_4140.field_18438, 10.0).startCondition(m -> m.method_59922().method_43048(120) == 0)}));
        map.put(class_4168.field_18596, new BrainActivityGroup(class_4168.field_18596).priority(15).onlyStartWithMemoryStatus(class_4140.field_18439, class_4141.field_18456).behaviours(new class_4097[]{new SetWalkTargetFromMemory<NPCEntity>((class_4140<class_4208>)class_4140.field_18439, NPCEntity::releaseWorkplacePoi).closeEnough(3), MonsterBehaviourUtils.moveTo(), new SetWalkAroundPoiTarget((class_4140<class_4208>)class_4140.field_18439, 3.0).startCondition(m -> m.method_59922().method_43048(120) == 0)}));
        map.put(class_4168.field_18598, new BrainActivityGroup(class_4168.field_18598).priority(15).onlyStartWithMemoryStatus(class_4140.field_18440, class_4141.field_18456).behaviours(new class_4097[]{new SetRainShelterTarget(), new AllApplicableBehaviours(new ExtendedBehaviour[]{new SetWalkTargetFromMemory<NPCEntity>((class_4140<class_4208>)class_4140.field_18440, NPCEntity::releaseMeetingPoi).closeEnough(8), new SetWalkAroundPoiTarget((class_4140<class_4208>)class_4140.field_18440, 8.0).startCondition(m -> m.method_59922().method_43048(60) == 0)}).startCondition(e -> !e.method_37908().method_8419()), MonsterBehaviourUtils.moveTo()}));
        return map;
    }

    public SmartBrainSchedule getSchedule() {
        return NPCSchedule.forBrain(() -> this.schedule);
    }

    public List<class_4168> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new class_4168[]{(class_4168)RuneCraftoryActivities.STAY.get(), class_4168.field_22396, class_4168.field_18595});
    }

    public Set<class_4168> getScheduleIgnoringActivities() {
        return ObjectArraySet.of((Object[])new class_4168[]{class_4168.field_22396, (class_4168)RuneCraftoryActivities.STAY.get()});
    }

    protected void refreshBrain(class_3218 serverLevel) {
        class_4095 brain = this.method_18868();
        brain.method_18900(serverLevel, (class_1309)this);
        class_2487 memories = this.saveMemories();
        class_2509 nbtOps = class_2509.field_11560;
        this.field_18321 = this.method_18867(new Dynamic((DynamicOps)nbtOps, (Object)((class_2520)nbtOps.createMap((Map)ImmutableMap.of((Object)nbtOps.method_10639("memories"), (Object)((class_2520)nbtOps.emptyMap()))))));
        this.readMemories(memories);
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this, true);
    }

    @Override
    public float interpolatedMoveTick(float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTick(partialTicks);
    }

    @Override
    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        return this.moveStateTracker.interpolatedMoveTickOf(moveType, partialTicks);
    }

    public MoveType calculateMoveType() {
        if (this.method_5642() instanceof class_1657 || !this.field_42108.method_48571()) {
            return MoveType.NONE;
        }
        if (this.method_6062()) {
            return MoveType.NONE;
        }
        double d0 = this.method_5962().method_6242();
        MoveType move = d0 > 1.0 || this.method_5968() != null ? MoveType.RUN : (d0 <= 0.6 ? MoveType.SNEAK : MoveType.WALK);
        return move;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.field_6011.method_12778(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.method_37908().field_9236) {
            this.onSetBehaviour();
        }
    }

    private void onSetBehaviour() {
        if (this.behaviourState().following) {
            if (this.followEntity() != null) {
                ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.followEntity())).party.addPartyMember((class_1297)this);
            }
        } else {
            if (this.followEntity() != null) {
                ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)this.followEntity())).party.removePartyMember((class_1297)this);
            }
            this.method_5980(null);
        }
        this.method_5942().method_6340();
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean isStaying() {
        if (this.method_5816() || !this.method_24828()) {
            return false;
        }
        return !this.interactingPlayers.isEmpty() || this.interactionMoveCooldown > 0 || this.behaviourState() == Behaviour.STAY;
    }

    public void interactWithPlayer(class_3222 player) {
        this.interactingPlayers.add(player);
        this.method_5942().method_6340();
    }

    public void decreaseInteractingPlayers(class_3222 player) {
        this.interactingPlayers.remove(player);
        this.interactionMoveCooldown = 40;
    }

    public class_3222 getLastInteractedPlayer() {
        if (this.interactingPlayers.isEmpty()) {
            return null;
        }
        return this.interactingPlayers.getLast();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("BrainMemories", (class_2520)this.saveMemories());
        compound.method_10566("MobLevel", (class_2520)this.xpLevel().save());
        compound.method_10569("FoodBuffTick", this.foodBuffTick);
        compound.method_10556("PlayDeath", ((Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE)).booleanValue());
        compound.method_10566("RelationManager", (class_2520)this.relationManager.save());
        if (this.entityToFollowUUID != null) {
            compound.method_25927("EntityToFollow", this.entityToFollowUUID);
        }
        compound.method_10569("Behaviour", this.behaviourState().ordinal());
        compound.method_10566("NPCData", (class_2520)this.saveNPCData());
        compound.method_10566("DailyUpdater", (class_2520)this.updater.save());
        compound.method_10569("ProcreationCooldown", this.procreationCooldown);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.readMemories(compound.method_10562("BrainMemories"));
        this.levelPair.read((class_2520)compound.method_10562("MobLevel"));
        this.foodBuffTick = compound.method_10550("FoodBuffTick");
        this.setPlayDeath(compound.method_10577("PlayDeath"));
        this.relationManager.load(compound.method_10562("RelationManager"));
        if (compound.method_25928("EntityToFollow")) {
            this.entityToFollowUUID = compound.method_25926("EntityToFollow");
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.method_10550("Behaviour")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (compound.method_10545("NPCData")) {
            this.loadNpcData(compound.method_10562("NPCData"));
        }
        this.updater.read(compound.method_10562("DailyUpdater"));
        this.procreationCooldown = compound.method_10550("ProcreationCooldown");
    }

    protected class_2487 saveMemories() {
        class_4208 meeting;
        class_4208 workPlace;
        class_2487 tag = new class_2487();
        class_4208 bed = this.getBedPos();
        if (bed != null) {
            tag.method_10566("BedPos", (class_2520)class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)bed).getOrThrow());
        }
        if ((workPlace = this.getWorkPlace()) != null) {
            tag.method_10566("WorkPos", (class_2520)class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)workPlace).getOrThrow());
        }
        if ((meeting = this.getMeetingPos()) != null) {
            tag.method_10566("MeetingPos", (class_2520)class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)meeting).getOrThrow());
        }
        return tag;
    }

    protected void readMemories(class_2487 tag) {
        class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("BedPos")).result().ifPresent(pos -> BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_18438, (Object)pos));
        class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("WorkPos")).result().ifPresent(pos -> BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_18439, (Object)pos));
        class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("MeetingPos")).result().ifPresent(pos -> BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_18440, (Object)pos));
    }

    private class_2487 saveNPCData() {
        class_2487 tag = new class_2487();
        tag.method_10582("Data", this.data.id().toString());
        tag.method_10582("Look", this.getLook().id().toString());
        tag.method_10566("Profession", (class_2520)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_39673().encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getProfession()).getOrThrow());
        tag.method_10556("Male", this.isMale());
        tag.method_10569("BirthdayMonth", ((Season)((Object)this.getBirthday().getFirst())).ordinal());
        tag.method_10569("Birthday", ((Integer)this.getBirthday().getSecond()).intValue());
        tag.method_10582("Combat", this.getAttackActions().id().toString());
        tag.method_10566("Schedule", (class_2520)this.schedule.save());
        tag.method_10566("LookFeatures", this.lookFeatures.save((class_7225.class_7874)this.method_56673()));
        class_2487 gifts = new class_2487();
        this.gifts.forEach((s, g) -> gifts.method_10582(s, g.id().toString()));
        tag.method_10566("GiftData", (class_2520)gifts);
        return tag;
    }

    private void loadNpcData(class_2487 tag) {
        ReloadableHolder<NPCData> data = DataPackHandler.INSTANCE.npcDataManager().get(class_2960.method_60654((String)tag.method_10558("Data")));
        this.look = DataPackHandler.INSTANCE.npcLookManager().get(class_2960.method_60654((String)tag.method_10558("Look")));
        this.setProfession((NPCProfession)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_39673().parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Profession")).getOrThrow());
        this.setMale(tag.method_10577("Male"));
        try {
            Season month = Season.values()[tag.method_10550("BirthdayMonth")];
            this.birthday = Pair.of((Object)((Object)month), (Object)tag.method_10550("Birthday"));
        }
        catch (IllegalArgumentException e) {
            this.getBirthday();
        }
        this.attackActions = DataPackHandler.INSTANCE.npcActionsManager().get(class_2960.method_60654((String)tag.method_10558("Combat")));
        this.schedule.load(tag.method_10562("Schedule"));
        try {
            this.lookFeatures.read(tag.method_10580("LookFeatures"), (class_7225.class_7874)this.method_56673());
        }
        catch (Exception e) {
            this.lookFeatures.buildFromLooks(this, this.look.value());
        }
        class_2487 gifts = tag.method_10562("GiftData");
        ImmutableMap.Builder b = ImmutableMap.builder();
        gifts.method_10541().forEach(key -> {
            ReloadableHolder<GiftData> giftData = DataPackHandler.INSTANCE.giftManager().get(class_2960.method_60654((String)gifts.method_10558(key)));
            if (giftData != null) {
                b.put(key, giftData);
            }
        });
        this.gifts = b.build();
        this.setNPCData(data, true);
    }

    public void method_5773() {
        if (this.field_5953 && this.method_5682() != null) {
            NPCHandler handler = RunecraftorySavedData.get((MinecraftServer)this.method_5682()).npcHandler;
            handler.addNPC(this);
            handler.playersToReset(this.method_5667()).forEach(pair -> this.relationManager.resetQuest((UUID)pair.getFirst(), (class_2960)pair.getSecond()));
        }
        super.method_5773();
    }

    public void method_6007() {
        this.method_6119();
        this.getAnimationHandler().tick();
        this.weaponHandler.tick();
        super.method_6007();
        boolean teleported = false;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1657 follow;
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (follow = this.followEntity()) != null) {
                serverLevel.method_14178().method_17297(WorldUtils.ENTITY_LOADER, this.method_31476(), 3, (Object)this.method_31476());
                if (!follow.method_37908().method_27983().equals(this.method_37908().method_27983())) {
                    TeleportUtils.safeDimensionTeleport((class_1308)this, (class_3218)follow.method_37908(), follow.method_24515());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (follow.method_5858((class_1297)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((class_1308)this, (class_1297)follow);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
            --this.procreationCooldown;
            if (this.procreationProgress > 0) {
                this.method_5942().method_6340();
                --this.procreationProgress;
                if (this.field_6012 % 10 == 0) {
                    serverLevel.method_14199((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + (double)this.method_17682(), this.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.procreationProgress == 0) {
                    if (this.spawnBaby()) {
                        this.procreationCooldown = MobConfig.procreationCooldown;
                    }
                    this.procreationEntity = null;
                }
            }
            if (this.field_6012 % 10 == 0) {
                this.interactingPlayers.removeIf(p -> p.method_5858((class_1297)this) > 100.0);
            }
            --this.interactionMoveCooldown;
            this.updater.tick();
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
        }
        this.moveStateTracker.tick();
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.method_37908().field_9236) {
                if (teleported) {
                    this.method_6025(1.0f);
                }
                if ((double)this.method_6032() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
        this.weaponHandler.postTick();
    }

    public void method_5958() {
        super.method_5958();
        this.tickBrain((class_1309)this);
        if (this.lookFeatures.updateLooks(this, this.getLook().value())) {
            LoaderNetwork.INSTANCE.sendToTracking((class_8710)new S2CNPCLook(this.method_5628(), this.look, this.lookFeatures), (class_1297)this);
            for (int i = 0; i < 20; ++i) {
                AdvancedParticleContainer.make((class_2394)class_2398.field_11203).addData((AdvancedParticleData)new ScaleData(0.15f)).addData((AdvancedParticleData)new MotionData(this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01, this.field_5974.method_43059() * 0.01)).add(this.method_37908(), this.method_23322(0.9), this.method_23319(), this.method_23325(0.9));
            }
            this.method_43077((class_3414)RuneCraftorySounds.ENTITY_NPC_CHANGE.get());
        }
        if (this.field_6012 % 10 == 0) {
            if (this.isStaying()) {
                BrainUtils.setMemory((class_1309)this, (class_4140)((class_4140)RuneCraftoryMemoryTypes.STAYING.get()), (Object)class_3902.field_17274);
            } else {
                BrainUtils.clearMemory((class_1309)this, (class_4140)((class_4140)RuneCraftoryMemoryTypes.STAYING.get()));
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 14) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11211);
        } else if (id == 15) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11207);
        } else {
            super.method_5711(id);
        }
    }

    protected void addParticlesAroundSelf(class_2394 particleData) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(particleData, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_3222 serverPlayer;
        block6: {
            block5: {
                if (!(player instanceof class_3222)) break block5;
                serverPlayer = (class_3222)player;
                if (!player.method_5998(hand).method_31574((class_1792)RuneCraftoryItems.DEBUG.get())) break block6;
            }
            return class_1269.field_5811;
        }
        if (this.method_6113()) {
            return class_1269.field_21466;
        }
        if (this.getEntityToFollowUUID() != null && this.getEntityToFollowUUID().equals(serverPlayer.method_5667())) {
            EntityUtils.sendAttributesTo((class_1309)this, serverPlayer);
        }
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CUpdateNPCData(this, this.relationManager.getFriendPointData(player.method_5667()).save()), serverPlayer);
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2COpenNPCGui(this, serverPlayer), serverPlayer);
        this.interactWithPlayer(serverPlayer);
        this.method_5951((class_1297)serverPlayer, 30.0f, 30.0f);
        return class_1269.field_21466;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (this.method_5682() != null) {
            this.getFamily().updateName((class_1297)this);
            RunecraftorySavedData.get((MinecraftServer)this.method_5682()).npcHandler.addNPC(this);
        }
    }

    @Nullable
    public class_1799 method_31480() {
        return SpawnEgg.fromType((class_1299)this.method_5864()).map(class_1799::new).orElse(class_1799.field_8037);
    }

    @Override
    public boolean onGivingItem(class_1657 player, class_1799 stack) {
        this.giftItem(player, stack);
        return true;
    }

    public void giftItem(class_1657 player, class_1799 stack) {
        class_5151 equipable;
        class_1304 slot;
        class_3414 sound;
        this.method_5951((class_1297)player, 30.0f, 30.0f);
        int count = stack.method_7947();
        switch (stack.method_7976()) {
            case field_8946: {
                class_3414 class_34142 = stack.method_21832();
                break;
            }
            case field_8950: {
                class_3414 class_34142 = stack.method_21833();
                break;
            }
            default: {
                class_3414 class_34142 = sound = (class_3414)class_3417.field_14622.comp_349();
            }
        }
        if (stack.method_7909() == RuneCraftoryItems.DIVORCE_PAPER.get()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FamilyEntry family = this.getFamily();
                if (player.method_5667().equals(family.getPartner())) {
                    this.speak(serverPlayer, ConversationContext.DIVORCE);
                    family.updateRelationship(FamilyEntry.Relationship.NONE, null);
                    this.relationManager.getFriendPointData((UUID)player.method_5667()).points.addXP(-2000.0f, 10, lvl -> GeneralConfig.friendPointsExperience.xpAmountForNext(lvl), () -> {});
                } else {
                    this.speak(serverPlayer, ConversationContext.DIVORCE_ERROR);
                }
                stack.method_7934(1);
            }
            return;
        }
        if (stack.method_7909() == RuneCraftoryItems.LOVE_LETTER.get()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FamilyHandler families = FamilyHandler.get(this.method_5682());
                FamilyEntry playerEntry = families.getOrCreateEntry((class_1657)serverPlayer);
                FamilyEntry family = families.getOrCreateEntry(this);
                boolean success = false;
                if (playerEntry.getRelationship() != FamilyEntry.Relationship.NONE || family.getRelationship() != FamilyEntry.Relationship.NONE) {
                    this.speak(serverPlayer, ConversationContext.DATING_DENY);
                } else {
                    float chance;
                    float f = chance = this.friendPoints(player) >= 7 ? 0.33f * (float)(this.friendPoints(player) - 6) : 0.0f;
                    if (chance > 0.0f && this.updater.getDailyRandom().nextFloat() < chance) {
                        this.speak(serverPlayer, ConversationContext.DATING_ACCEPT);
                        family.updateRelationship(FamilyEntry.Relationship.DATING, player.method_5667());
                        success = true;
                    } else {
                        this.speak(serverPlayer, ConversationContext.DATING_DENY);
                    }
                }
                if (!success) {
                    player.method_7270(stack);
                } else {
                    stack.method_7934(1);
                }
            }
            return;
        }
        if (stack.method_7909() == RuneCraftoryItems.ENGAGEMENT_RING.get()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FamilyHandler families = FamilyHandler.get(this.method_5682());
                FamilyEntry playerEntry = families.getOrCreateEntry((class_1657)serverPlayer);
                FamilyEntry family = families.getOrCreateEntry(this);
                boolean success = false;
                if (playerEntry.getRelationship() != FamilyEntry.Relationship.NONE && !this.method_5667().equals(playerEntry.getPartner()) || family.getPartner() == null || !family.getPartner().equals(player.method_5667())) {
                    this.speak(serverPlayer, ConversationContext.MARRIAGE_DENY);
                } else if (family.getRelationship() == FamilyEntry.Relationship.DATING) {
                    float chance;
                    float f = chance = this.friendPoints(player) >= 10 ? 0.2f * (float)(this.friendPoints(player) - 9) : 0.0f;
                    if (chance > 0.0f && this.relationManager.getCompletedQuests(player.method_5667()).containsAll(this.data.value().questHandler().requiredQuests()) && this.updater.getDailyRandom().nextFloat() < chance) {
                        this.speak(serverPlayer, ConversationContext.MARRIAGE_ACCEPT);
                        family.updateRelationship(FamilyEntry.Relationship.MARRIED, player.method_5667());
                        success = true;
                        this.procreationCooldown = MobConfig.initialProcreationCooldown;
                    } else {
                        this.speak(serverPlayer, ConversationContext.MARRIAGE_DENY);
                    }
                }
                if (!success) {
                    player.method_7270(stack);
                } else {
                    stack.method_7934(1);
                }
            }
            return;
        }
        float mult = 1.0f;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Calendar calendar = Calendar.get(serverPlayer.method_37908());
            if (calendar.currentSeason() == this.birthday.getFirst() && calendar.date().date() == ((Integer)this.birthday.getSecond()).intValue()) {
                mult = 3.0f;
            }
            EntityUtils.playSoundForPlayer(serverPlayer, sound, class_3419.field_15254, 0.7f, 1.0f);
        }
        class_1304 class_13042 = slot = (equipable = class_5151.method_48957((class_1799)stack)) != null ? equipable.method_7685() : null;
        if (slot != class_1304.field_6173 || ItemComponentUtils.isWeapon(stack) || stack.method_7909() instanceof class_1829 || stack.method_7909() instanceof class_1743) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            this.method_5673(slot == null ? class_1304.field_6173 : slot, copy);
        }
        this.applyFoodEffect(stack);
        stack.method_7939(count);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            NPCData.Gift gift = this.giftOf(stack);
            if (gift != null) {
                if (this.relationManager.getFriendPointData(player.method_5667()).giftXP(this.method_37908(), (int)((float)gift.xp() * mult))) {
                    this.tellDialogue(serverPlayer, null, null, (class_2561)class_2561.method_43471((String)gift.responseKey()), List.of());
                }
            } else if (this.relationManager.getFriendPointData(player.method_5667()).giftXP(this.method_37908(), (int)(5.0f * mult))) {
                this.tellDialogue(serverPlayer, null, null, (class_2561)class_2561.method_43471((String)this.data.value().neutralGiftResponse()), List.of());
            }
        }
        stack.method_7934(1);
    }

    public void talkTo(class_3222 player) {
        ConversationContext ctx = ConversationContext.TALK;
        NPCFriendPoints fp = this.relationManager.getFriendPointData(player.method_5667());
        boolean talkedTo = fp.talked();
        boolean doGreet = fp.talkTo(this.method_37908(), 15);
        if (!talkedTo) {
            ctx = ConversationContext.FIRST_TALK;
        } else if (doGreet) {
            ctx = ConversationContext.GREETING;
        }
        this.speak(player, ctx);
    }

    public void speak(class_3222 player, ConversationContext convCtx) {
        int heart = this.relationManager.getFriendPointData((UUID)player.method_5667()).points.getLevel();
        ConversationSet conversations = this.data.value().getConversation(convCtx);
        class_8567 ctx = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_51871(player.method_7292()).method_51875(LootCtxParameters.NPC_INTERACTION);
        class_47 lootContext = new class_47.class_48(ctx).method_309(Optional.empty());
        List filtered = conversations.conversations().entrySet().stream().filter(c -> {
            if (((ConversationSet.Conversation)c.getValue()).actions().stream().anyMatch(h -> h.action() == ConversationSet.ConversationAction.QUEST) && QuestHandler.questForExists(player, this) != null && !this.updater.alreadyAcceptedRandomquest(player)) {
                return false;
            }
            return ((ConversationSet.Conversation)c.getValue()).startingConversation() && ((ConversationSet.Conversation)c.getValue()).test(heart, lootContext);
        }).collect(Collectors.toList());
        Collections.shuffle(filtered, this.updater.getDailyRandom());
        int size = Math.min(filtered.size(), 2 + this.updater.getDailyRandom().nextInt(2));
        if (size > 0) {
            Map.Entry randomLine = (Map.Entry)filtered.get(this.field_5974.method_43048(size));
            this.tellDialogue(player, convCtx, (String)randomLine.getKey(), (ConversationSet.Conversation)randomLine.getValue());
        } else {
            class_5250 dialog = conversations.missing() != null ? class_2561.method_43469((String)conversations.fallbackKey(), (Object[])new Object[]{conversations.missing()}) : class_2561.method_43471((String)conversations.fallbackKey());
            this.tellDialogue(player, convCtx, null, (class_2561)dialog, List.of());
        }
    }

    public void respondToQuest(class_3222 player, class_2960 quest) {
        QuestHandler.getData(player).trigger(NPCTalkTracker.KEY, this);
        QuestState result = QuestHandler.checkCompletionQuest(player, this);
        int questState = this.relationManager.questStateFor(player.method_5667(), quest);
        QuestConversationContext questCtx = QuestConversationContext.NOT_STARTED;
        if (questState != -1) {
            questCtx = QuestConversationContext.IN_PROGRESS;
            if (result == QuestState.COMPLETE) {
                this.relationManager.endQuest(player.method_5667(), quest);
                questState = -2;
                questCtx = QuestConversationContext.COMPLETED;
            } else if (result == QuestState.PARTIAL_COMPLETE) {
                questState = this.relationManager.advanceQuest(player.method_5667(), quest);
                questCtx = QuestConversationContext.NOT_STARTED;
            }
        } else {
            this.relationManager.advanceQuest(player.method_5667(), quest);
        }
        int heart = this.relationManager.getFriendPointData((UUID)player.method_5667()).points.getLevel();
        ConversationSet conversations = this.data.value().getFromQuest(quest, questCtx, questState);
        class_8567 ctx = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_51871(player.method_7292()).method_51875(LootCtxParameters.NPC_INTERACTION);
        class_47 lootContext = new class_47.class_48(ctx).method_309(Optional.empty());
        List filtered = conversations.conversations().entrySet().stream().filter(c -> ((ConversationSet.Conversation)c.getValue()).startingConversation() && ((ConversationSet.Conversation)c.getValue()).test(heart, lootContext)).collect(Collectors.toList());
        Collections.shuffle(filtered, this.updater.getDailyRandom());
        int size = Math.min(filtered.size(), 2 + this.updater.getDailyRandom().nextInt(2));
        if (size > 0) {
            Map.Entry randomLine = (Map.Entry)filtered.get(this.field_5974.method_43048(size));
            this.tellDialogue(player, null, (String)randomLine.getKey(), (ConversationSet.Conversation)randomLine.getValue());
        } else {
            class_5250 dialog = conversations.missing() != null ? class_2561.method_43469((String)conversations.fallbackKey(), (Object[])new Object[]{conversations.missing()}) : class_2561.method_43471((String)conversations.fallbackKey());
            this.tellDialogue(player, null, null, (class_2561)dialog, List.of());
        }
    }

    private void tellDialogue(class_3222 player, ConversationContext convCtx, String conversationID, ConversationSet.Conversation conversation) {
        List<class_2561> actions = conversation.actions().stream().map(e -> class_2561.method_43471((String)e.translationKey())).toList();
        this.tellDialogue(player, convCtx, conversationID, (class_2561)class_2561.method_43471((String)conversation.translationKey()), actions);
    }

    private void tellDialogue(class_3222 player, ConversationContext convCtx, String conversationID, class_2561 component, List<class_2561> actions) {
        this.interactWithPlayer(player);
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CNpcDialogue(this.method_5628(), convCtx, conversationID, component, this.conversationData(player), actions), player);
    }

    private Map<String, class_2561> conversationData(class_3222 player) {
        HashMap<String, class_2561> map = new HashMap<String, class_2561>();
        map.put(PlaceHolderComponent.NPC, this.method_5476());
        map.put(PlaceHolderComponent.PLAYER, player.method_5476());
        this.randomGiftContext(15, Integer.MAX_VALUE).ifPresent(comp -> map.put(PlaceHolderComponent.FAVORITE, (class_2561)comp));
        this.randomGiftContext(7, 14).ifPresent(comp -> map.put(PlaceHolderComponent.LIKE, (class_2561)comp));
        this.randomGiftContext(-14, -1).ifPresent(comp -> map.put(PlaceHolderComponent.DISLIKE, (class_2561)comp));
        this.randomGiftContext(Integer.MIN_VALUE, -15).ifPresent(comp -> map.put(PlaceHolderComponent.HATE, (class_2561)comp));
        return map;
    }

    public void handleDialogueAction(class_3222 sender, ConversationContext convCtx, String conversationID, int actionIdx) {
        ConversationSet.ConversationActionHolder action;
        ConversationSet conversations = this.data.value().getConversation(convCtx);
        ConversationSet.Conversation conversation = conversations.conversations().get(conversationID);
        if (conversation != null && actionIdx < conversation.actions().size() && (action = conversation.actions().get(actionIdx)) != null) {
            switch (action.action()) {
                case ANSWER: {
                    ConversationSet.Conversation answer = conversations.conversations().get(action.actionValue());
                    if (answer == null) break;
                    this.relationManager.getFriendPointData(sender.method_5667()).answer(conversationID, action.friendXP());
                    this.tellDialogue(sender, convCtx, action.actionValue(), answer);
                    break;
                }
                case QUEST: {
                    QuestHandler.acceptQuestRandom(sender, this, class_2960.method_60654((String)action.actionValue()));
                }
            }
        }
    }

    public void closedDialogue(class_3222 sender) {
        this.decreaseInteractingPlayers(sender);
    }

    public void closedQuestDialogue(class_3222 sender) {
        this.closedDialogue(sender);
        class_2960 quest = QuestHandler.questForExists(sender, this);
        if (quest != null && this.relationManager.questStateFor(sender.method_5667(), quest) == -2) {
            QuestHandler.getData(sender).submit(this);
        }
    }

    public void resetQuestProcess(class_3222 player, class_2960 quest) {
        this.relationManager.resetQuest(player.method_5667(), quest);
    }

    public void completeNPCQuest(class_3222 player, NPCQuest quest) {
        this.relationManager.completeQuest(player.method_5667(), quest.getOriginID());
    }

    public boolean canAcceptNPCQuest(class_3222 player, NPCQuest quest) {
        return this.relationManager.getCompletedQuests(player.method_5667()).containsAll(quest.neededParentQuests);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 follow;
        if (this.playDeath() && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (this.followEntity() != null && source.method_5529() != null && ((follow = this.followEntity()).equals((Object)source.method_5529()) || ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)follow)).party.isPartyMember(source.method_5529()))) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    protected void method_6074(class_1282 source, float damageAmount) {
        FamilyEntry family;
        super.method_6074(source, damageAmount);
        if (!source.method_48789(class_8103.field_42242) && this.method_6032() <= 0.0f && (this.followEntity() != null || (family = this.getFamily()) != null && family.getPartner() != null && FamilyHandler.get(this.method_5682()).getFamily(family.getPartner()).map(FamilyEntry::isPlayer).orElse(false).booleanValue())) {
            this.method_6033(0.01f);
            this.setPlayDeath(true);
        }
    }

    public boolean method_6121(class_1297 entity) {
        return NPCEntity.attack((class_1309)this, entity);
    }

    public static boolean attack(class_1309 attacker, class_1297 target) {
        class_1799 stack = attacker.method_6047();
        DynamicDamage.Builder source = new DynamicDamage.Builder((class_1297)attacker).hurtResistant(0).element(ItemComponentUtils.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    protected class_238 method_53511() {
        double reach = this.method_45325(RuneCraftoryAttributes.ATTACK_RANGE.asHolder()) - (Math.sqrt(2.04) - 0.6);
        return super.method_53511().method_1014(reach);
    }

    public void handleAttack(AnimationState anim) {
        this.method_5942().method_6340();
    }

    public AnimationHandler<NPCEntity> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<class_1309> validTargetPredicate() {
        return this.hitPred;
    }

    public void setTargetPosition(TargetPosition target) {
        this.syncedDataContainer.set(TARGET_POSITION, (Object)target);
    }

    @Override
    public TargetPosition getTargetPosition() {
        return (TargetPosition)this.syncedDataContainer.get(TARGET_POSITION);
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public void method_5837(class_3222 player) {
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CNPCLook(this.method_5628(), this.look, this.lookFeatures), player);
        LoaderNetwork.INSTANCE.sendToPlayer((class_8710)S2CEntityLevelPkt.create(this), player);
    }

    public void method_31744(class_5569 levelCallback) {
        super.method_31744(WorldUtils.wrappedCallbackFor(this, this::followEntity, levelCallback));
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData) {
        this.randomizeData(null, true);
        return super.method_5943(level, difficulty, reason, spawnData);
    }

    public void method_6078(class_1282 cause) {
        RuneCraftory.LOGGER.info("NPC {} died, message: '{}'", (Object)this, (Object)cause.method_5506((class_1309)this).getString());
        if (!this.method_37908().field_9236) {
            this.getAnimationHandler().setAnimation(null);
        }
        super.method_6078(cause);
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.releaseBedPoi();
        this.releaseWorkplacePoi();
        this.releaseMeetingPoi();
        super.method_5650(reason);
        if (this.method_5682() != null) {
            NPCHandler handler = RunecraftorySavedData.get((MinecraftServer)this.method_5682()).npcHandler;
            if (reason.method_31486() && this.data != null && this.data.value().unique() > 0) {
                handler.removeUniqueNPC(this.method_5667(), this.data);
            }
            handler.removeNPC(this, reason);
        }
    }

    public boolean playDeath() {
        return (Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE);
    }

    public void setPlayDeath(boolean flag) {
        this.field_6011.method_12778(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            class_1657 partner;
            if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.followEntity() == null && (partner = this.getPartner()) instanceof class_3222) {
                partner.method_7353(this.getKnockoutMessage(), false);
            }
            this.method_37908().method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> this.equals(e.method_5968())).forEach(m -> m.method_5980(null));
            this.method_5942().method_6340();
            this.method_5660(false);
            this.method_5728(false);
            this.method_18375();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private class_2561 getKnockoutMessage() {
        class_1282 source = this.method_6081();
        if (source != null && source.method_5529() != null) {
            return class_2561.method_43469((String)"runecraftory.tamed.monster.knockout.by", (Object[])new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260(), source.method_5529().method_5476()});
        }
        return class_2561.method_43469((String)"runecraftory.tamed.monster.knockout", (Object[])new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260()});
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public boolean method_33190() {
        return super.method_33190() && !this.playDeath();
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5782() || this.playDeath();
    }

    @Override
    public XpLevelHolder xpLevel() {
        return this.levelPair;
    }

    @Override
    public void setXPLevel(int level) {
        this.xpLevel().setLevel(class_3532.method_15340((int)level, (int)1, (int)10000), lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl));
        this.updateStatsToLevel();
    }

    public void increaseLevel() {
        this.xpLevel().setLevel(class_3532.method_15340((int)(this.xpLevel().getLevel() + 1), (int)1, (int)10000), lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl));
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        boolean res = this.xpLevel().addXP(amount, 10000, lvl -> GeneralConfig.experienceLevel.xpAmountForNext(lvl), () -> {});
        LoaderNetwork.INSTANCE.sendToTracking((class_8710)S2CEntityLevelPkt.create(this), (class_1297)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateStatsToLevel() {
        float levelBonus;
        if (!this.method_37908().field_9236) {
            LoaderNetwork.INSTANCE.sendToTracking((class_8710)S2CEntityLevelPkt.create(this), (class_1297)this);
        }
        float preHealthDiff = this.method_6063() - this.method_6032();
        ((AttributeMapAccessor)this.method_6127()).getAttributes().forEach((att, inst) -> inst.method_6200(LibConstants.MONSTER_LEVEL_MODIFIER));
        if (this.data != null) {
            Map<class_6880<class_1320>, Double> gain = this.data.value().statIncrease() != null ? this.data.value().statIncrease() : NPCData.DEFAULT_GAIN;
            gain.forEach((att, val) -> {
                val = val * 0.01;
                class_1324 inst = this.method_5996((class_6880)att);
                if (inst != null) {
                    float levelBonus = att == class_5134.field_23716 ? LevelCalc.getIntervalledMultiplier(this.xpLevel().getLevel(), 25, 100.0f, 1.0f) : LevelCalc.getIntervalledMultiplier(this.xpLevel().getLevel(), 50, 100.0f, 1.0f);
                    inst.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * val, class_1322.class_1323.field_6328));
                    if (att == class_5134.field_23716) {
                        this.method_6033(this.method_6063() - preHealthDiff);
                    }
                }
            });
            return;
        }
        class_1324 inst2 = this.method_5996(class_5134.field_23716);
        if (inst2 != null) {
            levelBonus = LevelCalc.getIntervalledMultiplier(this.xpLevel().getLevel(), 25, 100.0f, 0.5f);
            inst2.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * 5.0, class_1322.class_1323.field_6328));
            this.method_6033(this.method_6063() - preHealthDiff);
        }
        levelBonus = LevelCalc.getIntervalledMultiplier(this.xpLevel().getLevel(), 50, 100.0f, 0.5f);
        inst2 = this.method_5996(class_5134.field_23721);
        if (inst2 != null) {
            inst2.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * 0.5, class_1322.class_1323.field_6328));
        }
        if ((inst2 = this.method_5996(RuneCraftoryAttributes.DEFENCE.asHolder())) != null) {
            inst2.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * (double)0.2f, class_1322.class_1323.field_6328));
        }
        if ((inst2 = this.method_5996(RuneCraftoryAttributes.MAGIC_ATTACK.asHolder())) != null) {
            inst2.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * 0.5, class_1322.class_1323.field_6328));
        }
        if ((inst2 = this.method_5996(RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder())) != null) {
            inst2.method_26837(new class_1322(LibConstants.MONSTER_LEVEL_MODIFIER, (double)((float)(this.xpLevel().getLevel() - 1) + levelBonus) * (double)0.2f, class_1322.class_1323.field_6328));
        }
    }

    @Override
    public int friendPoints(UUID uuid) {
        return this.relationManager.getFriendPointData((UUID)uuid).points.getLevel();
    }

    public int talkCount(UUID uuid) {
        return this.relationManager.getFriendPointData(uuid).getTalkCount();
    }

    @Override
    public int baseXP() {
        return 0;
    }

    @Override
    public int baseMoney() {
        return 0;
    }

    @Nullable
    public FamilyEntry getFamily() {
        if (this.method_5682() != null) {
            return FamilyHandler.get(this.method_5682()).getOrCreateEntry(this);
        }
        return null;
    }

    @Nullable
    public class_1657 getPartner() {
        FamilyEntry family = this.getFamily();
        if (family != null && family.getPartner() != null && family.hasPlayerRelationShip()) {
            return this.method_5682().method_3760().method_14602(family.getPartner());
        }
        return null;
    }

    public FamilyEntry.Relationship relationFor(UUID player) {
        FamilyEntry entry = this.getFamily();
        if (entry != null && player.equals(entry.getPartner())) {
            return entry.getRelationship();
        }
        return FamilyEntry.Relationship.NONE;
    }

    @Override
    public boolean applyFoodEffect(class_1799 stack) {
        FoodProperties food;
        if (this.method_37908().field_9236) {
            return false;
        }
        if (stack.method_7909() == RuneCraftoryItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((class_1309)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909())) == null) {
            class_4174 mcFood = (class_4174)stack.method_57824(class_9334.field_50075);
            this.method_60492(this.method_37908(), stack);
            if (mcFood != null) {
                this.method_6025((float)mcFood.comp_2491() * 0.5f);
                return true;
            }
            return false;
        }
        this.method_60492(this.method_37908(), stack);
        Pair<Map<class_6880<class_1320>, Double>, Map<class_6880<class_1320>, Double>> foodStats = ItemComponentUtils.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            class_1324 inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.method_5996((class_6880)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_MODIFIER_MULTI);
                inst.method_26837(new class_1322(LibConstants.FOOD_MODIFIER_MULTI, ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6330));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.method_5996((class_6880)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_MODIFIER);
                inst.method_26837(new class_1322(LibConstants.FOOD_MODIFIER, ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6328));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((class_1309)this, food.getHPGain());
        EntityUtils.foodHealing((class_1309)this, this.method_6063() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (class_6880 class_68802 : food.potionHeals()) {
                this.method_6016(class_68802);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.method_6092(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.method_6127()).getAttributes().values().forEach(inst -> {
            inst.method_6200(LibConstants.FOOD_MODIFIER);
            inst.method_6200(LibConstants.FOOD_MODIFIER_MULTI);
        });
    }

    public NPCProfession getProfession() {
        return this.profession;
    }

    public void setProfession(NPCProfession profession) {
        this.profession = profession;
    }

    public void handleUpdatePacket(class_1657 player, class_2487 friendPoints, class_2487 schedule, NPCProfession profession) {
        if (this.method_37908().field_9236) {
            this.relationManager.getFriendPointData(player.method_5667()).load(friendPoints);
            this.schedule.load(schedule);
            this.setProfession(profession);
        }
    }

    public class_4168 getActivity() {
        return this.method_18868().method_24538().orElse(null);
    }

    public NPCSchedule getNPCSchedule() {
        return this.schedule;
    }

    public class_4208 getWorkPlace() {
        return this.method_18868().method_18904(class_4140.field_18439).orElse(null);
    }

    public void releaseWorkplacePoi() {
        if (this.getProfession().hasPoi()) {
            this.releasePoi((class_4140<class_4208>)class_4140.field_18439, this.getProfession()::matches);
        }
    }

    public class_4208 getBedPos() {
        return this.method_18868().method_18904(class_4140.field_18438).orElse(null);
    }

    public void releaseBedPoi() {
        this.releasePoi((class_4140<class_4208>)class_4140.field_18438, h -> h.method_40225(class_7477.field_39291));
    }

    public class_4208 getMeetingPos() {
        return this.method_18868().method_18904(class_4140.field_18440).orElse(null);
    }

    public void releaseMeetingPoi() {
        this.releasePoi((class_4140<class_4208>)class_4140.field_18440, h -> h.method_40225(class_7477.field_39292));
    }

    public void releasePoi(class_4140<class_4208> memory, Predicate<class_6880<class_4158>> test) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            MinecraftServer server = level.method_8503();
            class_4208 current = (class_4208)BrainUtils.getMemory((class_1309)this, memory);
            BrainUtils.clearMemory((class_1309)this, memory);
            if (current != null) {
                class_4153 poiManager;
                Optional opt;
                class_3218 serverLevel;
                class_3218 class_32182 = serverLevel = level.method_27983().equals(current.comp_2207()) ? level : server.method_3847(current.comp_2207());
                if (serverLevel != null && (opt = (poiManager = serverLevel.method_19494()).method_19132(current.comp_2208())).isPresent() && test.test((class_6880<class_4158>)((class_6880)opt.get()))) {
                    poiManager.method_19129(current.comp_2208());
                    class_4209.method_19778((class_3218)serverLevel, (class_2338)current.comp_2208());
                }
            }
        }
    }

    public ShopState canTrade() {
        if (this.method_6109() || !this.profession.hasShop && !this.profession.hasWorkSchedule) {
            return ShopState.NOTWORKER;
        }
        if (!this.profession.hasWorkSchedule) {
            return ShopState.OPEN;
        }
        if (this.getWorkPlace() == null) {
            return ShopState.NOWORKPLACE;
        }
        if (this.getBedPos() == null) {
            return ShopState.NOBED;
        }
        if (this.getActivity() != class_4168.field_18596) {
            return ShopState.CLOSED;
        }
        if (!this.nearWorkPlace(this.getWorkPlace(), 4)) {
            return ShopState.TOOFAR;
        }
        return ShopState.OPEN;
    }

    public boolean nearWorkPlace(class_4208 pos, int range) {
        if (this.followEntity() == null) {
            if (this.method_37908().method_27983() != pos.comp_2207()) {
                return false;
            }
            return pos.comp_2208().method_19769((class_2374)this.method_19538(), (double)range);
        }
        return false;
    }

    public class_1657 followEntity() {
        if (!(this.entityToFollowUUID == null || this.entityToFollow != null && this.entityToFollow.method_5805())) {
            this.entityToFollow = this.method_37908().field_9236 ? this.method_37908().method_18470(this.entityToFollowUUID) : this.method_37908().method_8503().method_3760().method_14602(this.entityToFollowUUID);
        }
        return this.entityToFollow;
    }

    public UUID getEntityToFollowUUID() {
        return this.entityToFollowUUID;
    }

    public boolean followEntity(class_3222 player) {
        if (player == null) {
            this.setBehaviour(Behaviour.WANDER);
        }
        if (player != null) {
            float chance;
            FamilyEntry family = this.getFamily();
            int points = this.friendPoints((class_1657)player);
            float f = chance = points < 3 ? -0.1f + 0.1f * (float)points : 0.5f + 0.15f * (float)points;
            if (!player.method_7337() && family != null && family.hasPlayerRelationShip() && !family.getPartner().equals(player.method_5667()) && this.updater.getDailyRandom().nextFloat() < chance) {
                this.speak(player, ConversationContext.FOLLOW_NO);
                return false;
            }
            this.speak(player, ConversationContext.FOLLOW_YES);
            this.entityToFollowUUID = player.method_5667();
        } else {
            class_1657 class_16572 = this.followEntity();
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                this.speak(serverPlayer, ConversationContext.FOLLOW_STOP);
            }
            this.entityToFollowUUID = null;
        }
        this.entityToFollow = player;
        if (player != null) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        return true;
    }

    public boolean method_18410() {
        return super.method_18410() && this.getEntityToFollowUUID() == null;
    }

    public void method_18400() {
        super.method_18400();
        BrainUtils.setMemory((class_1309)this, (class_4140)class_4140.field_20616, (Object)this.method_37908().method_8510());
    }

    public float method_55693() {
        float size = super.method_55693();
        SizeFeatureType.SizeFeature feat = (SizeFeatureType.SizeFeature)this.lookFeatures.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SIZE.get());
        if (feat != null) {
            return size * feat.size();
        }
        return size;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    public boolean procreateWith(class_1297 other) {
        FamilyEntry family = this.getFamily();
        if (family == null || !family.getPartner().equals(other.method_5667()) || this.procreationProgress > 0) {
            return false;
        }
        if (!other.method_5667().equals(family.getPartner())) {
            return false;
        }
        if (!this.canProcreate()) {
            if (other instanceof class_3222) {
                class_3222 player = (class_3222)other;
                this.speak(player, ConversationContext.PROCREATION_COOLDOWN);
            }
            return false;
        }
        this.procreationProgress = 60;
        this.procreationEntity = other;
        return true;
    }

    public boolean canProcreate() {
        return this.procreationCooldown < 0;
    }

    private boolean spawnBaby() {
        UUID mother;
        UUID father;
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        NPCEntity baby = (NPCEntity)((class_1299)RuneCraftoryEntities.NPC.get()).method_5888(serverLevel, null, this.method_24515(), class_3730.field_16466, false, false);
        if (baby == null) {
            return false;
        }
        baby.method_7217(true);
        ArrayList<class_2960> childIDs = new ArrayList<class_2960>(this.data.value().possibleChildren());
        NPCDataManager manager = DataPackHandler.INSTANCE.npcDataManager();
        class_1297 class_12972 = this.procreationEntity;
        if (class_12972 instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)class_12972;
            childIDs.addAll(npc.data.value().possibleChildren());
        }
        childIDs.removeIf(r -> !manager.has((class_2960)r));
        if (childIDs.isEmpty()) {
            baby.randomizeData(null, true);
        } else {
            baby.setXPLevel(1);
            baby.setNPCData(DataPackHandler.INSTANCE.npcDataManager().get((class_2960)childIDs.get(this.field_5974.method_43048(childIDs.size()))), false);
        }
        if (this.isMale()) {
            father = this.method_5667();
            mother = this.getFamily().getPartner();
        } else {
            mother = this.method_5667();
            father = this.getFamily().getPartner();
        }
        class_1297 class_12973 = this.procreationEntity;
        if (class_12973 instanceof class_3222) {
            class_3222 player = (class_3222)class_12973;
            player.method_7270(BabySpawnEgg.createBabyFrom(baby, player.method_5477(), father, mother));
        } else {
            baby.getFamily().setFather(father);
            baby.getFamily().setMother(mother);
            serverLevel.method_8649((class_1297)baby);
        }
        return true;
    }

    public void tryUpdateName(class_2561 component) {
        if (this.data.value().name() == null) {
            this.method_5665(component);
        }
    }

    public Optional<String> getDataName() {
        return Optional.ofNullable(this.data.value().name());
    }

    public boolean isMale() {
        return (Boolean)this.field_6011.method_12789(MALE);
    }

    public void setMale(boolean flag) {
        this.field_6011.method_12778(MALE, (Object)flag);
    }

    public ReloadableHolder<NPCLook> getLook() {
        if (this.look == null) {
            if (this.data == NPCData.DEFAULT) {
                this.look = NPCLook.DEFAULT;
            } else {
                List looks = this.data.value().look() == null ? List.of() : this.data.value().look().stream().filter(e -> e.gender() == NPCData.Gender.UNDEFINED || e.gender() == NPCData.Gender.MALE == this.isMale()).map(NPCData.NPCLookId::id).toList();
                this.look = !looks.isEmpty() ? DataPackHandler.INSTANCE.npcLookManager().get((class_2960)looks.get(this.field_5974.method_43048(looks.size()))) : DataPackHandler.INSTANCE.npcLookManager().getRandom(this.field_5974, this.isMale());
            }
        }
        return this.look;
    }

    public ReloadableHolder<NPCAttackActions> getAttackActions() {
        if (this.attackActions == null) {
            if (this.data == null || this.data == NPCData.DEFAULT || this.data.value().combatActions() == null) {
                this.attackActions = NPCAttackActions.DEFAULT;
            } else {
                List<class_2960> actions = this.data.value().combatActions();
                this.attackActions = DataPackHandler.INSTANCE.npcActionsManager().get(actions.isEmpty() ? null : actions.get(this.field_5974.method_43048(actions.size())));
            }
        }
        return this.attackActions;
    }

    public Pair<Season, Integer> getBirthday() {
        if (this.birthday == null) {
            if (this.data == NPCData.DEFAULT) {
                this.birthday = Pair.of((Object)((Object)Season.SPRING), (Object)1);
            } else if (this.data.value().birthday() != null) {
                this.birthday = this.data.value().birthday();
            } else {
                Season randSeason = Season.values()[this.field_5974.method_43048(Season.values().length)];
                int day = this.field_5974.method_43048(30) + 1;
                this.birthday = Pair.of((Object)((Object)randSeason), (Object)day);
            }
        }
        return this.birthday;
    }

    public void setClientLook(ReloadableHolder<NPCLook> look) {
        if (this.method_37908().field_9236) {
            this.look = look;
            this.method_18382();
        }
    }

    public NPCData.Gift giftOf(class_1799 stack) {
        this.calcGifts();
        for (Map.Entry<String, NPCData.Gift> e : this.data.value().giftItems().entrySet()) {
            if (!this.gifts.get(e.getKey()).value().is(stack)) continue;
            return e.getValue();
        }
        return null;
    }

    protected Optional<class_2561> randomGiftContext(int min, int max) {
        this.calcGifts();
        ArrayList gifts = new ArrayList();
        this.data.value().giftItems().forEach((key, gift) -> {
            if (gift.xp() >= min && gift.xp() <= max) {
                gifts.add(this.gifts.get(key).value());
            }
        });
        if (gifts.isEmpty()) {
            return Optional.empty();
        }
        GiftData gift2 = (GiftData)gifts.get(this.updater.getDailyRandom().nextInt(gifts.size()));
        return Optional.of(class_2561.method_43471((String)gift2.translation(this.updater.getDailyRandom())));
    }

    private void calcGifts() {
        if (this.gifts == null) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            this.data.value().giftItems().forEach((s, g) -> {
                ReloadableHolder<GiftData> giftData;
                ReloadableHolder<GiftData> reloadableHolder = giftData = g.giftID() == null ? DataPackHandler.INSTANCE.giftManager().getRandomGift(this.updater.getDailyRandom(), g.xp()) : DataPackHandler.INSTANCE.giftManager().get(g.giftID());
                if (giftData != null) {
                    b.put(s, giftData);
                }
            });
            this.gifts = b.build();
        }
    }

    public void openShopForPlayer(class_3222 player) {
        if (this.canTrade() == ShopState.OPEN && this.getProfession().hasShop) {
            this.interactWithPlayer(player);
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            final class_2371<class_1799> shopList = data.getShop(this.getProfession());
            Platform.INSTANCE.openGuiMenu(player, new class_3908(){

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)NPCEntity.this.getProfession().getTranslationKey());
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    return new ContainerShop(i, inventory, new InventoryShop(NPCEntity.this, (class_2371<class_1799>)shopList));
                }
            }, buf -> ContainerShop.DATA_STREAM_CODEC.encode(buf, (Object)new ContainerShop.Data(this.method_5628(), shopList)));
        }
    }

    public void randomizeData(@Nullable class_2960 res) {
        this.randomizeData(res == null ? null : (NPCProfession)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_10223(res), false);
    }

    public void randomizeData(NPCProfession profession, boolean overwrite) {
        if (this.method_5682() != null) {
            this.setNPCData(DataPackHandler.INSTANCE.npcDataManager().getRandom(this.field_5974, d -> (((NPCData)d.value()).profession().isEmpty() || ((NPCData)d.value()).profession().stream().anyMatch(j -> j.equals(profession))) && RunecraftorySavedData.get((MinecraftServer)this.method_5682()).npcHandler.canAssignNPC((ReloadableHolder<NPCData>)d), profession == null ? null : d -> ((NPCData)d.value()).profession().stream().anyMatch(j -> j.equals(profession))), !overwrite);
            if (profession != null) {
                this.setProfession(profession);
            }
        }
    }

    public class_2960 getDataID() {
        return this.data.id();
    }

    public void setNPCData(ReloadableHolder<NPCData> holder, boolean load) {
        if (this.method_5682() != null) {
            if (this.data != null) {
                RunecraftorySavedData.get((MinecraftServer)this.method_5682()).npcHandler.removeUniqueNPC(this.method_5667(), this.data);
            }
            RunecraftorySavedData.get((MinecraftServer)this.method_5682()).npcHandler.addUniqueNPC(this.method_5667(), holder);
        }
        this.data = holder;
        NPCData data = this.data.value();
        this.dataRandom.setSeed(this.method_5667().hashCode());
        if (!load) {
            this.releaseWorkplacePoi();
            this.setProfession(!data.profession().isEmpty() ? data.profession().get(this.dataRandom.nextInt(data.profession().size())) : RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_10240(this.field_5974).map(class_6880::comp_349).get());
            this.setMale(data.gender() == NPCData.Gender.UNDEFINED ? this.field_5974.method_43056() : data.gender() != NPCData.Gender.FEMALE);
            if (data.name() == null) {
                String name = DataPackHandler.INSTANCE.nameManager().getRandomFullName(this.field_5974, this.isMale());
                if (name != null) {
                    this.method_5665((class_2561)class_2561.method_43470((String)name));
                }
            } else {
                Object name = data.name();
                if (data.surname() != null) {
                    name = (String)name + " " + data.surname();
                }
                this.method_5665((class_2561)class_2561.method_43470((String)name));
            }
            this.birthday = null;
            this.getBirthday();
            this.look = null;
            this.getLook();
            this.attackActions = null;
            this.getAttackActions();
            if (data.schedule() == null) {
                this.schedule.load(new NPCSchedule(this, this.field_5974).save());
            } else {
                this.schedule.with(data.schedule());
            }
            this.lookFeatures.buildFromLooks(this, this.look.value());
            this.gifts = null;
            this.calcGifts();
        } else {
            if (data.look() != null && !data.look().isEmpty()) {
                this.look = null;
                this.getLook();
            }
            if (!data.profession().isEmpty() && !data.profession().contains(this.getProfession())) {
                this.setProfession(!data.profession().isEmpty() ? data.profession().get(this.dataRandom.nextInt(data.profession().size())) : RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_10240(this.field_5974).map(class_6880::comp_349).get());
            }
            if (data.gender() != NPCData.Gender.UNDEFINED && data.gender() == NPCData.Gender.MALE != this.isMale()) {
                this.setMale(data.gender() == NPCData.Gender.UNDEFINED ? this.field_5974.method_43056() : data.gender() != NPCData.Gender.FEMALE);
            }
            if (data.name() != null) {
                Object name = data.name();
                if (data.surname() != null) {
                    name = (String)name + " " + data.surname();
                }
                this.method_5665((class_2561)class_2561.method_43470((String)name));
            }
            if (data.birthday() != null) {
                this.birthday = null;
                this.getBirthday();
            }
            if (data.combatActions() != null && !data.combatActions().isEmpty()) {
                this.attackActions = null;
            }
            if (data.schedule() != null) {
                this.schedule.with(data.schedule());
            }
        }
        this.applyAttributes(!load);
        if (this.xpLevel().getLevel() < data.baseLevel()) {
            this.setXPLevel(data.baseLevel());
        }
        this.refreshBrain((class_3218)this.method_37908());
        this.method_18382();
        if (!this.method_37908().field_9236) {
            LoaderNetwork.INSTANCE.sendToTracking((class_8710)new S2CNPCLook(this.method_5628(), this.look, this.lookFeatures), (class_1297)this);
        }
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public static enum Behaviour {
        WANDER("runecraftory.npc.interact.home", false),
        FOLLOW("runecraftory.npc.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.npc.interact.follow.distance", true),
        STAY("runecraftory.npc.interact.stay", true);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }
}

