/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ModelAttachmentsType(List<ModelAttachment> attachments) implements NPCFeature.NPCFeatureHolder<ModelAttachmentsFeature>
{
    public static final MapCodec<ModelAttachmentsType> TYPE_CODEC = ModelAttachment.CODEC.listOf().fieldOf("attachments").xmap(ModelAttachmentsType::new, ModelAttachmentsType::attachments);
    public static MapCodec<ModelAttachmentsFeature> CODEC = ModelAttachment.CODEC.listOf().fieldOf("attachments").xmap(ModelAttachmentsFeature::new, ModelAttachmentsFeature::attachments);
    public static final class_9139<ByteBuf, ModelAttachmentsFeature> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.method_56376(ArrayList::new, ModelAttachment.STREAM_CODEC), ModelAttachmentsFeature::attachments, ModelAttachmentsFeature::new);

    @Override
    public ModelAttachmentsFeature create(NPCEntity npc) {
        if (this.attachments().isEmpty()) {
            throw new IllegalStateException("No models defined!");
        }
        return new ModelAttachmentsFeature(List.copyOf(this.attachments()));
    }

    @Override
    public NPCFeatureType<ModelAttachmentsFeature> getType() {
        return (NPCFeatureType)RuneCraftoryNPCLooks.MODEL_ATTACHMENT.get();
    }

    public static class ModelAttachmentsFeature
    implements NPCFeature {
        private final List<ModelAttachment> attachments;
        private Set<Location> hidden;

        public ModelAttachmentsFeature(List<ModelAttachment> attachments) {
            this.attachments = attachments;
        }

        public List<ModelAttachment> attachments() {
            return this.attachments;
        }

        public Set<Location> hidden() {
            if (this.hidden == null) {
                EnumSet<Location> set = EnumSet.noneOf(Location.class);
                this.attachments().forEach(attachment -> set.addAll(attachment.hidden()));
                this.hidden = Sets.immutableEnumSet(set);
            }
            return this.hidden;
        }

        public NPCFeatureType<ModelAttachmentsFeature> type() {
            return (NPCFeatureType)RuneCraftoryNPCLooks.MODEL_ATTACHMENT.get();
        }
    }

    public record ModelAttachment(class_2960 model, class_2960 texture, Location location, Set<Location> hidden) {
        public static Codec<ModelAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("model").forGetter(ModelAttachment::model), (App)class_2960.field_25139.fieldOf("texture").forGetter(ModelAttachment::texture), (App)CodecUtils.stringEnumCodec(Location.class, null).fieldOf("location").forGetter(ModelAttachment::location), (App)CodecUtils.stringEnumCodec(Location.class, null).listOf().fieldOf("hidden").forGetter(d -> List.copyOf(d.hidden()))).apply((Applicative)instance, (model, texture, location, hidden) -> new ModelAttachment((class_2960)model, (class_2960)texture, (Location)((Object)((Object)location)), Set.copyOf(hidden))));
        public static final class_9139<ByteBuf, ModelAttachment> STREAM_CODEC = class_9139.method_56905((class_9139)class_2960.field_48267, ModelAttachment::model, (class_9139)class_2960.field_48267, ModelAttachment::texture, StreamCodecUtils.ofEnum(Location.class), ModelAttachment::location, (class_9139)class_9135.method_56376(i -> EnumSet.noneOf(Location.class), StreamCodecUtils.ofEnum(Location.class)), ModelAttachment::hidden, ModelAttachment::new);
    }

    public static enum Location {
        HEAD,
        BODY,
        LEFT_ARM,
        RIGHT_ARM,
        LEGS,
        LEFT_LEG,
        RIGHT_LEG;

    }
}

