/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.profession;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3489;

public class Blacksmith
extends NPCProfession {
    public static final String BARN_ACTION = "runecraftory.npc.action.barn";
    public static final String BARN_ACTION_DESCRIPTION = "runecraftory.npc.action.barn.description";
    public static final String BARN_ACTION_SUCCESS = "runecraftory.npc.action.barn.success";
    public static final String BARN_ACTION_FAIL = "runecraftory.npc.action.barn.fail";
    public static final String BARN_COST = "runecraftory.npc.shop.barn.cost";
    public static final String BARN_COST_MAT = "runecraftory.npc.shop.barn.cost.mat";
    public static final String BARN_COST_FAIL = "runecraftory.npc.shop.barn.cost.fail";
    private static final IntUnaryOperator COST_FUNC = count -> {
        int clamped = Math.min(20, count + 1);
        return 1000 * clamped * clamped - Math.max(0, clamped - 1) * 2 * 1000;
    };
    private static final Function<Integer, Float> COST_FUNC_MAT_MULTIPLIER = count -> {
        int clamped = Math.min(10, count);
        return Float.valueOf(1.0f + (float)((int)Math.ceil((double)(clamped * clamped) * 0.5)) * 0.5f);
    };
    private static final Map<class_2073, Integer> MATERIALS = ImmutableMap.of((Object)class_2073.class_2074.method_8973().method_8975(class_3489.field_15539).method_8976(), (Object)32, (Object)class_2073.class_2074.method_8973().method_8975(RunecraftoryTags.Items.COBBLESTONE).method_8976(), (Object)64);

    public Blacksmith(NPCProfession.Builder builder) {
        super(builder);
    }

    @Override
    public void handleAction(NPCEntity npc, class_1657 player, String action) {
        if (npc.canTrade() == ShopState.OPEN && action.equals(BARN_ACTION)) {
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            int amount = COST_FUNC.applyAsInt(data.getBoughtBarns());
            HashMap<class_2073, List> stacks = new HashMap<class_2073, List>();
            for (class_1799 stack : player.method_31548().field_7547) {
                for (class_2073 class_20732 : MATERIALS.keySet()) {
                    if (!class_20732.method_8970(stack)) continue;
                    stacks.computeIfAbsent(class_20732, k -> new ArrayList()).add(stack);
                }
            }
            float multiplier = COST_FUNC_MAT_MULTIPLIER.apply(data.getBoughtBarns()).floatValue();
            boolean enough = MATERIALS.entrySet().stream().allMatch(p -> stacks.getOrDefault(p.getKey(), List.of()).stream().mapToInt(class_1799::method_7947).sum() >= (int)((float)((Integer)p.getValue()).intValue() * multiplier));
            if (enough && data.useMoney(amount)) {
                player.method_7353((class_2561)class_2561.method_43469((String)BARN_ACTION_SUCCESS, (Object[])new Object[]{player.method_5477()}), false);
                block2: for (Map.Entry entry : stacks.entrySet()) {
                    int needed = (int)((float)MATERIALS.get(entry.getKey()).intValue() * multiplier);
                    for (class_1799 stack : (List)entry.getValue()) {
                        if (needed > stack.method_7947()) {
                            int count = stack.method_7947();
                            stack.method_7939(0);
                            needed -= count;
                            continue;
                        }
                        stack.method_7934(needed);
                        continue block2;
                    }
                }
                if (!player.method_7270(new class_1799((class_1935)RuneCraftoryItems.MONSTER_BARN.get()))) {
                    player.method_5775(new class_1799((class_1935)RuneCraftoryItems.MONSTER_BARN.get()));
                }
                data.onBuyBarn();
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)BARN_ACTION_FAIL, (Object[])new Object[]{player.method_5477(), amount}), false);
            }
        }
    }

    @Override
    public Map<String, List<class_2561>> actions(NPCEntity entity, class_3222 player) {
        return Map.of(BARN_ACTION, Blacksmith.getBarnActionComponent(player));
    }

    private static List<class_2561> getBarnActionComponent(class_3222 player) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        Object[] obj = new Object[MATERIALS.size()];
        int i = 0;
        for (Map.Entry<class_2073, Integer> e : MATERIALS.entrySet()) {
            obj[i] = (int)((float)e.getValue().intValue() * COST_FUNC_MAT_MULTIPLIER.apply(data.getBoughtBarns()).floatValue());
            ++i;
        }
        return List.of(class_2561.method_43469((String)BARN_COST, (Object[])new Object[]{COST_FUNC.applyAsInt(data.getBoughtBarns())}), class_2561.method_43469((String)BARN_COST_MAT, (Object[])obj));
    }
}

