/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.ToolUseData;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.lib.ItemTiers;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_9331;

public class ItemToolHammer
extends class_1810 {
    public ItemToolHammer(class_1792.class_1793 props) {
        super(ItemTiers.TIER, props);
    }

    public static void onHammering(class_3222 player, boolean level) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        if (data.getWeaponHandler().getCurrentAction() == RuneCraftoryAttackActions.TOOL_HAMMER_USE.get()) {
            return;
        }
        LevelCalc.useRP(data, 5.0f, true, 0.0f, true, Skills.MINING);
        if (level) {
            LevelCalc.levelSkill(data, Skills.MINING, 10.0f);
        }
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            int duration = stack.method_7935(entity) - remainingUseDuration;
            ToolItemTier tier = (ToolItemTier)((Object)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
            int chargeTime = ItemComponentUtils.getChargeTime(entity, tier);
            if (duration > 0 && duration / chargeTime <= tier.getTierLevel() && duration % chargeTime == 0) {
                EntityUtils.playSoundForPlayer(player, (class_6880<class_3414>)class_3417.field_14776, 1.0f, 1.0f);
            }
        }
    }

    public class_1269 method_7884(class_1838 ctx) {
        ToolItemTier tier = (ToolItemTier)((Object)ctx.method_8041().method_57825((class_9331)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() == 0) {
            return this.useOnSingleBlock(ctx, false);
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        ToolItemTier tier = (ToolItemTier)((Object)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeLeft) {
        ToolItemTier tier = (ToolItemTier)((Object)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.TOOL_TIER.get(), (Object)ToolItemTier.SCRAP));
        if (tier.getTierLevel() != 0 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            int useTime = data.getWeaponHandler().canExecuteAttack((AttackAction)RuneCraftoryAttackActions.TOOL_HAMMER_USE.get(), false) ? data.getWeaponHandler().get(DataKey.TOOL_DATA).charge() : (stack.method_7935(entity) - timeLeft - 1) / ItemComponentUtils.getChargeTime(entity, tier);
            int range = Math.min(useTime, tier.getTierLevel());
            class_3965 result = ItemToolHammer.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348);
            if (range == 0) {
                this.useOnSingleBlock(new class_1838((class_1657)entity, entity.method_6058(), result), false);
            } else {
                data.getWeaponHandler().executeAttack((AttackAction)RuneCraftoryAttackActions.TOOL_HAMMER_USE.get(), stack);
                data.getWeaponHandler().store(DataKey.TOOL_DATA, new ToolUseData((class_239)result, range));
            }
        }
        super.method_7840(stack, level, entity, timeLeft);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    private class_1269 useOnSingleBlock(class_1838 ctx, boolean canHammer) {
        class_1657 class_16572 = ctx.method_8036();
        if (!(class_16572 instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)class_16572;
        class_1799 stack = ctx.method_8041();
        HammerState state = this.hammer((class_3218)ctx.method_8045(), ctx.method_8037(), stack, (class_1309)ctx.method_8036(), canHammer);
        if (state != HammerState.FAIL) {
            ItemToolHammer.onHammering(player, state == HammerState.BREAK);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HammerState hammer(class_3218 level, class_2338 pos, class_1799 stack, class_1309 entity, boolean canHammer) {
        if (entity instanceof class_1657 && !((class_1657)entity).method_7343(pos.method_10093(class_2350.field_11036), class_2350.field_11036, stack)) {
            return HammerState.FAIL;
        }
        class_2680 state = level.method_8320(pos);
        if (canHammer && state.method_26164(RunecraftoryTags.Blocks.HAMMER_BREAKABLE)) {
            if (!(entity instanceof class_3222)) return level.method_30093(pos, true, (class_1297)entity, 3) ? HammerState.BREAK : HammerState.FAIL;
            class_3222 serverPlayer = (class_3222)entity;
            if (!serverPlayer.field_13974.method_14266(pos)) return HammerState.FAIL;
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            serverPlayer.field_13987.method_14364((class_2596)new class_2626(pos, level.method_8320(pos)));
            return HammerState.BREAK;
        }
        if (!state.method_26164(RunecraftoryTags.Blocks.HAMMER_FLATTENABLE) || !level.method_8320(pos.method_10084()).method_26215() || !level.method_8501(pos, class_2248.method_9582((class_2680)state, (class_2680)class_2246.field_10566.method_9564(), (class_1936)level, (class_2338)pos))) return HammerState.FAIL;
        level.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
        return HammerState.FLATTEN;
    }

    public static enum HammerState {
        FAIL,
        BREAK,
        FLATTEN;

    }
}

