/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5575;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class LootingAndLuckLootFunction
extends class_120 {
    public static final MapCodec<LootingAndLuckLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LootingAndLuckLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_5659.field_45888.fieldOf("base").forGetter(d -> d.baseChance), (App)class_1887.field_51644.fieldOf("enchantment").forGetter(d -> d.enchantment), (App)class_5659.field_45888.fieldOf("enchanted_bonus").forGetter(d -> d.enchantedBonus), (App)class_5659.field_45888.fieldOf("luck_bonus").forGetter(d -> d.luckBonus), (App)Codec.INT.fieldOf("limit").forGetter(d -> d.limit))).apply((Applicative)instance, LootingAndLuckLootFunction::new));
    private final class_5658 baseChance;
    private final class_6880<class_1887> enchantment;
    private final class_5658 enchantedBonus;
    private final class_5658 luckBonus;
    private final int limit;

    private LootingAndLuckLootFunction(List<class_5341> conditions, class_5658 baseChance, class_6880<class_1887> enchantment, class_5658 enchantedBonus, class_5658 luckBonus, int limit) {
        super(conditions);
        this.baseChance = baseChance;
        this.enchantment = enchantment;
        this.luckBonus = luckBonus;
        this.enchantedBonus = enchantedBonus;
        this.limit = limit;
    }

    public class_5339<LootingAndLuckLootFunction> method_29321() {
        return (class_5339)RuneCraftoryLootRegistries.LUCK_AND_LOOTING.get();
    }

    protected class_1799 method_522(class_1799 stack, class_47 ctx) {
        class_1297 entity = (class_1297)ctx.method_296(class_181.field_1230);
        float luck = ctx.method_302();
        int looting = 0;
        List<class_1309> contributing = LootingAndLuckLootFunction.getContributingEntities(ctx);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            looting = class_1890.method_8203(this.enchantment, (class_1309)living);
        }
        for (class_1309 other : contributing) {
            looting += class_1890.method_8203(this.enchantment, (class_1309)other);
            if (!other.method_6127().method_45331(class_5134.field_23726)) continue;
            luck += (float)other.method_45325(class_5134.field_23726);
        }
        float chance = (this.baseChance.method_32454(ctx) + this.luckBonus.method_32454(ctx) * luck) * (1.0f + this.enchantedBonus.method_32454(ctx) * (float)looting);
        if (chance >= 1.0f) {
            int uniform = (int)chance * 2;
            float left = chance - (float)uniform;
            int amount = ctx.method_294().method_43048(uniform + 1);
            if (ctx.method_294().method_43057() < left) {
                ++amount;
            }
            if (this.limit > 0) {
                amount = Math.min(this.limit, amount);
            }
            stack.method_7939(amount);
            return stack;
        }
        if (ctx.method_294().method_43057() < chance) {
            return stack;
        }
        return class_1799.field_8037;
    }

    public static List<class_1309> getContributingEntities(class_47 ctx) {
        NPCEntity npc;
        class_1297 entity = (class_1297)ctx.method_296(class_181.field_1230);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            return entity.method_37908().method_18023(class_5575.method_31795(class_1309.class), entity.method_5829().method_1014(64.0), data.party::isPartyMember);
        }
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (monster.getOwner() != null && ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)monster.getOwner())).party.isPartyMember((class_1297)monster)) {
                return List.of(monster);
            }
        } else if (entity instanceof NPCEntity && (npc = (NPCEntity)entity).followEntity() != null && ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)npc.followEntity())).party.isPartyMember((class_1297)npc)) {
            return List.of(npc);
        }
        return List.of();
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final class_5658 baseChance;
        private class_6880<class_1887> enchantment;
        private class_5658 enchantedBonus = class_44.method_32448((float)0.0f);
        private class_5658 luckBonus = class_44.method_32448((float)0.0f);
        private int limit = 0;

        public Builder(class_5658 baseChance) {
            this.baseChance = baseChance;
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withLuckBonus(class_5658 luckBonus) {
            this.luckBonus = luckBonus;
            return this;
        }

        public Builder withLootingBonus(class_7225.class_7874 registries, class_5658 lootingBonus) {
            this.enchantment = registries.method_46762(class_7924.field_41265).method_46747(class_1893.field_9110);
            this.enchantedBonus = lootingBonus;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public class_117 method_515() {
            return new LootingAndLuckLootFunction(this.method_526(), this.baseChance, this.enchantment, this.enchantedBonus, this.luckBonus, this.limit);
        }
    }
}

