/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class S2CCapSync
implements class_8710 {
    public static final class_8710.class_9154<S2CCapSync> TYPE = new class_8710.class_9154(RuneCraftory.modRes("s2c_player_data_sync"));
    public static final class_9139<class_9129, S2CCapSync> STREAM_CODEC = new class_9139<class_9129, S2CCapSync>(){

        public S2CCapSync decode(class_9129 buf) {
            return new S2CCapSync(buf);
        }

        public void encode(class_9129 buf, S2CCapSync pkt) {
            buf.method_53002(pkt.money);
            buf.method_53002(pkt.runePoints);
            pkt.level.toPacket((class_2540)buf);
            buf.method_53002(Skills.values().length);
            for (Skills skill : Skills.values()) {
                buf.method_10817((Enum)skill);
                XpLevelHolder xp = pkt.skillMap.getOrDefault((Object)skill, new XpLevelHolder());
                xp.toPacket((class_2540)buf);
            }
            buf.method_10794((class_2520)pkt.spells);
            class_9135.method_56382((class_9139)class_9135.method_56383((class_5321)class_7924.field_41197)).encode((Object)buf, pkt.foodData.food());
            buf.method_53002(pkt.foodData.duration());
            buf.method_53002(pkt.recipes.size());
            pkt.recipes.forEach(arg_0 -> ((class_9129)buf).method_10812(arg_0));
        }
    };
    private final EnumMap<Skills, XpLevelHolder> skillMap = new EnumMap(Skills.class);
    private final int money;
    private final int runePoints;
    private final XpLevelHolder level;
    private final class_2487 spells;
    private final PlayerData.FoodData foodData;
    private final Collection<class_2960> recipes;

    private S2CCapSync(class_9129 buf) {
        this.money = buf.readInt();
        this.runePoints = buf.readInt();
        this.level = new XpLevelHolder((class_2540)buf);
        int l = buf.readInt();
        for (int i = 0; i < l; ++i) {
            Skills skill = (Skills)buf.method_10818(Skills.class);
            this.skillMap.put(skill, new XpLevelHolder((class_2540)buf));
        }
        this.spells = buf.method_10798();
        this.foodData = new PlayerData.FoodData((Optional)class_9135.method_56382((class_9139)class_9135.method_56383((class_5321)class_7924.field_41197)).decode((Object)buf), buf.readInt());
        this.recipes = new HashSet<class_2960>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.recipes.add(buf.method_10810());
        }
    }

    public S2CCapSync(PlayerData data) {
        this.money = data.getMoney();
        this.runePoints = data.getRunePoints();
        this.level = data.getPlayerLevel();
        for (Skills skill : Skills.values()) {
            this.skillMap.put(skill, data.getSkillLevel(skill));
        }
        this.spells = data.getInv().save((class_7225.class_7874)data.player().method_56673());
        this.foodData = data.foodBuff();
        this.recipes = data.getRecipeKeeper().unlockedRecipes();
    }

    public static void handle(S2CCapSync pkt, class_1657 player) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        data.setMoney(pkt.money);
        data.setRunePoints(pkt.runePoints);
        data.getPlayerLevel().from(pkt.level);
        pkt.skillMap.forEach((skill, val) -> data.getSkillLevel((Skills)((Object)skill)).from((XpLevelHolder)val));
        data.getInv().load(pkt.spells, (class_7225.class_7874)player.method_56673());
        data.updateFoodBuff(pkt.foodData);
        data.getRecipeKeeper().clientUpdate(pkt.recipes);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

