/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.recipes;

import io.github.flemmli97.runecraftory.common.recipes.ArmorRecipe;
import io.github.flemmli97.runecraftory.common.recipes.ChemistryRecipe;
import io.github.flemmli97.runecraftory.common.recipes.CookingRecipe;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.ForgingRecipe;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8790;

public class SextupleRecipeBuilder {
    private final class_1799 result;
    private final int level;
    private final int addCost;
    private final class_2371<class_1856> ingredients = class_2371.method_10211();
    private final SextupleRecipe.Serializer.Factory<?> factory;
    private final CraftingType type;
    private String group;

    private SextupleRecipeBuilder(CraftingType type, class_1799 item, int level, int addCost, SextupleRecipe.Serializer.Factory<?> factory) {
        this.type = type;
        this.result = item;
        this.level = level;
        this.addCost = addCost;
        this.factory = factory;
    }

    public static SextupleRecipeBuilder create(CraftingType type, class_1935 item, int level) {
        return SextupleRecipeBuilder.create(type, item, 1, level);
    }

    public static SextupleRecipeBuilder create(CraftingType type, class_1935 item, int count, int level) {
        return SextupleRecipeBuilder.create(type, new class_1799(item, count), level, 1);
    }

    public static SextupleRecipeBuilder create(CraftingType type, class_1935 item, int count, int level, int addCost) {
        return SextupleRecipeBuilder.create(type, new class_1799(item, count), level, addCost);
    }

    public static SextupleRecipeBuilder create(CraftingType type, class_1799 item, int level, int addCost) {
        SextupleRecipe.Serializer.Factory<SextupleRecipe> factory = switch (type) {
            case CraftingType.FORGE -> ForgingRecipe::new;
            case CraftingType.ACCESSORY_WORKBENCH -> ArmorRecipe::new;
            case CraftingType.CHEMISTRY_SET -> ChemistryRecipe::new;
            default -> CookingRecipe::new;
        };
        return new SextupleRecipeBuilder(type, item, level, addCost, factory);
    }

    public SextupleRecipeBuilder addIngredient(class_6862<class_1792> tag) {
        return this.addIngredient(class_1856.method_8106(tag));
    }

    public SextupleRecipeBuilder addIngredient(class_1935 item) {
        return this.addIngredient(item, 1);
    }

    public SextupleRecipeBuilder addIngredient(class_1935 item, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addIngredient(class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
        return this;
    }

    public SextupleRecipeBuilder addIngredient(class_1856 ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public SextupleRecipeBuilder addIngredient(class_1856 ingredient, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public SextupleRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(class_8790 output) {
        this.build(output, class_7923.field_41178.method_10221((Object)this.result.method_7909()));
    }

    public void build(class_8790 output, String string) {
        this.build(output, class_2960.method_60654((String)string));
    }

    public void build(class_8790 output, class_2960 res) {
        res = class_2960.method_60655((String)res.method_12836(), (String)(this.type.getId() + "/" + res.method_12832()));
        this.validate(res);
        output.method_53819(res, this.factory.get(this.group == null ? "" : this.group, this.level, this.addCost, this.result, this.ingredients), null);
    }

    private void validate(class_2960 res) {
        if (this.ingredients.size() > 6) {
            throw new IllegalStateException("Recipe " + String.valueOf(res) + " too big. Max size is 6");
        }
    }
}

