/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.entities.misc.WaterLaserEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public class DoubleWaterLaserSpell
extends Spell {
    private final float range;

    public DoubleWaterLaserSpell(float range) {
        this.range = range;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        class_243 dir = entity.method_5828(1.0f);
        class_243 pos = entity.method_19538().method_1031(0.0, (double)entity.method_5751() - 0.1, 0.0);
        class_243 targetPos = ProjectileUtils.getAimTarget(entity);
        if (targetPos != null) {
            dir = targetPos.method_1020(pos);
        }
        UUID other = null;
        for (int i = 0; i < 2; ++i) {
            WaterLaserEntity laser = new WaterLaserEntity((class_1937)level, entity, new Vector3f(i == 0 ? 0.5f : -0.5f, 0.0f, 0.5f));
            if (i == 0) {
                other = laser.method_5667();
            } else {
                laser.setTwinId(other);
            }
            laser.setRange(this.range);
            laser.setMaxTicks(entity instanceof class_1657 ? class_3532.method_15384((double)PlayerModelAnimations.ANIMS.get(PlayerModelAnimations.WATER_LASER_TWO).length()) : 15);
            laser.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            class_243 target = laser.method_19538().method_1019(dir);
            laser.setRotationTo(target.method_10216(), target.method_10214(), target.method_10215(), 0.0f);
            laser.setupRotationAndPosition((class_1297)entity, (class_1297)laser);
            level.method_8649((class_1297)laser);
        }
        DoubleWaterLaserSpell.playSound(entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_WATER.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        return true;
    }

    @Override
    public AttackAction useAction() {
        return (AttackAction)RuneCraftoryAttackActions.DOUBLE_WATER_LASER_USE.get();
    }
}

