/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.FireballEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import org.joml.Vector3d;

public class MultiFireballSpell
extends Spell {
    public final int amount;
    public final float angle;

    public MultiFireballSpell(int amount, float angle) {
        this.amount = amount;
        this.angle = angle;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        class_243 pos = entity.method_19538().method_1031(0.0, (double)entity.method_5751() - 0.1, 0.0);
        class_243 target = ProjectileUtils.getAimTarget(entity);
        class_243 dir = target != null ? target.method_1020(pos) : entity.method_5828(1.0f);
        class_243 up = new class_243(0.0, 1.0, 0.0);
        float angle = -this.angle;
        float inc = this.angle * 2.0f / (float)(this.amount - 1);
        for (float y = angle; y <= this.angle; y += inc) {
            Vector3d newDir = new Vector3d(dir.method_10216(), dir.method_10214(), dir.method_10215()).rotateAxis((double)(y * ((float)Math.PI / 180)), up.method_10216(), up.method_10214(), up.method_10215());
            FireballEntity other = new FireballEntity((class_1937)level, entity, false);
            other.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            other.method_7485(newDir.x(), newDir.y(), newDir.z(), 1.0f, 0.0f);
            level.method_8649((class_1297)other);
        }
        MultiFireballSpell.playSound(entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        return true;
    }
}

