/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.WindBladeEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3966;

public class WindBladeSpell
extends Spell {
    public final int amount;
    public final float damage;
    public final float angle;

    public WindBladeSpell(int amount, float damage, float angle) {
        this.amount = amount;
        this.damage = damage;
        this.angle = angle;
    }

    @Override
    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        float angle = -this.angle;
        float inc = this.angle * 2.0f / (float)(this.amount - 1);
        for (float y = angle; y <= this.angle; y += inc) {
            class_3966 res;
            class_1308 mob;
            WindBladeEntity wind = new WindBladeEntity((class_1937)level, entity);
            wind.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            wind.shoot((class_1297)entity, entity.method_36455(), entity.method_36454() - angle, 0.0f, 0.45f, 0.0f);
            if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() != null) {
                wind.setTarget((class_1297)mob.method_5968());
            } else if (entity instanceof class_1657 && (res = WindBladeSpell.calculateEntityFromLook(entity, 10.0f)) != null) {
                wind.setTarget(res.method_17782());
            }
            level.method_8649((class_1297)wind);
        }
        WindBladeSpell.playSound(entity, (class_3414)RuneCraftorySounds.SPELL_GENERIC_WIND.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        return true;
    }

    public static class_3966 calculateEntityFromLook(class_1309 entity, float reach) {
        class_243 loc;
        double dist;
        class_243 dir;
        class_243 scaledDir;
        class_243 pos = entity.method_5836(1.0f);
        class_3966 result = HitResultUtils.rayTraceEntities((class_1297)entity, (class_243)pos, (class_243)pos.method_1019(scaledDir = (dir = entity.method_5828(1.0f)).method_1021((double)reach)), (class_238)entity.method_5829().method_18804(scaledDir).method_1014(1.0), t -> class_1301.field_6155.test(t) && t.method_5863());
        if (result != null && (dist = pos.method_1025(loc = result.method_17784())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }
}

