/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemSpell;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.spells.BaseStaffSpell;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.mixin.LivingEntityAccessor;
import io.github.flemmli97.runecraftory.mixin.MobEffectInstanceAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.HitResultUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5253;
import net.minecraft.class_5575;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_9109;
import net.minecraft.class_9331;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;

public class CombatUtils {
    private static final class_2960 TEMP_ATTRIBUTE_MOD = RuneCraftory.modRes("combat_temp_mod");
    private static final class_2960 TEMP_ATTRIBUTE_MOD_MULT = RuneCraftory.modRes("combat_temp_mod_multiply");

    public static double getAttributeValue(class_1297 entity, class_6880<class_1320> att) {
        if (!(entity instanceof class_1309)) {
            return 0.0;
        }
        class_1309 attacker = (class_1309)entity;
        double increase = 0.0;
        if (attacker.method_5996(att) != null) {
            increase += attacker.method_45325(att);
        }
        int inc = (int)increase;
        double restRound = (double)Math.round((increase - (double)inc) * 2.0) / 2.0;
        return (double)inc + restRound;
    }

    public static class_6880<class_1320> opposing(class_6880<class_1320> att) {
        if (att.method_40226(RuneCraftoryAttributes.PARALYSIS.getID())) {
            return RuneCraftoryAttributes.PARALYSIS_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.POISON.getID())) {
            return RuneCraftoryAttributes.POISON_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.SEAL.getID())) {
            return RuneCraftoryAttributes.SEAL_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.SLEEP.getID())) {
            return RuneCraftoryAttributes.SLEEP_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.FATIGUE.getID())) {
            return RuneCraftoryAttributes.FATIGUE_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.COLD.getID())) {
            return RuneCraftoryAttributes.COLD_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.DIZZY.getID())) {
            return RuneCraftoryAttributes.DIZZY_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.CRITICAL.getID())) {
            return RuneCraftoryAttributes.CRITICAL_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.STUN.getID())) {
            return RuneCraftoryAttributes.STUN_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.FAINT.getID())) {
            return RuneCraftoryAttributes.FAINT_RESISTANCE.asHolder();
        }
        if (att.method_40226(RuneCraftoryAttributes.DRAIN.getID())) {
            return RuneCraftoryAttributes.DRAIN_RESISTANCE.asHolder();
        }
        return null;
    }

    public static Skills matchingSkill(class_6880<class_1320> att) {
        if (att.method_40226(RuneCraftoryAttributes.PARALYSIS.getID())) {
            return Skills.RES_PARA;
        }
        if (att.method_40226(RuneCraftoryAttributes.POISON.getID())) {
            return Skills.RES_POISON;
        }
        if (att.method_40226(RuneCraftoryAttributes.SEAL.getID())) {
            return Skills.RES_SEAL;
        }
        if (att.method_40226(RuneCraftoryAttributes.SLEEP.getID())) {
            return Skills.RES_SLEEP;
        }
        if (att.method_40226(RuneCraftoryAttributes.FATIGUE.getID())) {
            return Skills.RES_FATIGUE;
        }
        if (att.method_40226(RuneCraftoryAttributes.COLD.getID())) {
            return Skills.RES_COLD;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static double statusEffectValue(class_1309 entity, class_6880<class_1320> att, class_1297 target) {
        value = CombatUtils.getAttributeValue((class_1297)entity, att) * 0.01;
        opposing = CombatUtils.opposing(att);
        if (!(target instanceof class_1309)) ** GOTO lbl-1000
        livingTarget = (class_1309)target;
        if (opposing != null) {
            v0 = CombatUtils.getAttributeValue((class_1297)livingTarget, opposing);
        } else lbl-1000:
        // 2 sources

        {
            v0 = res = 0.0;
        }
        if (target instanceof class_1657) {
            player = (class_1657)target;
            matchingSkill = CombatUtils.matchingSkill(att);
            if (matchingSkill != null) {
                res += (double)((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getSkillLevel(matchingSkill).getLevel() * 0.005;
            }
        }
        return value * (1.0 - (res *= 0.01));
    }

    public static float reduceDamageFromStats(class_1309 entity, class_1282 source, float amount) {
        float threshold;
        float dmg;
        boolean ignoreDefence;
        if (ArmorEffect.hasArmorEffect(entity, (class_6880<ArmorEffect>)RuneCraftoryArmorEffects.SHIELD_RING.asHolder()) && (double)entity.method_59922().method_43057() < 0.1) {
            return 1.0f;
        }
        float reduce = 0.0f;
        switch (GeneralConfig.defenceSystem) {
            default: {
                throw new MatchException(null, null);
            }
            case NO_DEFENCE: {
                boolean bl = true;
                break;
            }
            case VANILLA_IGNORE: {
                boolean bl;
                if (!(source instanceof DynamicDamage)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_MOBS: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && source.method_5529() instanceof class_1308) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_ATT: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && source.method_5529() instanceof class_1657) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER_HURT: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && entity instanceof class_1657) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_VANILLA_PLAYER: {
                boolean bl;
                if (!(source instanceof DynamicDamage) && (entity instanceof class_1657 || source.method_5529() instanceof class_1657)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case IGNORE_NONE: {
                boolean bl = ignoreDefence = false;
            }
        }
        if (!ignoreDefence) {
            if (source.method_48789(RunecraftoryTags.DamageTypes.IS_MAGIC)) {
                if (!source.method_48789(RunecraftoryTags.DamageTypes.BYPASS_MAGIC)) {
                    reduce = (float)CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
                }
            } else if (!source.method_48789(class_8103.field_42241)) {
                reduce = (float)CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.DEFENCE.asHolder());
            }
        }
        if ((dmg = amount - reduce) < (threshold = amount * 0.2f)) {
            reduce = Math.max(0.0f, reduce - amount * 0.8f);
            dmg = Math.max(0.03f * amount, threshold * (1.0f - reduce / (reduce + threshold)));
        }
        if (source instanceof DynamicDamage) {
            DynamicDamage custom = (DynamicDamage)source;
            if (GeneralConfig.randomDamage && !custom.fixedDamage()) {
                dmg += (float)(entity.method_37908().field_9229.method_43059() * (double)dmg / 10.0);
            }
        }
        return CombatUtils.elementalReduction(entity, source, dmg);
    }

    public static float elementalReduction(class_1309 entity, class_1282 source, float amount) {
        if (source instanceof DynamicDamage && ((DynamicDamage)source).getElement() != ItemElement.NONE) {
            ItemElement element = ((DynamicDamage)source).getElement();
            double percent = 0.0;
            switch (element) {
                case DARK: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.DARK_RESISTANCE.asHolder());
                    break;
                }
                case EARTH: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.EARTH_RESISTANCE.asHolder());
                    break;
                }
                case FIRE: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.FIRE_RESISTANCE.asHolder());
                    break;
                }
                case LIGHT: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.LIGHT_RESISTANCE.asHolder());
                    break;
                }
                case LOVE: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.LOVE_RESISTANCE.asHolder());
                    break;
                }
                case WATER: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.WATER_RESISTANCE.asHolder());
                    break;
                }
                case WIND: {
                    percent = CombatUtils.getAttributeValue((class_1297)entity, (class_6880<class_1320>)RuneCraftoryAttributes.WIND_RESISTANCE.asHolder());
                    break;
                }
            }
            amount = percent < 0.0 ? (float)((double)amount * (1.0 + Math.abs(percent) / 100.0)) : (percent > 100.0 ? (float)((double)amount * -((percent - 100.0) / 100.0)) : (float)((double)amount * (1.0 - percent / 100.0)));
        }
        return amount;
    }

    public static void knockBackEntity(class_1309 attacker, class_1309 entity, float strength) {
        class_243 distVec = entity.method_19538().method_1020(attacker.method_19538()).method_1029();
        CombatUtils.knockbackEntityIgnoreResistance(entity, strength, -distVec.field_1352, -distVec.field_1350);
    }

    public static void knockbackEntityIgnoreResistance(class_1309 entity, double strength, double x, double z) {
        if (!entity.method_5864().method_20210(RunecraftoryTags.EntityTypes.BOSSES)) {
            CombatUtils.applyTempAttribute(entity, (class_6880<class_1320>)class_5134.field_23718, -entity.method_45325(class_5134.field_23718));
        }
        entity.method_6005(strength, x, z);
        if (!entity.method_5864().method_20210(RunecraftoryTags.EntityTypes.BOSSES)) {
            CombatUtils.removeTempAttribute(entity, (class_6880<class_1320>)class_5134.field_23718);
        }
    }

    public static void knockBack(class_1309 entity, DynamicDamage source) {
        if (source.getKnockBackType() == DynamicDamage.KnockBackType.NONE) {
            return;
        }
        class_1297 attacker = source.method_5529();
        float strength = source.knockAmount();
        if ((strength = (float)((double)strength * (1.0 - entity.method_45325(class_5134.field_23718)))) == 0.0f) {
            return;
        }
        double xRatio = 0.0;
        double zRatio = 0.0;
        double yRatio = strength;
        if (attacker != null) {
            switch (source.getKnockBackType()) {
                case BACK: {
                    class_243 distVec = entity.method_19538().method_1020(attacker.method_19538()).method_1029();
                    xRatio = distVec.field_1352;
                    zRatio = distVec.field_1350;
                    break;
                }
                case VANILLA: {
                    xRatio = class_3532.method_15374((float)(attacker.method_36454() * ((float)Math.PI / 180)));
                    zRatio = -class_3532.method_15362((float)(attacker.method_36454() * ((float)Math.PI / 180)));
                    break;
                }
            }
        }
        if (source.getKnockBackType() == DynamicDamage.KnockBackType.VANILLA) {
            entity.method_6005((double)strength, xRatio, zRatio);
        } else {
            class_243 mot = entity.method_18798();
            double y = mot.field_1351;
            entity.field_6007 = true;
            if (xRatio != 0.0 || zRatio != 0.0) {
                float f = (float)Math.sqrt(xRatio * xRatio + zRatio * zRatio);
                mot = mot.method_1021(0.5).method_1031(xRatio / (double)f * (double)strength, 0.0, zRatio / (double)f * (double)strength);
            }
            if (source.getKnockBackType() != DynamicDamage.KnockBackType.UP) {
                if (entity.method_24828()) {
                    y /= 2.0;
                    if ((y += (double)strength) > (double)0.4f) {
                        y = 0.4f;
                    }
                }
            } else if (yRatio != 0.0) {
                y = yRatio;
            }
            entity.method_18799(new class_243(mot.field_1352, y, mot.field_1350));
        }
    }

    public static boolean attackWithItem(class_1657 player, class_1297 target, boolean resetCooldown, boolean levelSkill) {
        return CombatUtils.attackWithItem(player, target, player.method_6047(), 1.0f, resetCooldown, levelSkill);
    }

    public static boolean attackWithItem(class_1657 player, class_1297 target, class_1799 stack, float damageModifier, boolean resetCooldown, boolean levelSkill) {
        float damage;
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (target.method_5732() && !target.method_5698((class_1297)player) && player.method_7357().method_7905(stack.method_7909(), 0.0f) <= 0.0f && (damage = (float)(CombatUtils.getAttributeValue((class_1297)player, (class_6880<class_1320>)class_5134.field_23721) * (double)damageModifier)) > 0.0f) {
            class_1676 projectile;
            if (target.method_5864().method_20210(class_3483.field_51503) && target instanceof class_1676 && (projectile = (class_1676)target).method_59859(class_9109.field_51509, (class_1297)player, (class_1297)player, true)) {
                player.method_37908().method_54762(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14914, player.method_5634());
                return true;
            }
            if (resetCooldown) {
                player.method_7357().method_7906(stack.method_7909(), class_3532.method_15384((double)(20.0 * EntityUtils.attackSpeedModifier((class_1309)player))));
            }
            boolean faint = player.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue((class_1309)player, (class_6880<class_1320>)RuneCraftoryAttributes.FAINT.asHolder(), target);
            boolean critical = player.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue((class_1309)player, (class_6880<class_1320>)RuneCraftoryAttributes.CRITICAL.asHolder(), target);
            DynamicDamage.DamageCategory damageCategory = DynamicDamage.DamageCategory.NORMAL;
            if (faint) {
                damageCategory = DynamicDamage.DamageCategory.FAINT;
            } else if (critical) {
                damageCategory = DynamicDamage.DamageCategory.IGNOREDEF;
            }
            if (stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.SCRAP_METAL_PLUS.get())) {
                damageCategory = DynamicDamage.DamageCategory.FIXED;
                damage = 1.0f;
            }
            DynamicDamage.Builder source = new DynamicDamage.Builder((class_1297)player).element(ItemComponentUtils.getElement(stack)).damageType(damageCategory).hurtResistant(0);
            DynamicDamage tempBuild = source.get((class_7225.class_7874)player.method_56673());
            double enchantBonus = class_1890.method_60120((class_3218)serverLevel, (class_1799)stack, (class_1297)player, (class_1282)tempBuild, (float)damage) - damage;
            damage = (float)((double)damage + enchantBonus);
            float knockback = ((LivingEntityAccessor)player).getEntityKnockback(target, tempBuild) + (player.method_5624() ? 1.0f : 0.0f);
            source.knockAmount(knockback);
            class_243 targetMot = target.method_18798();
            if (CombatUtils.damage((class_1297)player, target, source, damage, stack, false, false)) {
                class_3222 serverPlayer;
                if (levelSkill && player instanceof class_3222) {
                    serverPlayer = (class_3222)player;
                    CombatUtils.hitEntityWithItemPlayer(serverPlayer, stack);
                }
                if (knockback > 0.0f) {
                    player.method_18799(player.method_18798().method_18805(0.6, 1.0, 0.6));
                    player.method_5728(false);
                }
                if (target instanceof class_3222) {
                    serverPlayer = (class_3222)target;
                    if (target.field_6037) {
                        serverPlayer.field_13987.method_14364((class_2596)new class_2743(target));
                        target.field_6037 = false;
                        target.method_18799(targetMot);
                    }
                }
                if (critical) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15016, player.method_5634(), 1.0f, 1.0f);
                    player.method_7277(target);
                    player.method_7304(target);
                } else {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14706, player.method_5634(), 1.0f, 1.0f);
                }
            } else {
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14914, player.method_5634(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target) {
        class_1799 stack = attacker.method_6047();
        DynamicDamage.Builder source = new DynamicDamage.Builder((class_1297)attacker).hurtResistant(5).element(ItemComponentUtils.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target, DynamicDamage.Builder source) {
        class_1799 stack = attacker.method_6047();
        double damage = CombatUtils.getAttributeValue((class_1297)attacker, (class_6880<class_1320>)class_5134.field_23721);
        class_1937 class_19372 = attacker.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ((BaseStaffSpell)RuneCraftorySpells.STAFF_CAST.get()).use(serverLevel, attacker, stack);
        }
        if (stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.SCRAP_METAL_PLUS.get())) {
            source.damageType(DynamicDamage.DamageCategory.FIXED);
            damage = 1.0;
        }
        return CombatUtils.mobAttack(attacker, target, source, damage);
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target, DynamicDamage.Builder source, double damage) {
        return CombatUtils.mobAttack(attacker, target, source, damage, null);
    }

    public static boolean mobAttack(class_1309 attacker, class_1297 target, DynamicDamage.Builder source, double damage, @Nullable class_1799 stack) {
        if (target.method_37908().method_8407() == class_1267.field_5801 && target instanceof class_1657) {
            return false;
        }
        if (damage > 0.0) {
            ElementalAttackMob mob;
            ItemElement element;
            if (attacker instanceof ElementalAttackMob && (element = (mob = (ElementalAttackMob)attacker).getAttackElement()) != null) {
                source.element(element);
            }
            return CombatUtils.damageWithFaintAndCrit((class_1297)attacker, target, source, damage, stack);
        }
        return false;
    }

    public static boolean damageWithFaintAndCrit(@Nullable class_1297 attacker, class_1297 target, DynamicDamage.Builder builder, double damage, @Nullable class_1799 stack) {
        return CombatUtils.damage(attacker, target, builder, damage, stack, true, true);
    }

    public static boolean damage(@Nullable class_1297 attacker, class_1297 target, DynamicDamage.Builder builder, double damage, @Nullable class_1799 stack, boolean allowCrit, boolean allowFaint) {
        class_1309 livingAttacker;
        if (attacker instanceof class_1309) {
            class_1309 living = (class_1309)attacker;
            builder.getAttributesChanges().forEach((att, val) -> CombatUtils.applyTempAttribute(living, (class_6880<class_1320>)att, val));
            if (allowFaint && living.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(living, (class_6880<class_1320>)RuneCraftoryAttributes.FAINT.asHolder(), target)) {
                builder.damageType(DynamicDamage.DamageCategory.FAINT);
            } else if (allowCrit && living.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(living, (class_6880<class_1320>)RuneCraftoryAttributes.CRITICAL.asHolder(), target)) {
                switch (builder.getDamageType()) {
                    case MAGIC: {
                        builder.damageType(DynamicDamage.DamageCategory.IGNOREMAGICDEF);
                        break;
                    }
                    case NORMAL: {
                        builder.damageType(DynamicDamage.DamageCategory.IGNOREDEF);
                    }
                }
            }
            if (builder.calculateKnockback()) {
                float knockback = ((LivingEntityAccessor)living).getEntityKnockback(target, builder.get((class_7225.class_7874)living.method_56673())) + (living.method_5624() ? 1.0f : 0.0f);
                builder.knockAmount(knockback);
            }
        }
        DynamicDamage source = builder.get((class_7225.class_7874)target.method_56673());
        float dmg = (float)damage;
        if (source.criticalDamage()) {
            dmg = Float.MAX_VALUE;
        } else if (!source.fixedDamage()) {
            dmg = CombatUtils.modifyDmgElement(source.getElement(), target, dmg);
        }
        boolean success = source.hurtEntity(target, dmg);
        if (success) {
            CombatUtils.spawnElementalParticle(target, source.getElement());
            if (attacker instanceof class_1309) {
                livingAttacker = (class_1309)attacker;
                livingAttacker.method_6114(target);
            }
            if (target instanceof class_1309) {
                class_1309 livingAttacker2;
                class_1937 class_19372;
                boolean handleStack;
                class_1309 livingTarget = (class_1309)target;
                CombatUtils.knockBack(livingTarget, source);
                boolean bl = handleStack = attacker instanceof class_1657 && stack != null;
                if (handleStack) {
                    handleStack = stack.method_7979(livingTarget, (class_1657)attacker);
                }
                if (attacker instanceof class_1309 && (class_19372 = (livingAttacker2 = (class_1309)attacker).method_37908()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    CombatUtils.applyStatusEffects(livingAttacker2, livingTarget);
                    class_1890.method_60107((class_3218)serverLevel, (class_1297)target, (class_1282)source);
                }
                if (handleStack && !stack.method_7960()) {
                    stack.method_59979(livingTarget, (class_1657)attacker);
                }
                if (stack != null && attacker instanceof class_1657) {
                    class_1657 player = (class_1657)attacker;
                    class_1799 beforeHitCopy = stack.method_7972();
                    if (stack.method_7960()) {
                        Platform.INSTANCE.destroyItem(player, beforeHitCopy, class_1268.field_5808);
                        player.method_6122(class_1268.field_5808, class_1799.field_8037);
                    }
                }
            }
            CombatUtils.elementalEffects(attacker, source.getElement(), target);
        }
        if (attacker instanceof class_1309) {
            livingAttacker = (class_1309)attacker;
            source.getAttributesChange().forEach((att, val) -> CombatUtils.removeTempAttribute(livingAttacker, (class_6880<class_1320>)att));
        }
        return success;
    }

    public static float modifyDmgElement(ItemElement element, class_1297 target, float dmg) {
        if (!target.method_5864().method_20210(RunecraftoryTags.EntityTypes.ELEMENTAL_DAMAGE_UNAFFECTED) && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            switch (element) {
                case WATER: {
                    if (!living.method_5753() && !living.method_29503()) break;
                    dmg *= 1.2f;
                    break;
                }
                case FIRE: {
                    if (living.method_5753()) {
                        dmg *= 0.8f;
                    }
                    if (!target.method_5864().method_20210(class_3483.field_48288)) break;
                    dmg *= 1.2f;
                    break;
                }
                case LIGHT: {
                    if (!target.method_5864().method_20210(class_3483.field_46232)) break;
                    dmg *= 1.2f;
                    break;
                }
                case LOVE: {
                    if (!target.method_5864().method_20210(class_3483.field_48287)) break;
                    dmg *= 1.2f;
                }
            }
        }
        return dmg;
    }

    public static void elementalEffects(class_1297 attacker, ItemElement element, class_1297 target) {
        if (!target.method_5864().method_20210(RunecraftoryTags.EntityTypes.ELEMENTAL_SECONDARY_UNAFFECTED) && target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            switch (element) {
                case FIRE: {
                    target.method_5639(4.0f);
                    break;
                }
                case WATER: {
                    living.method_6092(new class_1293(class_1294.field_5909, 200));
                    break;
                }
                case WIND: {
                    if (attacker == null) break;
                    living.method_6005(1.5, (double)class_3532.method_15374((float)(attacker.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(attacker.method_36454() * ((float)Math.PI / 180)))));
                    break;
                }
                case EARTH: {
                    living.method_6092(new class_1293(RuneCraftoryEffects.EARTH_ELEMENT_DEBUFF.asHolder(), 200));
                    break;
                }
                case DARK: {
                    living.method_6092(new class_1293(class_1294.field_5920, 200));
                    break;
                }
                case LIGHT: {
                    List<class_1293> effects;
                    if (!((double)target.method_59922().method_43057() < 0.5) || (effects = living.method_6026().stream().filter(eff -> ((class_1291)eff.method_5579().comp_349()).method_5573()).toList()).isEmpty()) break;
                    class_1293 inst = effects.get(attacker.method_59922().method_43048(effects.size()));
                    if (inst.method_5578() == 0) {
                        living.method_6016(inst.method_5579());
                        break;
                    }
                    ((MobEffectInstanceAccessor)inst).setAmplifier(inst.method_5578() - 1);
                    break;
                }
                case LOVE: {
                    living.method_6092(new class_1293(class_1294.field_5911, 200, 1));
                }
            }
        }
    }

    public static void applyStatusEffects(class_1309 attackingEntity, class_1309 target) {
        class_3222 player;
        boolean poisonChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.POISON.asHolder(), (class_1297)target);
        boolean sleepChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.SLEEP.asHolder(), (class_1297)target);
        boolean fatigueChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.FATIGUE.asHolder(), (class_1297)target);
        boolean coldChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.COLD.asHolder(), (class_1297)target);
        boolean paraChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.PARALYSIS.asHolder(), (class_1297)target);
        boolean sealChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.SEAL.asHolder(), (class_1297)target);
        boolean dizzyChance = attackingEntity.method_37908().field_9229.method_43058() < CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.DIZZY.asHolder(), (class_1297)target);
        double stunAmount = CombatUtils.statusEffectValue(attackingEntity, (class_6880<class_1320>)RuneCraftoryAttributes.STUN.asHolder(), (class_1297)target);
        if (poisonChance) {
            EntityUtils.applyPermanentEffect(target, (class_6880<class_1291>)RuneCraftoryEffects.POISON.asHolder(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_POISON, 5.0f);
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_POISON, 15.0f);
            }
        }
        if (fatigueChance) {
            EntityUtils.applyPermanentEffect(target, (class_6880<class_1291>)RuneCraftoryEffects.FATIGUE.asHolder(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_FATIGUE, 5.0f);
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_FATIGUE, 15.0f);
            }
        }
        if (coldChance) {
            EntityUtils.applyPermanentEffect(target, (class_6880<class_1291>)RuneCraftoryEffects.COLD.asHolder(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_COLD, 5.0f);
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_COLD, 15.0f);
            }
        }
        if (paraChance) {
            EntityUtils.applyPermanentEffect(target, (class_6880<class_1291>)RuneCraftoryEffects.PARALYSIS.asHolder(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_PARA, 5.0f);
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_PARA, 15.0f);
            }
        }
        if (sealChance) {
            EntityUtils.applyPermanentEffect(target, (class_6880<class_1291>)RuneCraftoryEffects.SEAL.asHolder(), 0);
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_SEAL, 5.0f);
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_SEAL, 15.0f);
            }
        }
        if (dizzyChance) {
            target.method_6092(new class_1293(class_1294.field_5916, 80, 1, true, false));
        }
        if (stunAmount > 0.1 && attackingEntity.method_37908().field_9229.method_43058() < stunAmount) {
            target.method_6092(new class_1293(RuneCraftoryEffects.STUNNED.asHolder(), class_3532.method_15357((double)(Math.min(1.0, stunAmount) * 60.0)), 0, true, false));
        }
        if (sleepChance) {
            target.method_6092(new class_1293(RuneCraftoryEffects.SLEEP.asHolder(), 80, 0, true, false));
            if (attackingEntity instanceof class_3222) {
                player = (class_3222)attackingEntity;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_SLEEP, 5.0f);
            }
            if (target instanceof class_3222) {
                player = (class_3222)target;
                LevelCalc.levelSkill((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player), Skills.RES_SLEEP, 15.0f);
            }
        }
    }

    public static void spawnElementalParticle(class_1297 target, ItemElement element) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int color = 0xFFFFFF;
            switch (element) {
                case DARK: {
                    color = 1774399;
                    break;
                }
                case EARTH: {
                    color = 9201679;
                    break;
                }
                case FIRE: {
                    color = 12846855;
                    break;
                }
                case LIGHT: {
                    color = 0xFFFF47;
                    break;
                }
                case LOVE: {
                    color = 16221146;
                    break;
                }
                case WATER: {
                    color = 2781149;
                    break;
                }
                case WIND: {
                    color = 2204954;
                    break;
                }
            }
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            Random rand = new Random();
            for (int i = 0; i < 7; ++i) {
                serverLevel.method_14199((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_57173((int)r, (int)g, (int)b)), target.method_23317() + (rand.nextDouble() - 0.5) * (double)target.method_17681(), target.method_23318() + 0.3 + rand.nextDouble() * (double)target.method_17682(), target.method_23321() + (rand.nextDouble() - 0.5) * (double)target.method_17681(), 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public static void applyTempAttribute(class_1309 entity, class_6880<class_1320> att, double val) {
        class_1324 inst = entity.method_5996(att);
        if (inst != null && inst.method_6199(TEMP_ATTRIBUTE_MOD) == null) {
            inst.method_26835(new class_1322(TEMP_ATTRIBUTE_MOD, val, class_1322.class_1323.field_6328));
        }
    }

    public static void applyTempAttributeMult(class_1309 entity, class_6880<class_1320> att, double val) {
        class_1324 inst = entity.method_5996(att);
        if (inst != null && inst.method_6199(TEMP_ATTRIBUTE_MOD_MULT) == null) {
            inst.method_26835(new class_1322(TEMP_ATTRIBUTE_MOD_MULT, val - 1.0, class_1322.class_1323.field_6331));
        }
    }

    public static void removeTempAttribute(class_1309 entity, class_6880<class_1320> att) {
        class_1324 inst = entity.method_5996(att);
        if (inst != null) {
            inst.method_6200(TEMP_ATTRIBUTE_MOD);
            inst.method_6200(TEMP_ATTRIBUTE_MOD_MULT);
        }
    }

    public static void hitEntityWithItemPlayer(class_3222 player, class_1799 stack) {
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        if (stack.method_7909() instanceof ItemStaffBase) {
            switch (ItemComponentUtils.getElement(stack)) {
                case WATER: {
                    LevelCalc.levelSkill(data, Skills.WATER, 3.0f);
                    break;
                }
                case EARTH: {
                    LevelCalc.levelSkill(data, Skills.EARTH, 3.0f);
                    break;
                }
                case WIND: {
                    LevelCalc.levelSkill(data, Skills.WIND, 3.0f);
                    break;
                }
                case FIRE: {
                    LevelCalc.levelSkill(data, Skills.FIRE, 3.0f);
                    break;
                }
                case LIGHT: {
                    LevelCalc.levelSkill(data, Skills.LIGHT, 3.0f);
                    break;
                }
                case DARK: {
                    LevelCalc.levelSkill(data, Skills.DARK, 3.0f);
                    break;
                }
                case LOVE: {
                    LevelCalc.levelSkill(data, Skills.LOVE, 3.0f);
                }
            }
            return;
        }
        if (stack.method_31573(RunecraftoryTags.Items.SHORTSWORDS)) {
            LevelCalc.levelSkill(data, Skills.SHORTSWORD, 2.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.LONGSWORDS)) {
            LevelCalc.levelSkill(data, Skills.LONGSWORD, 4.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.SPEARS)) {
            LevelCalc.levelSkill(data, Skills.SPEAR, 3.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.AXES) || stack.method_31573(RunecraftoryTags.Items.HAMMERS)) {
            LevelCalc.levelSkill(data, Skills.HAMMERAXE, 5.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.DUALBLADES)) {
            LevelCalc.levelSkill(data, Skills.DUAL, 2.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.FISTS)) {
            LevelCalc.levelSkill(data, Skills.FIST, 2.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.AXE_TOOLS) || stack.method_31573(RunecraftoryTags.Items.HAMMER_TOOLS)) {
            LevelCalc.levelSkill(data, Skills.HAMMERAXE, 1.0f);
        }
        if (stack.method_31573(RunecraftoryTags.Items.HOES) || stack.method_31573(RunecraftoryTags.Items.WATERINGCANS) || stack.method_31573(RunecraftoryTags.Items.SICKLES)) {
            LevelCalc.levelSkill(data, Skills.FARMING, 1.0f);
        }
    }

    public static double getRange(class_1309 entity, double bonus) {
        return (EntityUtils.tryGetAttribute(entity, (class_6880<class_1320>)RuneCraftoryAttributes.ATTACK_RANGE.asHolder()) + bonus) * (double)entity.method_55693();
    }

    public static double getWidth(class_1309 entity, double bonus) {
        return (EntityUtils.tryGetAttribute(entity, (class_6880<class_1320>)RuneCraftoryAttributes.ATTACK_WIDTH.asHolder()) + bonus) * (double)entity.method_55693();
    }

    public static int getSpellLevelFromStack(class_1799 stack) {
        if (stack.method_7909() instanceof ItemSpell) {
            return ItemComponentUtils.itemLevel(stack);
        }
        return 1;
    }

    public static double getAbilityDamageBonus(class_1799 stack, Supplier<? extends Spell> source) {
        return CombatUtils.getAbilityDamageBonus(CombatUtils.getSpellLevelFromStack(stack), source.get().properties().baseDamageMultiplier());
    }

    public static float getAbilityDamageBonus(int level, Spell source) {
        return CombatUtils.getAbilityDamageBonus(level, source.properties().baseDamageMultiplier());
    }

    public static float getAbilityDamageBonus(int level, float origin) {
        return origin * (1.0f + (float)(level - 1) * 0.025f);
    }

    public static class_243 fromRelativeVector(class_1297 entity, class_243 relative) {
        return CombatUtils.fromRelativeVector(entity.method_5791(), relative);
    }

    public static class_243 fromRelativeVector(float yRot, class_243 relative) {
        class_243 vec3 = relative.method_1029();
        float f = class_3532.method_15374((float)(yRot * ((float)Math.PI / 180)));
        float g = class_3532.method_15362((float)(yRot * ((float)Math.PI / 180)));
        return new class_243(vec3.field_1352 * (double)g - vec3.field_1350 * (double)f, vec3.field_1351, vec3.field_1350 * (double)g + vec3.field_1352 * (double)f);
    }

    public static boolean canPerform(class_1309 entity, Skills skill, int requiredLvl) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        return player.method_7337() || ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getSkillLevel(skill).getLevel() >= requiredLvl;
    }

    public static interface FloatMap {
        public float get(float var1);
    }

    public static class EntityAttack {
        private final class_1309 attacker;
        private Predicate<class_1309> targetPred;
        private final Map<class_6880<class_1320>, Double> bonusAttributes = new HashMap<class_6880<class_1320>, Double>();
        private final Map<class_6880<class_1320>, Double> bonusAttributesMultiplier = new HashMap<class_6880<class_1320>, Double>();
        private Consumer<class_1309> onSuccess;
        private class_3414 soundToPlay;
        private final BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> targets;

        protected EntityAttack(class_1309 attacker, BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> targets) {
            this.attacker = attacker;
            this.targets = targets;
        }

        public static EntityAttack create(class_1309 attacker, BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> targets) {
            return new EntityAttack(attacker, targets);
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> circleTargets(float startRot, float endRot, float rangeBonus) {
            return EntityAttack.circleTargets(startRot, endRot, null, rangeBonus);
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> circleTargets(float startRot, float endRot, FloatMap xRot, float rangeBonus) {
            return (attacker, predicate) -> {
                double reach = CombatUtils.getRange(attacker, rangeBonus);
                double incHalf = Math.asin(0.5 / reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                class_238 aabb = new class_238(-0.5, -0.02, 0.0, 0.5, (double)attacker.method_17682() + 0.02, reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, xRot == null ? 0.0f : xRot.get((float)steps / (float)rotationSteps), attacker.method_19538());
                    entities.addAll(HitResultUtils.getEntities((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> circleTargetsFixedRange(float startRot, float endRot, float reach) {
            return (attacker, predicate) -> {
                double incHalf = Math.asin(0.5 / (double)reach) * 57.2957763671875;
                float minYRot = Math.min(startRot, endRot);
                float maxYRot = Math.max(startRot, endRot);
                class_238 aabb = new class_238(-0.5, -0.02, 0.0, 0.5, (double)attacker.method_17682() + 0.02, (double)reach);
                int rotationSteps = (int)((double)(maxYRot - minYRot) / (incHalf * 2.0)) + 2;
                float inc = (maxYRot - minYRot) / (float)rotationSteps;
                HashSet entities = new HashSet();
                for (int steps = 0; steps <= rotationSteps; ++steps) {
                    float yRot = minYRot + inc * (float)steps;
                    OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, 0.0f, attacker.method_19538());
                    entities.addAll(HitResultUtils.getEntities((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate));
                    S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                }
                return entities;
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> aabbTargets(class_238 aabb) {
            return EntityAttack.aabbTargets(aabb, true);
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> aabbTargets(class_238 aabb, boolean relative) {
            return (attacker, predicate) -> {
                OrientedBoundingBox obb = new OrientedBoundingBox(relative ? aabb.method_997(attacker.method_19538().method_1021(-1.0)) : aabb, attacker.method_36454(), 0.0f, attacker.method_19538());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                return HitResultUtils.getEntities((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)true, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate);
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> obbTargets(float yRot, float xRot, double width, double range, boolean fixed) {
            return (attacker, predicate) -> {
                double reach = fixed ? range : CombatUtils.getRange(attacker, range);
                class_238 aabb = new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)attacker.method_17682(), reach);
                OrientedBoundingBox obb = new OrientedBoundingBox(aabb, yRot, -xRot, attacker.method_19538());
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                return HitResultUtils.getEntities((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate);
            };
        }

        public static BiFunction<class_1309, Predicate<class_1309>, Collection<class_1309>> obbTargets(OrientedBoundingBox obb) {
            return (attacker, predicate) -> {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)attacker);
                return HitResultUtils.getEntities((class_1309)attacker, (OrientedBoundingBox)obb, (boolean)false, (class_5575)class_5575.method_31795(class_1309.class), (Predicate)predicate);
            };
        }

        public EntityAttack withTargetPredicate(Predicate<class_1309> targetPred) {
            this.targetPred = targetPred;
            return this;
        }

        public EntityAttack withBonusAttributes(class_6880<class_1320> att, double val) {
            this.bonusAttributes.put(att, val);
            return this;
        }

        public EntityAttack withBonusAttributesMultiplier(class_6880<class_1320> att, double val) {
            this.bonusAttributesMultiplier.put(att, val);
            return this;
        }

        public EntityAttack doOnSuccess(Consumer<class_1309> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public EntityAttack withAttackSound(class_3414 sound) {
            this.soundToPlay = sound;
            return this;
        }

        public Collection<class_1309> executeAttack() {
            class_1309 class_13092;
            if (this.attacker.method_37908().field_9236) {
                return List.of();
            }
            class_1309 class_13093 = this.attacker;
            if (class_13093 instanceof TargetableOpponent) {
                TargetableOpponent pred = (TargetableOpponent)class_13093;
                this.targetPred = this.targetPred == null ? pred.validTargetPredicate() : pred.validTargetPredicate().and(this.targetPred);
            }
            Collection<class_1309> list = this.targets.apply(this.attacker, this.targetPred);
            this.bonusAttributes.forEach((att, val) -> CombatUtils.applyTempAttribute(this.attacker, (class_6880<class_1320>)att, val));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.applyTempAttributeMult(this.attacker, (class_6880<class_1320>)att, val));
            class_1309 class_13094 = this.attacker;
            if (class_13094 instanceof class_1308) {
                class_1308 mob = (class_1308)class_13094;
                class_13092 = mob.method_5968();
            } else {
                class_13092 = null;
            }
            class_1309 target = class_13092;
            for (class_1309 livingEntity : list) {
                boolean flag = false;
                if (target != livingEntity && this.attacker.method_5854() == livingEntity) continue;
                class_1309 class_13095 = this.attacker;
                if (class_13095 instanceof class_1657) {
                    class_1657 player = (class_1657)class_13095;
                    flag = CombatUtils.attackWithItem(player, (class_1297)livingEntity, false, false);
                } else {
                    class_13095 = this.attacker;
                    if (class_13095 instanceof class_1308) {
                        class_1308 mob = (class_1308)class_13095;
                        flag = mob.method_6121((class_1297)livingEntity);
                    }
                }
                if (!flag) continue;
                if (this.onSuccess != null) {
                    this.onSuccess.accept(livingEntity);
                }
                if (this.soundToPlay == null) continue;
                this.attacker.method_37908().method_43128(null, this.attacker.method_23317(), this.attacker.method_23318(), this.attacker.method_23321(), this.soundToPlay, this.attacker.method_5634(), 1.0f, 1.0f);
            }
            this.bonusAttributes.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, (class_6880<class_1320>)att));
            this.bonusAttributesMultiplier.forEach((att, val) -> CombatUtils.removeTempAttribute(this.attacker, (class_6880<class_1320>)att));
            return list;
        }
    }
}

