/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3956;

public class CraftingUtils {
    public static final Random RAND = new Random();

    public static class_3956<SextupleRecipe> getType(CraftingType type) {
        return switch (type) {
            case CraftingType.FORGE -> (class_3956)RuneCraftoryCrafting.FORGE.get();
            case CraftingType.ACCESSORY_WORKBENCH -> (class_3956)RuneCraftoryCrafting.ARMOR.get();
            case CraftingType.CHEMISTRY_SET -> (class_3956)RuneCraftoryCrafting.CHEMISTRY.get();
            default -> (class_3956)RuneCraftoryCrafting.COOKING.get();
        };
    }

    public static Pair<Integer, class_1799> getUpgradeResult(class_1799 stack, PlayerData data, class_1799 ingredient, CraftingType type) {
        int cost = CraftingUtils.upgradeCost(type, data, stack, ingredient);
        if (cost < 0) {
            return Pair.of((Object)cost, (Object)class_1799.field_8037);
        }
        return Pair.of((Object)cost, (Object)ItemComponentUtils.addUpgradeItem(stack.method_7972(), ingredient, false, type));
    }

    public static int upgradeCost(CraftingType type, PlayerData data, class_1799 stack, class_1799 ingredient) {
        if (!GeneralConfig.useRp) {
            return 0;
        }
        if (stack.method_7960()) {
            return -1;
        }
        return DataPackHandler.INSTANCE.itemStatManager().get(ingredient.method_7909()).map(stat -> {
            if (stat.getDiff() <= 0) {
                return -1;
            }
            if (!stack.method_7960()) {
                int result;
                int skillLevel;
                int n = skillLevel = type == CraftingType.FORGE ? data.getSkillLevel(Skills.FORGING).getLevel() : data.getSkillLevel(Skills.CRAFTING).getLevel();
                if (skillLevel >= stat.getDiff()) {
                    result = stat.getDiff() * 2 + (ItemComponentUtils.itemLevel(stack) - 1) * 2;
                } else {
                    int diff = stat.getDiff() - skillLevel;
                    int equip = ItemComponentUtils.itemLevel(stack) - 1;
                    result = (4 * diff + 2) * stat.getDiff() + 2 * stat.getDiff() * (2 * equip) + equip * 2;
                }
                return result;
            }
            return -1;
        }).orElse(-1);
    }

    public static void giveCraftingXPTo(PlayerData data, Skills skill, SextupleRecipe recipe) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, CraftingUtils.xpForCrafting(skill, recipe, data.getSkillLevel(skill).getLevel()) * GeneralConfig.skillXpMultiplier);
    }

    private static float xpForCrafting(Skills skill, SextupleRecipe recipe, int skillLevel) {
        float mult = skill.getProperties().xpMultiplier();
        float xp = (float)(recipe.getCraftingLevel() * 2 + 10) * mult;
        xp = skillLevel > recipe.getCraftingLevel() ? (xp -= (float)(2 * skillLevel - recipe.getCraftingLevel())) : (xp += (float)((recipe.getCraftingLevel() - skillLevel) * recipe.getCraftingLevel()));
        if (xp < 1.0f) {
            xp = 1.0f;
        }
        return xp;
    }

    public static void giveUpgradeXPTo(PlayerData data, Skills skill, class_1799 equip, class_1799 upgrade) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, CraftingUtils.xpForUpgrade(skill, equip, upgrade, data.getSkillLevel(skill).getLevel()) * GeneralConfig.skillXpMultiplier);
    }

    private static float xpForUpgrade(Skills skill, class_1799 equip, class_1799 upgrade, int skillLevel) {
        float mult = skill.getProperties().xpMultiplier() * 1.5f;
        int difficulty = DataPackHandler.INSTANCE.itemStatManager().get(upgrade.method_7909()).map(ItemStat::getDiff).orElse(0);
        float xp = mult * (float)(10 + ItemComponentUtils.itemLevel(equip));
        if (skillLevel < difficulty) {
            xp += (float)(2 * difficulty - skillLevel);
        }
        return xp;
    }

    public static int craftingCost(CraftingType type, PlayerData data, SextupleRecipe recipe, class_2371<class_1799> bonusItems, boolean unlocked) {
        if (!GeneralConfig.useRp) {
            return 0;
        }
        if (GeneralConfig.recipeSystem.baseCost) {
            int cost = Math.max(recipe.getCraftingLevel() * 2 + recipe.getAdditionalCost(), 10);
            int additionalMaterial = 0;
            for (class_1799 items : bonusItems) {
                additionalMaterial += DataPackHandler.INSTANCE.itemStatManager().get(items.method_7909()).map(ItemStat::getDiff).orElse(10).intValue();
            }
            cost += additionalMaterial;
            if (!unlocked && GeneralConfig.recipeSystem.lockedCostMore) {
                cost *= 3;
            }
            return cost;
        }
        int skillLevel = switch (type) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> data.getSkillLevel(Skills.FORGING).getLevel();
            case CraftingType.ACCESSORY_WORKBENCH -> data.getSkillLevel(Skills.CRAFTING).getLevel();
            case CraftingType.CHEMISTRY_SET -> data.getSkillLevel(Skills.CHEMISTRY).getLevel();
            case CraftingType.COOKING_TABLE -> data.getSkillLevel(Skills.COOKING).getLevel();
        };
        int lvlDifference = recipe.getCraftingLevel() - skillLevel;
        int cost = recipe.getCraftingLevel() * 2;
        cost = lvlDifference <= 0 ? Math.max(cost + lvlDifference, 10) + recipe.getAdditionalCost() : Math.max(cost + recipe.getAdditionalCost(), 10) * (int)((double)(1 + lvlDifference) * 1.5);
        int additionalMaterial = 0;
        for (class_1799 items : bonusItems) {
            additionalMaterial += DataPackHandler.INSTANCE.itemStatManager().get(items.method_7909()).map(s -> {
                if (skillLevel >= s.getDiff()) {
                    return s.getDiff();
                }
                return (int)((double)(s.getDiff() - skillLevel) * 1.5) * (s.getDiff() - 5);
            }).orElse(10).intValue();
        }
        cost += additionalMaterial;
        if (!unlocked && GeneralConfig.recipeSystem.lockedCostMore) {
            cost *= 3;
        }
        return cost;
    }

    public static class_1799 getCraftingOutput(class_1799 stack, PlayerBoundCraftingContainer inv, SextupleRecipe.MatchResult materials, CraftingType type) {
        if (type == CraftingType.COOKING_TABLE) {
            for (class_1799 base : materials.recipeMatches()) {
                ItemComponentUtils.addFoodBonusItem(stack, base);
            }
            for (class_1799 bonus : materials.bonusItems()) {
                ItemComponentUtils.addFoodBonusItem(stack, bonus);
            }
            return stack;
        }
        int i = 0;
        for (class_1799 bonus : materials.bonusItems()) {
            ItemComponentUtils.addUpgradeItem(stack, bonus, true, type);
            if (++i != 3) continue;
            break;
        }
        class_2371<class_1799> recipeStacks = materials.recipeMatches();
        RAND.setSeed(((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)inv.getPlayer())).getCraftingSeed(inv.getPlayer()));
        if (recipeStacks.size() > 3) {
            while (i < 3) {
                class_1799 rand = (class_1799)recipeStacks.get(RAND.nextInt(recipeStacks.size()));
                if (!rand.method_7960()) {
                    recipeStacks.remove((Object)rand);
                    ItemComponentUtils.addUpgradeItem(stack, rand, true, type);
                }
                ++i;
            }
        }
        return stack;
    }
}

