/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDamageType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public class DynamicDamage
extends class_1282 {
    private final ItemElement element;
    private final KnockBackType knock;
    private final float knockAmount;
    private final int hurtProtection;
    private final boolean faintEntity;
    private final boolean fixedDamage;
    private final ImmutableMap<class_6880<class_1320>, Double> attributesChange;
    private final Set<class_6862<class_8110>> dynamicTags;

    public DynamicDamage(class_6880<class_8110> type, class_1297 attacker, @Nullable class_1297 cause, ItemElement element, KnockBackType knock, float knockBackAmount, int hurtTimeProtection, boolean faintEntity, boolean fixedDamage, Map<class_6880<class_1320>, Double> attributesChange, Set<class_6862<class_8110>> dynamicTags) {
        super(type, attacker, cause == null ? attacker : cause);
        this.element = element;
        this.knock = knock;
        this.knockAmount = knockBackAmount;
        this.hurtProtection = hurtTimeProtection;
        this.faintEntity = faintEntity;
        this.fixedDamage = fixedDamage;
        this.attributesChange = ImmutableMap.copyOf(attributesChange);
        this.dynamicTags = dynamicTags;
    }

    public boolean method_48789(class_6862<class_8110> damageTypeKey) {
        return super.method_48789(damageTypeKey) || this.dynamicTags.contains(damageTypeKey);
    }

    public ItemElement getElement() {
        return this.element;
    }

    public KnockBackType getKnockBackType() {
        return this.knock;
    }

    public float knockAmount() {
        return this.knockAmount;
    }

    public int hurtProtection() {
        return this.hurtProtection;
    }

    public boolean criticalDamage() {
        return this.faintEntity;
    }

    public boolean fixedDamage() {
        return this.fixedDamage;
    }

    public ImmutableMap<class_6880<class_1320>, Double> getAttributesChange() {
        return this.attributesChange;
    }

    public boolean hurtEntity(class_1297 target, float dmg) {
        boolean success;
        int invul = target.field_6008;
        boolean modified = false;
        if (target.field_6008 + this.hurtProtection() <= 20) {
            target.field_6008 = Math.min(target.field_6008, 10);
            modified = true;
        }
        if (!(success = target.method_5643((class_1282)this, dmg)) && modified) {
            target.field_6008 = invul;
        }
        return success;
    }

    public static enum KnockBackType {
        BACK,
        UP,
        VANILLA,
        NONE;

    }

    public static class Builder {
        private final class_1297 cause;
        private ItemElement element = ItemElement.NONE;
        private KnockBackType knock = KnockBackType.VANILLA;
        private class_1297 source;
        private float knockAmount;
        private int protection = 10;
        private DamageCategory dmg = DamageCategory.NORMAL;
        private final Map<class_6880<class_1320>, Double> attributesChange = new HashMap<class_6880<class_1320>, Double>();
        private boolean isProjectile;

        public Builder(class_1297 attacker) {
            this.cause = attacker;
        }

        public Builder(class_1297 attacker, class_1297 source) {
            this.cause = attacker;
            this.source = source;
        }

        public Builder element(ItemElement el) {
            this.element = el;
            return this;
        }

        public Builder knock(KnockBackType k, float amount) {
            this.knock = k;
            this.knockAmount = amount;
            return this;
        }

        public Builder knockAmount(float amount) {
            this.knockAmount = amount;
            return this;
        }

        public Builder noKnockback() {
            this.knock = KnockBackType.NONE;
            this.knockAmount = 0.0f;
            return this;
        }

        public boolean calculateKnockback() {
            return this.knock == KnockBackType.VANILLA && this.knockAmount == 0.0f;
        }

        public Builder hurtResistant(int time) {
            this.protection = time;
            return this;
        }

        public Builder magic() {
            this.dmg = DamageCategory.MAGIC;
            return this;
        }

        public Builder damageType(DamageCategory type) {
            if (this.dmg != DamageCategory.FAINT) {
                this.dmg = type;
            }
            return this;
        }

        public DamageCategory getDamageType() {
            return this.dmg;
        }

        public Builder withChangedAttribute(class_6880<class_1320> att, double change) {
            this.attributesChange.put(att, change);
            return this;
        }

        public Builder projectile() {
            this.isProjectile = true;
            return this;
        }

        public Map<class_6880<class_1320>, Double> getAttributesChanges() {
            return this.attributesChange;
        }

        public DynamicDamage get(class_7225.class_7874 provider) {
            class_5321<class_8110> proj;
            HashSet<class_6862<class_8110>> tags = new HashSet<class_6862<class_8110>>();
            class_5321<class_8110> type = this.dmg.typeKey;
            if (this.isProjectile && (proj = RuneCraftoryDamageType.PROJECTILE_EQUIVALENT.get(type)) != null) {
                type = RuneCraftoryDamageType.PHYSICAL_PROJECTILE;
            }
            return new DynamicDamage((class_6880<class_8110>)provider.method_46762(class_7924.field_42534).method_46747(type), this.cause, this.source, this.element, this.knock, this.knockAmount, this.protection, this.dmg == DamageCategory.FAINT, this.dmg == DamageCategory.FIXED, this.attributesChange, tags);
        }
    }

    public static enum DamageCategory {
        NORMAL(RuneCraftoryDamageType.PHYSICAL),
        MAGIC(RuneCraftoryDamageType.MAGIC),
        IGNOREDEF(RuneCraftoryDamageType.IGNORE_DEFENCE),
        IGNOREMAGICDEF(RuneCraftoryDamageType.IGNORE_MAGIC_DEFENCE),
        FAINT(RuneCraftoryDamageType.TRUE_DAMAGE),
        FIXED(RuneCraftoryDamageType.TRUE_DAMAGE);

        public final class_5321<class_8110> typeKey;

        private DamageCategory(class_5321<class_8110> typeKey) {
            this.typeKey = typeKey;
        }
    }
}

