/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.TreasureChestEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.items.creative.TreasureChestSpawnegg;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CUpdateAttributesWithAdditional;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1429;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2183;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2781;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_4174;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    private static final List<WeightedChestTier> CHEST_TIERS = ImmutableList.of((Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.COMMON, 150, 0.4f, 550), (Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.UNCOMMON, 40, 0.3f, 200), (Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.RARE, 1, 0.3f, 60), (Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.EPIC, 0, 0.0f, 20));

    public static double tryGetAttribute(class_1309 entity, class_6880<class_1320> attribute) {
        class_1324 inst = entity.method_5996(attribute);
        if (inst == null) {
            return ((class_1320)attribute.comp_349()).method_6169();
        }
        return inst.method_6194();
    }

    public static double attackSpeedModifier(class_1309 entity) {
        return EntityUtils.tryGetAttribute(entity, (class_6880<class_1320>)RuneCraftoryAttributes.ATTACK_SPEED.asHolder());
    }

    public static class_2470 fromDirection(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11034 -> class_2470.field_11463;
            case class_2350.field_11035 -> class_2470.field_11464;
            case class_2350.field_11039 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        };
    }

    public static void applyPermanentEffect(class_1309 entity, class_6880<class_1291> effect, int amplifier) {
        if (!entity.method_6059(effect)) {
            entity.method_6092(new class_1293(effect, -1, amplifier, true, false));
        }
    }

    public static boolean sealed(class_1309 entity) {
        return entity.method_6059(RuneCraftoryEffects.SEAL.asHolder());
    }

    public static boolean canMonsterTargetNPC(class_1297 e) {
        NPCEntity npc;
        if (e instanceof NPCEntity && (npc = (NPCEntity)e).getEntityToFollowUUID() != null) {
            return true;
        }
        return MobConfig.mobAttackNpc && e instanceof class_1655;
    }

    public static void sendAttributesTo(class_1309 entity, class_3222 player) {
        class_1324 att = entity.method_5996(class_5134.field_23721);
        if (att != null) {
            entity.method_6127().method_60498().add(att);
        }
        if (entity == player) {
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CUpdateAttributesWithAdditional(entity.method_6127().method_60498()), player);
        } else {
            player.field_13987.method_14364((class_2596)new class_2781(entity.method_5628(), (Collection)entity.method_6127().method_60498()));
        }
    }

    public static void foodHealing(class_1309 entity, float amount) {
        if (amount > 0.0f) {
            entity.method_6025(amount);
        } else if (!entity.method_5864().method_20210(RunecraftoryTags.EntityTypes.BOSS_MONSTERS)) {
            entity.method_6033(entity.method_6032() + amount);
        }
    }

    public static float playerLuck(class_1657 player) {
        return player.method_7292();
    }

    public static boolean isDisabled(class_1309 entity) {
        return entity.method_6059(RuneCraftoryEffects.SLEEP.asHolder()) || entity.method_6059(RuneCraftoryEffects.STUNNED.asHolder());
    }

    @Nullable
    public static UUID tryGetOwner(class_1309 entity) {
        if (entity instanceof class_6025) {
            class_6025 ownableEntity = (class_6025)entity;
            return ownableEntity.method_6139();
        }
        return null;
    }

    public static boolean canAttackOwned(class_1309 entity, boolean allowUuidOnly, boolean otherwise, Predicate<class_1309> pred) {
        if (entity instanceof class_6025) {
            class_6025 ownableEntity = (class_6025)entity;
            if (entity.method_5667().equals(ownableEntity.method_6139())) {
                return false;
            }
            class_1309 owner = ownableEntity.method_35057();
            if (owner instanceof class_1309) {
                class_1309 living = owner;
                return pred.test(living);
            }
            return allowUuidOnly && ownableEntity.method_6139() != null || otherwise;
        }
        return otherwise;
    }

    public static float tamingChance(BaseMonster monster, class_1657 player, float itemMultiplier, int brushCount, int loveAttackCount) {
        if (itemMultiplier == 0.0f || GeneralConfig.tamingMultiplier == 0.0f) {
            return 0.0f;
        }
        int lvl = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getPlayerLevel().getLevel() + 1;
        float lvlPenalty = Math.max(0.0f, (float)(monster.xpLevel().getLevel() - lvl) * 0.02f);
        float brushBonus = (float)brushCount * 0.05f;
        float loveAttackBonus = (float)loveAttackCount * 0.002f;
        float tamingLvlBonus = (float)(((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getSkillLevel(Skills.TAMING).getLevel() - 1) * 0.005f;
        float tamingBonus = 1.0f + brushBonus + loveAttackBonus + tamingLvlBonus;
        return monster.tamingChance() * GeneralConfig.tamingMultiplier * tamingBonus - lvlPenalty;
    }

    public static class_1299<?> trySpawnTreasureChest(GateEntity spawner) {
        if (spawner.method_59922().method_43057() < MobConfig.treasureChance) {
            if (spawner.method_59922().method_43057() < MobConfig.mimicChance) {
                if (spawner.method_59922().method_43057() < MobConfig.mimicStrongChance) {
                    return (class_1299)RuneCraftoryEntities.GOBBLE_BOX.get();
                }
                return (class_1299)RuneCraftoryEntities.MONSTER_BOX.get();
            }
            return (class_1299)RuneCraftoryEntities.TREASURE_CHEST.get();
        }
        return null;
    }

    public static void tieredTreasureChest(GateEntity spawner, TreasureChestEntity chest) {
        int max = 0;
        for (WeightedChestTier tier : CHEST_TIERS) {
            max += tier.getModifiedWeight(spawner.xpLevel().getLevel());
        }
        int rand = spawner.method_59922().method_43048(max);
        for (WeightedChestTier tier : CHEST_TIERS) {
            if ((rand -= tier.getModifiedWeight(spawner.xpLevel().getLevel())) >= 0) continue;
            chest.setTier(tier.tier);
        }
    }

    public static int getRPFromVanillaFood(class_1799 stack) {
        class_4174 prop = (class_4174)stack.method_57824(class_9334.field_50075);
        if (prop != null) {
            return (int)((double)prop.comp_2491() * 1.5 * (1.0 + 1.8 * (double)prop.comp_2492()));
        }
        return 0;
    }

    public static class_243 horizontalLookAngle(class_1297 entity) {
        class_243 look = entity.method_5828(1.0f);
        return new class_243(look.method_10216(), 0.0, look.method_10215()).method_1029();
    }

    public static class_243 getStraightProjectileTarget(class_243 from, class_1297 target) {
        class_238 aabb = target.method_5829().method_1014((double)(-target.method_17682()) * 0.1);
        return EntityUtils.getStraightProjectileTarget(from, target.method_19538(), aabb.field_1322, aabb.field_1325);
    }

    public static class_243 getStraightProjectileTarget(class_243 from, class_243 target, double minY, double maxY) {
        return new class_243(target.method_10216(), class_3532.method_15350((double)from.method_10214(), (double)minY, (double)maxY), target.method_10215());
    }

    public static class_243 getTargetDirection(class_1308 mob, class_2183.class_2184 anchor) {
        return EntityUtils.getTargetDirection(mob, anchor, false);
    }

    public static class_243 getTargetDirection(class_1308 mob, class_2183.class_2184 anchor, boolean horizontalOnly) {
        class_243 dir;
        class_243 pos = anchor.method_9302((class_1297)mob);
        if (mob.method_5642() != null) {
            dir = mob.method_5642().method_5828(1.0f);
        } else if (mob.method_5968() != null) {
            class_1309 target = mob.method_5968();
            dir = anchor.method_9302((class_1297)target).method_1020(pos);
        } else {
            dir = mob.method_5828(1.0f);
        }
        if (horizontalOnly) {
            dir = new class_243(dir.method_10216(), 0.0, dir.method_10215());
        }
        return dir.method_1029();
    }

    public static class_1309 ownedProjectileTarget(class_1297 owner, int range) {
        class_1308 mob;
        if (owner instanceof class_1308 && (mob = (class_1308)owner).method_5968() != null) {
            return mob.method_5968();
        }
        if (owner instanceof class_1309) {
            Predicate predicate;
            class_1309 livingOwner = (class_1309)owner;
            Function<class_1309, Predicate> generator = ownerEntity -> {
                Predicate<class_1309> predicate;
                if (ownerEntity instanceof BaseMonster) {
                    BaseMonster monster = (BaseMonster)ownerEntity;
                    predicate = monster.targetPred;
                } else {
                    predicate = e -> {
                        if (ownerEntity instanceof class_1657) {
                            if (e instanceof class_1429) return false;
                            if (e instanceof class_1655) return false;
                            if (!(e instanceof class_6025)) return true;
                            class_6025 ownable = (class_6025)e;
                            if (ownerEntity.method_5667().equals(ownable.method_6139())) return false;
                            return true;
                        }
                        if (!(ownerEntity instanceof class_1308)) return false;
                        class_1308 mob = (class_1308)ownerEntity;
                        if (e != mob.method_5968()) return false;
                        return true;
                    };
                }
                return predicate;
            };
            class_1309 class_13092 = owner.method_5642();
            if (class_13092 instanceof class_1309) {
                class_1309 controller = class_13092;
                predicate = generator.apply(controller);
            } else {
                predicate = generator.apply(livingOwner);
            }
            Predicate pred = predicate;
            return owner.method_37908().method_21726(class_1309.class, class_4051.method_36625().method_36627().method_18418((double)range).method_18420(pred), livingOwner, livingOwner.method_23317(), livingOwner.method_23318(), livingOwner.method_23321(), new class_238(-10.0, -10.0, -10.0, 10.0, 10.0, 10.0).method_997(livingOwner.method_19538()));
        }
        return null;
    }

    public static void playSoundForPlayer(class_3222 player, class_3414 event, float volume, float pitch) {
        EntityUtils.playSoundForPlayer(player, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)event), player.method_5634(), volume, pitch);
    }

    public static void playSoundForPlayer(class_3222 player, class_3414 event, class_3419 source, float volume, float pitch) {
        EntityUtils.playSoundForPlayer(player, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)event), source, volume, pitch);
    }

    public static void playSoundForPlayer(class_3222 player, class_6880<class_3414> event, float volume, float pitch) {
        player.field_13987.method_14364((class_2596)new class_2767(event, player.method_5634(), player.method_23317(), player.method_23318(), player.method_23321(), volume, pitch, player.method_59922().method_43055()));
    }

    public static void playSoundForPlayer(class_3222 player, class_6880<class_3414> event, class_3419 source, float volume, float pitch) {
        player.field_13987.method_14364((class_2596)new class_2767(event, source, player.method_23317(), player.method_23318(), player.method_23321(), volume, pitch, player.method_59922().method_43055()));
    }

    record WeightedChestTier(TreasureChestSpawnegg.ChestTier tier, int weight, float modifier, int max) {
        int getModifiedWeight(int mod) {
            return Math.min(this.max, (int)((float)this.weight + this.modifier * (float)mod));
        }
    }
}

