/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.common.components.ArmorEffectData;
import io.github.flemmli97.runecraftory.common.components.FoodAttributeData;
import io.github.flemmli97.runecraftory.common.components.ItemAttributeData;
import io.github.flemmli97.runecraftory.common.components.ItemStackHolder;
import io.github.flemmli97.runecraftory.common.components.ListItemStackHolder;
import io.github.flemmli97.runecraftory.common.components.StaffData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.ToolItemTier;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5151;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class ItemComponentUtils {
    public static int itemLevel(class_1799 stack) {
        return (Integer)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.LEVEL.get(), (Object)1);
    }

    public static class_1799 getLeveledItem(class_1799 stack, int level) {
        if (ItemComponentUtils.shouldHaveLevel(stack)) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.LEVEL.get(), (Object)class_3532.method_15340((int)level, (int)1, (int)10));
        }
        return stack;
    }

    public static void modifyAttribute(class_1799 stack, Consumer<class_9285.class_9287> remove, Consumer<class_9285.class_9287> add) {
        Pair<class_1304, Map<class_6880<class_1320>, Double>> calculated = ItemComponentUtils.getStatsAttributes(stack);
        if (calculated != null) {
            class_9285 defaultMap = (class_9285)stack.method_58658().method_57829(class_9334.field_49636);
            if (defaultMap != null) {
                defaultMap.comp_2393().forEach(entry -> {
                    if (entry.comp_2397().method_57286((class_1304)calculated.getFirst())) {
                        remove.accept((class_9285.class_9287)entry);
                    }
                });
            }
            ((Map)calculated.getSecond()).forEach((att, d) -> add.accept(new class_9285.class_9287(att, new class_1322(LibConstants.EQUIPMENT_MODIFIERS.get(calculated.getFirst()), d.doubleValue(), class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)((class_1304)calculated.getFirst())))));
        }
    }

    public static Pair<class_1304, Map<class_6880<class_1320>, Double>> getStatsAttributes(class_1799 stack) {
        class_5151 equipable = class_5151.method_48957((class_1799)stack);
        if (ItemComponentUtils.shouldHaveStats(stack)) {
            class_1304 slot = equipable != null ? equipable.method_7685() : class_1304.field_6173;
            Map<class_6880<class_1320>, Double> stats = ItemComponentUtils.statIncrease(stack);
            if (stats.isEmpty()) {
                return null;
            }
            return Pair.of((Object)slot, stats);
        }
        return null;
    }

    public static Map<class_6880<class_1320>, Double> statIncrease(class_1799 stack) {
        ItemAttributeData stats = (ItemAttributeData)stack.method_57824((class_9331)RuneCraftoryDataComponentTypes.STATS.get());
        if (stats == null) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::itemStats).orElse(Map.of());
        }
        return stats.getTotalStats();
    }

    public static Pair<Map<class_6880<class_1320>, Double>, Map<class_6880<class_1320>, Double>> foodStats(class_1799 stack) {
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909());
        if (props == null) {
            return Pair.of(new TreeMap(RuneCraftoryAttributes.SORTED), new TreeMap(RuneCraftoryAttributes.SORTED));
        }
        FoodAttributeData data = (FoodAttributeData)stack.method_57824((class_9331)RuneCraftoryDataComponentTypes.FOOD_BUFF.get());
        if (data == null) {
            return Pair.of(props.effects(), props.effectsMultiplier());
        }
        return Pair.of(data.getFlatStats(), data.getMultiplierStats());
    }

    public static void setElement(ItemElement element, class_1799 stack) {
        ItemElement stackElement = (ItemElement)((Object)stack.method_57824((class_9331)RuneCraftoryDataComponentTypes.ELEMENT.get()));
        stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.ELEMENT.get(), (Object)(stackElement == null || stackElement == element ? element : ItemElement.NONE));
    }

    public static ItemElement getElement(class_1799 stack) {
        ItemElement stackElement = (ItemElement)((Object)stack.method_57824((class_9331)RuneCraftoryDataComponentTypes.ELEMENT.get()));
        if (stackElement != null) {
            return stackElement;
        }
        return ItemComponentUtils.isWeapon(stack) ? DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::element).orElse(ItemElement.NONE) : ItemElement.NONE;
    }

    public static class_1799 addUpgradeItem(class_1799 stack, class_1799 upgrade, boolean crafting, CraftingType type) {
        int level = ItemComponentUtils.itemLevel(stack);
        if (upgrade.method_7960() || !ItemComponentUtils.shouldHaveStats(stack) || level >= 10) {
            return class_1799.field_8037;
        }
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(upgrade.method_7909()).orElse(null);
        if (ItemComponentUtils.shouldHaveStats(upgrade)) {
            if (!crafting || stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get())) {
                return stack;
            }
            boolean lightOre = (Boolean)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.LIGHT_ORE.get(), (Object)false);
            if (stack.method_31573(RunecraftoryTags.Items.EQUIPMENT)) {
                boolean sameType;
                if (!upgrade.method_31573(RunecraftoryTags.Items.EQUIPMENT)) {
                    return stack;
                }
                if (lightOre) {
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
                class_5151 current = class_5151.method_48957((class_1799)stack);
                class_5151 class_51512 = class_5151.method_48957((class_1799)upgrade);
                boolean bl = sameType = current == null && class_51512 == null || current != null && class_51512 != null && current.method_7685() == class_51512.method_7685();
                if (sameType) {
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
            }
            if (stack.method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
                if (!upgrade.method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
                    return stack;
                }
                if (lightOre) {
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
                for (class_6862 class_68622 : RunecraftoryTags.Items.WEAPONTAGS) {
                    if (!stack.method_31573(class_68622) || !upgrade.method_31573(class_68622)) continue;
                    return ItemComponentUtils.changeBaseItemTo(stack, upgrade, type);
                }
            }
            if (stat != null) {
                stat.getArmorEffect().ifPresent(effect -> {
                    if (((ArmorEffect)effect.comp_349()).canBeAppliedTo(stack)) {
                        ((ArmorEffectData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get(), (Object)ArmorEffectData.DEFAULT)).add((class_6880<ArmorEffect>)effect);
                    }
                });
            }
            return stack;
        }
        stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.LEVEL.get(), (Object)(!crafting ? level + 1 : level));
        float efficiency = 1.0f;
        if (!crafting) {
            ListItemStackHolder upgrades = (ListItemStackHolder)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)ListItemStackHolder.DEFAULT);
            int n = upgrades.matchesItem(upgrade);
            efficiency = n > 0 ? (float)Math.pow(0.5, n) : 1.0f;
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)upgrades.add(upgrade));
        } else {
            ListItemStackHolder bonus = (ListItemStackHolder)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get(), (Object)ListItemStackHolder.DEFAULT);
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)bonus.add(upgrade));
        }
        if (upgrade.method_7909() == RuneCraftoryItems.GLASS.get() && stack.method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.MAGNIFYING_GLASS.get(), (Object)class_3902.field_17274);
        }
        if (upgrade.method_7909() == RuneCraftoryItems.SCRAP_PLUS.get() && stack.method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD)) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.SCRAP_METAL_PLUS.get(), (Object)class_3902.field_17274);
        }
        boolean hasObjectX = (Boolean)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)false);
        if (upgrade.method_7909() == RuneCraftoryItems.OBJECT_X.get()) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)(!hasObjectX ? 1 : 0));
        }
        if (type == CraftingType.FORGE && upgrade.method_7909() == RuneCraftoryItems.INVIS_STONE.get()) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.INVISIBLE.get(), (Object)class_3902.field_17274);
        }
        if (type == CraftingType.FORGE && upgrade.method_31573(RunecraftoryTags.Items.SCALES)) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.DRAGON_SCALE.get(), (Object)class_3902.field_17274);
        }
        if (crafting && upgrade.method_7909() == RuneCraftoryItems.LIGHT_ORE.get() && !stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get())) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.LIGHT_ORE.get(), (Object)true);
        }
        boolean bl = (Boolean)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get(), (Object)false);
        if (!stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get())) {
            if (upgrade.method_7909() == RuneCraftoryItems.STEEL_DOUBLE.get()) {
                stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get(), (Object)true);
            }
        } else if (bl) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.DOUBLE_STEEL.get(), (Object)false);
        }
        boolean applyTenSteel = (Boolean)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get(), (Object)false);
        if (!stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get())) {
            if (upgrade.method_7909() == RuneCraftoryItems.STEEL_TEN.get()) {
                stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get(), (Object)true);
            }
        } else if (applyTenSteel) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.TENFOLD_STEEL.get(), (Object)false);
        }
        if (stat != null) {
            boolean applyUpgradeStat;
            ItemStat base;
            ItemAttributeData stats = (ItemAttributeData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STATS.get(), (Object)ItemAttributeData.DEFAULT);
            if (stats.getBaseStats().isEmpty() && (base = (ItemStat)DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).orElse(null)) != null && !base.itemStats().isEmpty()) {
                stats = stats.base(base.itemStats());
            }
            boolean bl2 = applyUpgradeStat = !upgrade.method_31573(type.upgradeBlacklist) && (!upgrade.method_31573(RunecraftoryTags.Items.ONE_TIME_UPGRADE) || ((ListItemStackHolder)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)ListItemStackHolder.DEFAULT)).matchesItem(upgrade) == 0);
            if (applyUpgradeStat) {
                class_6862<class_1320> blacklist = null;
                if (type == CraftingType.FORGE) {
                    blacklist = RunecraftoryTags.Attributes.WEAPON_ONLY;
                }
                if (type == CraftingType.ACCESSORY_WORKBENCH) {
                    blacklist = RunecraftoryTags.Attributes.ARMOR_ONLY;
                }
                HashMap<class_6880<class_1320>, Double> upgradeStats = new HashMap<class_6880<class_1320>, Double>();
                for (Map.Entry<class_6880<class_1320>, Double> entry : stat.itemStats().entrySet()) {
                    if (blacklist != null && entry.getKey().method_40220(blacklist)) continue;
                    double amount = entry.getValue() * (double)efficiency;
                    if (hasObjectX) {
                        amount *= -1.0;
                    }
                    if (bl) {
                        amount *= 2.0;
                    }
                    if (applyTenSteel) {
                        amount *= 8.0;
                    }
                    upgradeStats.put(entry.getKey(), amount);
                }
                stats = stats.add(upgradeStats);
            }
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.STATS.get(), (Object)stats);
            if (ItemComponentUtils.isWeapon(stack)) {
                ItemComponentUtils.setElement(stat.element(), stack);
            }
            if (stack.method_7909() instanceof ItemStaffBase) {
                stack.method_57368((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT, data -> {
                    if (stat.getTier1Spell().isPresent()) {
                        data = data.setTier1Spell(stat.getTier1Spell().get());
                    }
                    if (stat.getTier2Spell().isPresent()) {
                        data = data.setTier2Spell(stat.getTier2Spell().get());
                    }
                    if (stat.getTier3Spell().isPresent()) {
                        data = data.setTier3Spell(stat.getTier3Spell().get());
                    }
                    return data;
                });
            }
            if (stat.getArmorEffect().isPresent() && ((ArmorEffect)stat.getArmorEffect().get().comp_349()).canBeAppliedTo(stack)) {
                stack.method_57368((class_9331)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get(), (Object)ArmorEffectData.DEFAULT, data -> data.add(stat.getArmorEffect().get()));
            }
        }
        return stack;
    }

    private static class_1799 changeBaseItemTo(class_1799 stack, class_1799 toApply, CraftingType crafting) {
        ItemStat stat = DataPackHandler.INSTANCE.itemStatManager().get(toApply.method_7909()).orElse(null);
        if (stat != null) {
            ItemAttributeData stats = (ItemAttributeData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STATS.get(), (Object)ItemAttributeData.DEFAULT);
            ItemStat base = DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).orElse(null);
            if (base != null) {
                HashMap<class_6880<class_1320>, Double> baseStats = new HashMap<class_6880<class_1320>, Double>();
                Map origin = DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::itemStats).orElse(Map.of());
                for (Map.Entry<class_6880<class_1320>, Double> entry : base.itemStats().entrySet()) {
                    if (entry.getKey().method_40220(RunecraftoryTags.Attributes.NON_INHERITABLE)) {
                        if (!origin.containsKey(entry.getKey())) continue;
                        baseStats.put(entry.getKey(), (Double)origin.get(entry.getKey()));
                        continue;
                    }
                    baseStats.put(entry.getKey(), entry.getValue());
                }
                stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.STATS.get(), (Object)stats.base(baseStats));
            }
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.ELEMENT.get(), (Object)stat.element());
            if (stack.method_7909() instanceof ItemStaffBase) {
                stack.method_57368((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT, data -> {
                    if (stat.getTier1Spell().isPresent()) {
                        data = data.setTier1Spell(stat.getTier1Spell().get());
                    }
                    if (stat.getTier2Spell().isPresent()) {
                        data = data.setTier2Spell(stat.getTier2Spell().get());
                    }
                    if (stat.getTier3Spell().isPresent()) {
                        data = data.setTier3Spell(stat.getTier3Spell().get());
                    }
                    return data;
                });
            }
            if (stat.getArmorEffect().isPresent() && ((ArmorEffect)stat.getArmorEffect().get().comp_349()).canBeAppliedTo(stack)) {
                stack.method_57368((class_9331)RuneCraftoryDataComponentTypes.ARMOR_EFFECT.get(), (Object)ArmorEffectData.DEFAULT, data -> data.add(stat.getArmorEffect().get()));
            }
        }
        stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get(), (Object)new ItemStackHolder(toApply));
        ListItemStackHolder bonus = (ListItemStackHolder)toApply.method_57824((class_9331)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get());
        if (bonus != null) {
            bonus.forEach(added -> ItemComponentUtils.addUpgradeItem(stack, added, true, crafting));
        }
        return stack;
    }

    public static class_1799 addFoodBonusItem(class_1799 stack, class_1799 stackToAdd) {
        ListItemStackHolder bonus = (ListItemStackHolder)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.CRAFTING_BONUS.get(), (Object)ListItemStackHolder.DEFAULT);
        stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.UPGRADES.get(), (Object)bonus.add(stackToAdd));
        FoodProperties props = DataPackHandler.INSTANCE.foodManager().get(stackToAdd.method_7909());
        boolean hasObjectX = (Boolean)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)false);
        if (stackToAdd.method_7909() == RuneCraftoryItems.OBJECT_X.get()) {
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.OBJECT_X.get(), (Object)(!hasObjectX ? 1 : 0));
        }
        if (props != null) {
            FoodAttributeData stats = (FoodAttributeData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.FOOD_BUFF.get(), (Object)FoodAttributeData.DEFAULT);
            HashMap<class_6880<class_1320>, Double> flatStats = new HashMap<class_6880<class_1320>, Double>();
            for (Map.Entry<class_6880<class_1320>, Double> entry : props.cookingBonus().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                flatStats.put(entry.getKey(), amount);
            }
            stats = stats.add(flatStats);
            HashMap<class_6880<class_1320>, Double> multStats = new HashMap<class_6880<class_1320>, Double>();
            for (Map.Entry<class_6880<class_1320>, Double> entry : props.cookingBonusPercent().entrySet()) {
                double amount = entry.getValue();
                if (hasObjectX) {
                    amount *= -1.0;
                }
                multStats.put(entry.getKey(), amount);
            }
            stats = stats.addMultiplier(multStats);
            stack.method_57379((class_9331)RuneCraftoryDataComponentTypes.FOOD_BUFF.get(), (Object)stats);
        }
        return stack;
    }

    public static boolean shouldHaveStats(class_1799 stack) {
        return stack.method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD) || stack.method_31573(RunecraftoryTags.Items.EQUIPMENT);
    }

    public static boolean shouldHaveLevel(class_1799 stack) {
        return ItemComponentUtils.shouldHaveStats(stack) || stack.method_31573(RunecraftoryTags.Items.SPELLS);
    }

    public static boolean isWeapon(class_1799 stack) {
        return stack.method_31573(RunecraftoryTags.Items.UPGRADABLE_HELD);
    }

    public static boolean usedLightOre(class_1799 stack) {
        if (ItemComponentUtils.shouldHaveStats(stack)) {
            if (((ItemStackHolder)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.ORIGINAL_ITEM.get(), (Object)ItemStackHolder.DEFAULT)).isEmpty()) {
                return false;
            }
            return stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.LIGHT_ORE.get());
        }
        return false;
    }

    public static int getChargeTime(class_1309 entity) {
        return class_3532.method_15384((double)EntityUtils.tryGetAttribute(entity, (class_6880<class_1320>)RuneCraftoryAttributes.CHARGE_TIME.asHolder()));
    }

    public static int getChargeTime(class_1309 entity, ToolItemTier toolTier) {
        int time = class_3532.method_15384((double)EntityUtils.tryGetAttribute(entity, (class_6880<class_1320>)RuneCraftoryAttributes.CHARGE_TIME.asHolder()));
        if (toolTier == ToolItemTier.PLATINUM) {
            time = (int)((float)time * GeneralConfig.platinumChargeTime);
        }
        return time;
    }

    public static float getShieldEfficiency(class_1309 entity) {
        return ItemComponentUtils.getShieldEfficiency(entity.method_6047());
    }

    public static float getShieldEfficiency(class_1799 stack) {
        float eff = ((Float)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.SHIELD_EFFICIENCY.get(), (Object)Float.valueOf(1.0f))).floatValue();
        if (eff < 1.0f && stack.method_57826((class_9331)RuneCraftoryDataComponentTypes.DRAGON_SCALE.get())) {
            eff = class_3532.method_15363((float)(eff + 0.5f), (float)0.5f, (float)0.75f);
        }
        return eff;
    }
}

