/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.advancements.ShopTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopResult;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static void starterItems(class_1657 player) {
        class_1799 broadSword = new class_1799((class_1935)RuneCraftoryItems.BROAD_SWORD.get());
        class_1799 hammer = new class_1799((class_1935)RuneCraftoryItems.HAMMER_SCRAP.get());
        ItemUtils.spawnItemAtEntity((class_1309)player, broadSword);
        ItemUtils.spawnItemAtEntity((class_1309)player, hammer);
    }

    public static void spawnItemAtEntity(class_1309 entity, class_1799 stack) {
        ItemUtils.spawnItemAt(entity.method_37908(), entity.method_24515(), stack, entity);
    }

    public static void spawnItemAt(class_1937 level, class_2338 pos, class_1799 stack, @Nullable class_1309 entity) {
        if (!level.field_9236) {
            class_1542 item = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
            item.method_6982(0);
            if (entity != null) {
                item.method_6981((class_1297)entity);
            }
            level.method_8649((class_1297)item);
        }
    }

    public static void spawnLeveledItem(class_1309 entity, class_1799 stack, int level) {
        if (!entity.method_37908().field_9236) {
            class_1542 item = new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), ItemComponentUtils.getLeveledItem(stack, level));
            item.method_6982(0);
            entity.method_37908().method_8649((class_1297)item);
        }
    }

    public static int getSellPrice(class_1799 stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(stat -> ItemUtils.getSellPrice(stack, stat)).orElse(0);
    }

    public static int getSellPrice(class_1799 stack, ItemStat stat) {
        return stat.getSell() * ItemComponentUtils.itemLevel(stack);
    }

    public static int getBuyPrice(class_1799 stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(stat -> ItemUtils.getBuyPrice(stack, stat)).orElse(0);
    }

    public static ShopResult buyItem(class_1657 player, NPCEntity npc, class_1799 stack) {
        if (ItemUtils.sizeInv(player.method_31548(), stack) < stack.method_7947()) {
            player.method_5783((class_3414)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
            return ShopResult.NOSPACE;
        }
        int price = ItemUtils.getBuyPrice(stack) * stack.method_7947();
        if (((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).useMoney(price)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((ShopTrigger)((Object)RuneCraftoryCriteria.SHOP_TRIGGER.get())).trigger(serverPlayer, npc, stack);
            }
            player.method_5783((class_3414)RuneCraftorySounds.GENERIC_SUCCESS.get(), 1.0f, 1.0f);
            while (stack.method_7947() > 0) {
                class_1799 copy = stack.method_7972();
                int count = Math.min(stack.method_7947(), stack.method_7914());
                copy.method_7939(count);
                ItemUtils.spawnItemAtEntity((class_1309)player, copy);
                stack.method_7939(stack.method_7947() - count);
            }
            return ShopResult.SUCCESS;
        }
        player.method_5783((class_3414)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
        return ShopResult.NOMONEY;
    }

    private static int sizeInv(class_1661 playerInv, class_1799 stack) {
        int amount = 0;
        for (class_1799 iStack : playerInv.field_7547) {
            if (iStack.method_7960()) {
                amount += stack.method_7914();
                continue;
            }
            if (!class_1799.method_31577((class_1799)stack, (class_1799)iStack)) continue;
            amount += stack.method_7914() - iStack.method_7947();
        }
        return amount;
    }

    public static int getBuyPrice(class_1799 stack, ItemStat stat) {
        return stat.getBuy();
    }
}

