/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data.family;

import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.world.data.family.FamilyEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class FamilyHandler
extends class_18 {
    private static final String IDENTIFIER = "RunecraftoryFamilyHandler";
    private static final class_18.class_8645<FamilyHandler> FACTORY = new class_18.class_8645(FamilyHandler::new, FamilyHandler::new, class_4284.field_19212);
    private final Map<UUID, FamilyEntry> families = new HashMap<UUID, FamilyEntry>();

    private FamilyHandler() {
    }

    private FamilyHandler(class_2487 tag, class_7225.class_7874 provider) {
        this.load(tag, provider);
    }

    public static FamilyHandler get(MinecraftServer server) {
        return (FamilyHandler)server.method_30002().method_17983().method_17924(FACTORY, IDENTIFIER);
    }

    public Optional<FamilyEntry> getFamily(UUID uuid) {
        return Optional.ofNullable(this.families.get(uuid));
    }

    public FamilyEntry getOrCreateEntry(class_1657 player) {
        FamilyEntry entry = this.families.computeIfAbsent(player.method_5667(), id -> new FamilyEntry(this, player.method_5667(), player.method_5477(), NPCData.Gender.UNDEFINED, true));
        this.method_80();
        return entry;
    }

    public FamilyEntry getOrCreateEntry(NPCEntity npc) {
        FamilyEntry entry = this.families.computeIfAbsent(npc.method_5667(), id -> new FamilyEntry(this, npc.method_5667(), npc.method_5477(), npc.isMale() ? NPCData.Gender.MALE : NPCData.Gender.FEMALE, false));
        this.method_80();
        return entry;
    }

    public void load(class_2487 tag, class_7225.class_7874 provider) {
        class_2487 data = tag.method_10562("Families");
        data.method_10541().forEach(id -> this.families.put(UUID.fromString(id), new FamilyEntry(this, data.method_10562(id), provider)));
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        class_2487 data = new class_2487();
        this.families.forEach((uuid, entry) -> {
            if (entry.shouldPersist()) {
                data.method_10566(uuid.toString(), (class_2520)entry.save(provider));
            }
        });
        tag.method_10566("Families", (class_2520)data);
        return tag;
    }
}

