/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data.farming;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.blocks.HerbBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.blocks.util.GrowableCrop;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.GrassRegrowUtil;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandDataContainer;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import org.jetbrains.annotations.Nullable;

public class FarmlandData {
    public static final float DEFAULT_SPEED = 1.0f;
    public static final float DEFAULT_QUALITY = 0.0f;
    public static final float DEFAULT_SIZE = 0.0f;
    public static final int DEFAULT_DEFENCE = 0;
    public static final int DEFAULT_HEALTH = 64;
    public static final float MAX_SPEED = 5.0f;
    public static final float MAX_QUALITY = 2.0f;
    public static final float MAX_SIZE = 2.0f;
    public static final int MAX_DEFENCE = 64;
    public static final int MAX_HEALTH = 255;
    public final class_2338 pos;
    private float growth = 1.0f;
    private float quality = 0.0f;
    private float size = 0.0f;
    private int health = 64;
    private int defence = 0;
    private float cropAge;
    private float cropSize;
    private float cropLevel = 1.0f;
    private int cropProgress;
    private int lastUpdateDay;
    private int scheduledStormTicks;
    private int scheduledWatering;
    private int lastWeatherDay;
    private final List<ExternalModifiers> scheduledData = new ArrayList<ExternalModifiers>();
    private boolean isLoaded;
    private boolean isFarmBlock;
    private boolean isGrowing;

    public FarmlandData(class_2338 pos) {
        this.pos = pos;
    }

    public static FarmlandData fromTag(class_2487 tag, class_2338 pos) {
        FarmlandData data = new FarmlandData(pos);
        data.load(tag);
        return data;
    }

    public float getGrowth() {
        return this.growth;
    }

    public void applyGrowthFertilizer(@Nullable class_3218 level, float amount) {
        this.growth = class_3532.method_15363((float)(this.growth + amount), (float)0.1f, (float)5.0f);
        if (level != null) {
            FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        }
    }

    public boolean canUseBonemeal() {
        return (double)this.growth < 2.25;
    }

    public void applyBonemeal(@Nullable class_3218 level) {
        if ((double)this.growth < 2.25) {
            this.applyGrowthFertilizer(level, Math.min(2.25f - this.growth, 0.15f));
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public void modifyQuality(@Nullable class_3218 level, float amount) {
        this.quality = class_3532.method_15363((float)(this.quality + amount), (float)0.0f, (float)2.0f);
        if (level != null) {
            FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        }
    }

    public float getSize() {
        return this.size;
    }

    public void applySizeFertilizer(@Nullable class_3218 level, boolean growGiant) {
        float mod = growGiant ? 1 : -1;
        this.size = class_3532.method_15363((float)(this.size + mod), (float)-2.0f, (float)2.0f);
        if (level != null) {
            FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        }
    }

    public int getHealth() {
        return this.health;
    }

    public void modifyHealth(@Nullable class_3218 level, int amount) {
        this.health = class_3532.method_15340((int)(this.health + amount), (int)0, (int)255);
        if (level != null) {
            FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        }
    }

    public int getDefence() {
        return this.defence;
    }

    public void modifyDefence(@Nullable class_3218 level, int amount) {
        this.defence = class_3532.method_15340((int)(this.defence + amount), (int)0, (int)64);
        if (level != null) {
            FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        }
    }

    public float getCropAge() {
        return (int)this.cropAge;
    }

    private int growthPercent(class_3218 level, class_2680 crop) {
        if (!(crop.method_26204() instanceof Growable)) {
            return 0;
        }
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(crop.method_26204());
        if (props != null) {
            return Math.min((int)(this.cropAge / (float)props.growth() * 100.0f), 100);
        }
        return 0;
    }

    public float getCropSize() {
        return this.cropSize;
    }

    public int getCropLevel() {
        return (int)this.cropLevel;
    }

    public boolean hasDefaultStats() {
        return this.growth == 1.0f && this.quality == 0.0f && this.size == 0.0f && this.health == 64;
    }

    protected void updateFarmBlock(boolean isFarmBlock) {
        this.isFarmBlock = isFarmBlock;
    }

    public boolean isFarmBlock() {
        return this.isFarmBlock;
    }

    public boolean shouldBeRemoved() {
        if (this.isFarmBlock) {
            return false;
        }
        return this.hasDefaultStats();
    }

    public void onRegrowableHarvest(class_3218 level, class_2338 pos, class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof Growable)) {
            this.resetCrop();
            return;
        }
        Growable crop = (Growable)class_22482;
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.method_26204());
        if (props == null || !props.regrowable() || this.getHealth() <= 0) {
            this.resetCrop();
            return;
        }
        float max = props.growth();
        this.cropAge = max * 0.5f;
        int maxAge = crop.runecraftory$getGrowableMaxAge();
        int stage = Math.round(this.cropAge * (float)maxAge) / props.growth();
        class_2680 newState = crop.runecraftory$getGrowableStateForAge(state, Math.min(stage, maxAge));
        level.method_8503().method_18858((Runnable)new class_3738(1, () -> {
            this.isGrowing = true;
            level.method_8652(pos, newState, 3);
            this.isGrowing = false;
        }));
        this.cropProgress = this.growthPercent(level, state);
        this.modifyHealth(null, -3);
        FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
    }

    public void onCropRemove(class_3218 level, class_2338 pos, class_2680 state) {
        if (!this.isGrowing) {
            this.resetCrop();
            FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        }
    }

    public void onWatering(class_3218 level, int currentDay) {
        if (!this.isFarmBlock || this.lastWeatherDay == currentDay) {
            return;
        }
        this.lastWeatherDay = currentDay;
        if (!this.isLoaded) {
            ++this.scheduledWatering;
            return;
        }
        class_2680 farm = level.method_8320(this.pos);
        if ((Integer)farm.method_11654((class_2769)class_2344.field_11009) < 7) {
            level.method_8652(this.pos, (class_2680)farm.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(7)), 3);
        }
    }

    public void onStorming(class_3218 level, int currentDay) {
        if (!this.isFarmBlock || this.lastWeatherDay == currentDay) {
            return;
        }
        if (!this.isLoaded) {
            this.onWatering(level, currentDay);
            ++this.scheduledStormTicks;
            return;
        }
        this.onWatering(level, currentDay);
        this.doStormingLogic(level, 1);
    }

    private void doStormingLogic(class_3218 level, int amount) {
        if (!this.isFarmBlock) {
            return;
        }
        class_2680 state = null;
        class_2338 cropPos = this.pos.method_10084();
        for (int i = 0; i < amount; ++i) {
            boolean destroyChance;
            --this.defence;
            if (this.defence > 0) continue;
            state = state == null ? level.method_8320(cropPos) : state;
            boolean bl = destroyChance = level.field_9229.method_43057() < 0.4f;
            if (!destroyChance) continue;
            if (state.method_26204() instanceof Growable) {
                if (level.field_9229.method_43057() < 0.6f) {
                    state = class_2246.field_10124.method_9564();
                    level.method_22352(cropPos, true);
                    continue;
                }
                state = ((HerbBlock)((Object)RuneCraftoryBlocks.WITHERED_GRASS.get())).method_9564();
                continue;
            }
            state = class_2246.field_10566.method_9564();
            break;
        }
        FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        if (state != null) {
            if (state.method_26204() == class_2246.field_10566) {
                level.method_8652(this.pos, state, 3);
            } else if (state.method_26204() == class_2246.field_10124) {
                level.method_22352(cropPos, true);
            } else {
                level.method_8652(cropPos, state, 3);
            }
        }
    }

    public void tick(class_3218 level, boolean onLoad) {
        class_2248 class_22482;
        if (!this.isLoaded && !GeneralConfig.tickUnloadedFarmland) {
            return;
        }
        if (!this.isFarmBlock) {
            this.lastUpdateDay = WorldUtils.day((class_1937)level);
            this.handleNotFarmblock(level);
            return;
        }
        Calendar handler = Calendar.get((class_1937)level);
        ExternalModifiers ext = new ExternalModifiers(handler.currentSeason(), handler.currentWeather());
        if (!this.isLoaded) {
            this.scheduledData.add(ext);
            return;
        }
        this.lastUpdateDay = WorldUtils.day((class_1937)level);
        class_2680 farm = level.method_8320(this.pos);
        this.isFarmBlock = FarmlandHandler.isFarmBlock(farm);
        boolean isWet = this.isFarmBlock && (Integer)farm.method_11654((class_2769)class_2344.field_11009) > 0;
        boolean canRainAt = FarmlandHandler.canRainingAt((class_1937)level, this.pos);
        if (!onLoad) {
            this.scheduledData.add(ext);
        } else {
            this.doStormingLogic(level, this.scheduledStormTicks);
            if (!this.isFarmBlock) {
                this.handleNotFarmblock(level);
                return;
            }
            if (!isWet && canRainAt && this.scheduledWatering > 0 && farm.method_26204() instanceof class_2344) {
                --this.scheduledWatering;
                isWet = true;
            }
        }
        boolean ignoreWater = FarmlandHandler.get(level.method_8503()).hasWater(level, this.pos);
        if (ignoreWater) {
            isWet = true;
        }
        class_2338 cropPos = this.pos.method_10084();
        class_2680 cropState = level.method_8320(cropPos);
        ArrayList<Runnable> run = new ArrayList<Runnable>();
        if (isWet) {
            run.add(() -> level.method_8652(this.pos, (class_2680)farm.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(0)), 3));
        }
        boolean growHerb = false;
        boolean cropRecalc = false;
        CropProperties props = cropState.method_26204() instanceof Growable ? DataPackHandler.INSTANCE.cropManager().get(cropState.method_26204()) : null;
        int wiltStage = 0;
        for (ExternalModifiers modifiers : this.scheduledData) {
            boolean hasGiantVersion;
            class_2248 class_22483 = cropState.method_26204();
            if (!(class_22483 instanceof Growable)) {
                this.normalizeLand();
                this.resetCrop();
                if (!growHerb && cropState.method_26215()) {
                    if ((double)level.field_9229.method_43057() < 0.02) {
                        run.add(() -> GrassRegrowUtil.tryGrowHerb(level, cropPos));
                        growHerb = true;
                    } else {
                        growHerb = true;
                    }
                }
                if (!growHerb || !this.hasDefaultStats()) continue;
                break;
            }
            Growable crop = (Growable)class_22483;
            boolean bl = hasGiantVersion = props != null && props.getGiantVersion().map(g -> !cropState.method_27852(g)).orElse(false) != false;
            if (!crop.canGrow(level, cropPos, cropState) && (!hasGiantVersion || this.size == 0.0f || this.size < 0.0f && this.cropSize <= 0.0f)) break;
            boolean didCropGrow = false;
            boolean maxAgeStop = false;
            if (props != null) {
                if (!cropRecalc) {
                    cropRecalc = true;
                    if (crop.canGrow(level, cropPos, cropState)) {
                        run.add(() -> {
                            int maxAge = crop.runecraftory$getGrowableMaxAge();
                            int stage = class_3532.method_15375((float)(this.cropAge * (float)maxAge / (float)props.growth()));
                            class_2680 newState = crop.runecraftory$getGrowableStateForAge(cropState, Math.min(stage, maxAge));
                            this.isGrowing = true;
                            class_2248 patt0$temp = newState.method_26204();
                            if (patt0$temp instanceof Growable) {
                                Growable newGrowable = (Growable)patt0$temp;
                                newGrowable.onGrow(level, cropPos, newState, cropState);
                            } else {
                                level.method_8652(cropPos, newState, 3);
                            }
                            this.isGrowing = false;
                            Platform.INSTANCE.cropGrowEventPost((class_1937)level, cropPos, level.method_8320(cropPos));
                        });
                    } else {
                        run.add(() -> CropUtils.attemptGiantize(level, cropPos, crop, cropState, this.cropSize, props));
                    }
                }
                if (!isWet) {
                    float mod = (255.0f - (float)this.getHealth()) / 255.0f + 0.2f;
                    float chance = mod * GeneralConfig.witherChance;
                    if (level.field_9229.method_43057() < chance && !(cropState.method_26204() instanceof GrowableCrop) && ++wiltStage > 1) break;
                }
                float season = props.seasonMultiplier(modifiers.season);
                float runeyBonus = modifiers.weather == Weather.RUNEY ? 5.0f : 1.0f;
                float speed = this.growth * season * runeyBonus;
                if (!isWet) {
                    speed *= 0.5f;
                }
                this.cropAge += Math.min((float)props.growth(), speed);
                this.cropLevel += this.quality * (level.method_8409().method_43057() * 0.5f + 0.5f);
                if (crop.runecraftory$isAtMaxAge(cropState) && hasGiantVersion) {
                    if (this.size != 0.0f) {
                        this.cropSize += this.size * (level.method_8409().method_43057() * 0.2f + 0.1f);
                        didCropGrow = this.size > 0.0f ? this.cropSize < 1.0f : this.cropSize > 0.0f;
                    }
                } else {
                    didCropGrow = true;
                }
                if (!didCropGrow) {
                    maxAgeStop = true;
                }
            }
            if (!ignoreWater && canRainAt) {
                isWet = this.scheduledWatering > 0;
            }
            this.scheduledWatering = Math.max(0, --this.scheduledWatering);
            if (didCropGrow) {
                if (level.field_9229.method_43048(3) != 0) {
                    this.modifyHealth(null, -1);
                }
                if (level.field_9229.method_43056()) {
                    this.applyGrowthFertilizer(null, this.growth > 1.0f ? -0.1f : -0.05f);
                }
                if (level.field_9229.method_43056()) {
                    this.modifyQuality(null, -0.05f);
                }
            } else {
                this.normalizeLand();
            }
            if (!maxAgeStop) continue;
            break;
        }
        this.resetScheduledData();
        run.forEach(Runnable::run);
        if (wiltStage > 0 && (class_22482 = cropState.method_26204()) instanceof GrowableCrop) {
            GrowableCrop blockCrop = (GrowableCrop)class_22482;
            blockCrop.onWither(wiltStage, (class_1937)level, cropState, cropPos);
        }
        this.cropProgress = this.growthPercent(level, cropState);
        FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
    }

    private void handleNotFarmblock(class_3218 level) {
        this.normalizeLand();
        this.resetCrop();
        FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
        this.resetScheduledData();
    }

    private void resetScheduledData() {
        this.scheduledData.clear();
        this.scheduledWatering = 0;
        this.scheduledStormTicks = 0;
    }

    private void normalizeLand() {
        this.growth = this.growth > 1.0f ? Math.max(this.growth - 0.1f, 1.0f) : Math.min(this.growth + 0.1f, 1.0f);
        this.modifyQuality(null, -0.1f);
        this.size = class_3532.method_15363((float)(this.size - 0.05f), (float)0.0f, (float)2.0f);
        this.health = this.health > 64 ? Math.max(this.health - 1, 64) : Math.min(this.health + 1, 64);
    }

    private void resetCrop() {
        this.cropAge = 0.0f;
        this.cropLevel = 1.0f;
        this.cropSize = 0.0f;
        this.cropProgress = 0;
    }

    public void onLoad(class_3218 level, boolean tick) {
        if (tick && this.lastUpdateDay != WorldUtils.day((class_1937)level)) {
            level.method_8503().method_18858((Runnable)new class_3738(1, () -> this.tick(level, true)));
        }
        this.isLoaded = true;
    }

    public void onUnload(class_3218 level) {
        this.isLoaded = false;
        FarmlandHandler.get(level.method_8503()).scheduleUpdate(level, this);
    }

    public void load(class_2487 nbt) {
        this.growth = nbt.method_10583("Growth");
        this.quality = nbt.method_10583("Quality");
        this.size = nbt.method_10583("Size");
        this.defence = nbt.method_10550("Defence");
        this.health = nbt.method_10550("Health");
        this.cropAge = nbt.method_10583("CropAge");
        this.cropLevel = nbt.method_10583("CropLevel");
        this.cropSize = nbt.method_10583("CropSize");
        this.cropProgress = nbt.method_10550("CropProgress");
        this.lastUpdateDay = nbt.method_10550("LastUpdate");
        this.lastWeatherDay = nbt.method_10550("LastWeatherDay");
        this.scheduledStormTicks = nbt.method_10550("ScheduledStormTicks");
        this.scheduledWatering = nbt.method_10550("ScheduledWaterAmount");
        class_2499 scheduledDataTag = nbt.method_10554("ScheduledData", 10);
        scheduledDataTag.forEach(t -> {
            class_2487 lT = (class_2487)t;
            this.scheduledData.add(new ExternalModifiers(Season.valueOf(lT.method_10558("Season")), Weather.valueOf(lT.method_10558("Weather"))));
        });
        this.isLoaded = nbt.method_10577("IsLoaded");
        this.isFarmBlock = nbt.method_10577("IsFarmBlock");
    }

    public class_2487 save() {
        class_2487 nbt = new class_2487();
        nbt.method_10548("Growth", this.growth);
        nbt.method_10548("Quality", this.quality);
        nbt.method_10548("Size", this.size);
        nbt.method_10569("Health", this.health);
        nbt.method_10569("Defence", this.defence);
        nbt.method_10548("CropAge", this.cropAge);
        nbt.method_10548("CropLevel", this.cropLevel);
        nbt.method_10548("CropSize", this.cropSize);
        nbt.method_10569("CropProgress", this.cropProgress);
        nbt.method_10569("LastUpdate", this.lastUpdateDay);
        nbt.method_10569("LastWeatherDay", this.lastWeatherDay);
        nbt.method_10569("ScheduledStormTicks", this.scheduledStormTicks);
        nbt.method_10569("ScheduledWaterAmount", this.scheduledWatering);
        class_2499 scheduledDataTag = new class_2499();
        this.scheduledData.forEach(mod -> {
            class_2487 lT = new class_2487();
            lT.method_10582("Season", mod.season.name());
            lT.method_10582("Weather", mod.weather.name());
            scheduledDataTag.add((Object)lT);
        });
        nbt.method_10566("ScheduledData", (class_2520)scheduledDataTag);
        nbt.method_10556("IsLoaded", this.isLoaded);
        nbt.method_10556("IsFarmBlock", this.isFarmBlock);
        return nbt;
    }

    public FarmlandDataContainer forSync() {
        return new FarmlandDataContainer(this.pos, this.growth, this.quality, this.size, this.health, this.defence, this.cropProgress, Math.min(100, (int)this.cropSize * 100), this.cropLevel);
    }

    public String toString() {
        return String.format("Farmland[%s, Loaded:%s, IsFarm:%s]", this.pos, this.isLoaded, this.isFarmBlock);
    }

    public String toStringFull() {
        return String.format("Farmland[%s, Loaded:%s, IsFarm:%s]: Growth:%s;Quality:%s;Size:%s;Health:%s;Defence:%s - Schedules:[StormTicks:%s;Watering:%s], Data: %s", this.pos, this.isLoaded, this.isFarmBlock, Float.valueOf(this.growth), Float.valueOf(this.quality), Float.valueOf(this.size), this.health, this.defence, this.scheduledStormTicks, this.scheduledWatering, this.scheduledData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FarmlandData) {
            FarmlandData data = (FarmlandData)obj;
            return data.pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    protected record ExternalModifiers(Season season, Weather weather) {
    }
}

