/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features.trees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeRootBlock;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFeatures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class FruitTreeTrunkPlacer
extends class_5141 {
    public static final MapCodec<FruitTreeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("base_height").forGetter(d -> d.field_23760), (App)Codec.INT.fieldOf("height_rand_a").forGetter(d -> d.field_23761), (App)Codec.INT.fieldOf("min_branches").forGetter(d -> d.minBranches), (App)Codec.INT.fieldOf("max_branches").forGetter(d -> d.maxBranches)).apply((Applicative)instance, FruitTreeTrunkPlacer::new));
    private final int minBranches;
    private final int maxBranches;

    public FruitTreeTrunkPlacer(int baseHeight, int heightRandA, int minBranches, int maxBranches) {
        super(baseHeight, heightRandA, 0);
        this.minBranches = minBranches;
        this.maxBranches = maxBranches;
    }

    protected static boolean placeIfFree(class_3746 level, Map<class_2338, class_2680> blockSetter, class_2338 pos, class_2680 state) {
        if (level.method_16358(pos, TreeBaseBlock::isAirOrReplaceable)) {
            blockSetter.put(pos, state);
            return true;
        }
        return false;
    }

    protected class_5142<?> method_28903() {
        return (class_5142)RuneCraftoryFeatures.FRUIT_TRUNK_PLACER.get();
    }

    public List<class_4647.class_5208> method_26991(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, int freeTreeHeight, class_2338 pos, class_4643 config) {
        class_2338 soil = pos.method_10074();
        HashMap<class_2338, class_2680> placements = new HashMap<class_2338, class_2680>();
        if (level.method_16358(soil, s -> !s.method_27852((class_2248)RuneCraftoryBlocks.TREE_SOIL.get()))) {
            placements.put(soil, ((TreeRootBlock)((Object)RuneCraftoryBlocks.TREE_SOIL.get())).method_9564());
        }
        ArrayList<class_4647.class_5208> foliagePos = new ArrayList<class_4647.class_5208>();
        for (int i = 1; i <= freeTreeHeight; ++i) {
            class_2338 log = pos.method_10086(i);
            if (!FruitTreeTrunkPlacer.placeIfFree(level, placements, log, config.field_21288.method_23455(random, log))) {
                return List.of();
            }
            if (i != freeTreeHeight || freeTreeHeight > 3) continue;
            foliagePos.add(new class_4647.class_5208(log.method_10084(), -1, false));
        }
        ArrayList dirs = new ArrayList(class_2350.class_2353.field_11062.method_29716().toList());
        float chance = 1.0f;
        for (int i = 0; i < dirs.size(); ++i) {
            int offset;
            class_2350 dir = (class_2350)dirs.remove(random.method_43048(dirs.size()));
            if (!(random.method_43057() < chance)) continue;
            int n = offset = freeTreeHeight <= 3 || random.method_43048(3) == 0 ? 1 : 0;
            if (!this.growBranch(pos.method_10086(freeTreeHeight + offset), dir, config, level, placements, random, random.method_43051(this.minBranches, this.maxBranches + 1), foliagePos)) {
                return List.of();
            }
            chance = (float)((double)chance - 0.3);
        }
        placements.forEach(blockSetter);
        return foliagePos;
    }

    public int method_26993(class_5819 random) {
        return random.method_43048(1 + this.field_23761) + this.field_23760;
    }

    private boolean growBranch(class_2338 pos, class_2350 dir, class_4643 config, class_3746 level, Map<class_2338, class_2680> blockSetter, class_5819 rand, int amount, List<class_4647.class_5208> logs) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || dir.method_10148() != 0 && i == -dir.method_10148() || dir.method_10165() != 0 && j == -dir.method_10165()) continue;
                list.add(new class_2338(i, 0, j));
            }
        }
        class_2338.class_2339 mut = pos.method_25503();
        for (int i = 0; i < amount; ++i) {
            class_2338 d = (class_2338)list.get(rand.method_43048(list.size()));
            class_2350 class_23502 = d.method_10263() == 0 || d.method_10260() == 0 ? class_2350.method_50026((int)d.method_10263(), (int)d.method_10264(), (int)d.method_10260()) : (dir = rand.method_43056() ? dir.method_10170() : dir);
            if (i != 0 && (mut.method_10264() == pos.method_10264() ? rand.method_43048(2) == 0 : rand.method_43048(3) == 0)) {
                d = d.method_10084();
            }
            mut.method_30927((class_2382)d);
            class_2338 newPos = mut.method_10062();
            if (!FruitTreeTrunkPlacer.placeIfFree(level, blockSetter, newPos, (class_2680)config.field_21288.method_23455(rand, newPos).method_11657((class_2769)class_2465.field_11459, (Comparable)dir.method_10166()))) {
                return false;
            }
            logs.add(new class_4647.class_5208(newPos.method_10084(), 0, false));
        }
        return true;
    }
}

