/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jade;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.blocks.MonsterBarnBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.tenshilib.common.entity.MultiPartEntity;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_5131;
import net.minecraft.class_5135;
import net.minecraft.class_5250;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.SimpleProgressStyle;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final class_2960 ID = RuneCraftory.modRes("jade_entity_plugin");
    private static final class_2960 BARN_BLOCK_PLUGIN = RuneCraftory.modRes("jade_barn_block_plugin");
    private static final class_2960 TREE_BLOCK_PLUGIN = RuneCraftory.modRes("jade_tree_block_plugin");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(class_2487 compoundTag, BlockAccessor accessor) {
                MonsterBarnBlockEntity barn;
                BarnData data;
                class_2586 class_25862 = accessor.getBlockEntity();
                if (class_25862 instanceof MonsterBarnBlockEntity && (data = (barn = (MonsterBarnBlockEntity)class_25862).getBarnData()) != null) {
                    compoundTag.method_10556("Roof", data.hasRoof());
                    compoundTag.method_10569("RoofHeight", data.roofHeight());
                    compoundTag.method_10569("Size", data.getSize());
                    compoundTag.method_10569("Used", data.usedCapacity());
                    compoundTag.method_10569("Capacity", data.getCapacity());
                }
            }

            public class_2960 getUid() {
                return BARN_BLOCK_PLUGIN;
            }
        }, MonsterBarnBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(class_2487 compoundTag, BlockAccessor accessor) {
                class_2586 class_25862 = accessor.getBlockEntity();
                if (class_25862 instanceof TreeBlockEntity) {
                    TreeBlockEntity tree = (TreeBlockEntity)class_25862;
                    compoundTag.method_10569("Health", tree.getHealth());
                }
            }

            public class_2960 getUid() {
                return TREE_BLOCK_PLUGIN;
            }
        }, TreeBaseBlock.class);
        registration.registerEntityDataProvider((IServerDataProvider)new IServerDataProvider<EntityAccessor>(this){

            public void appendServerData(class_2487 compoundTag, EntityAccessor accessor) {
                class_1657 player;
                class_1297 entity;
                block13: {
                    IBaseMob mob;
                    block14: {
                        entity = accessor.getEntity();
                        player = accessor.getPlayer();
                        if (!(entity instanceof IBaseMob)) break block13;
                        mob = (IBaseMob)entity;
                        if (player.method_6047().method_7909() == RuneCraftoryItems.DEBUG.get() || player.method_7337()) break block14;
                        if (!(entity instanceof class_6025)) break block13;
                        class_6025 ownable = (class_6025)entity;
                        if (!player.method_5667().equals(ownable.method_6139())) break block13;
                    }
                    XpLevelHolder entityLevel = mob.xpLevel();
                    compoundTag.method_10548("RunecraftoryLevelPerc", entityLevel.getProgress());
                    compoundTag.method_10569("RunecraftoryLevel", entityLevel.getLevel());
                }
                if (entity instanceof BaseMonster) {
                    BaseMonster monster = (BaseMonster)entity;
                    if (player.method_6047().method_7909() == RuneCraftoryItems.DEBUG.get()) {
                        compoundTag.method_10566("Attributes", (class_2520)monster.method_6127().method_26855());
                    }
                    if (monster.method_6139() != null) {
                        String username = player.method_5682().method_3793().method_14512(monster.method_6139()).map(GameProfile::getName).orElse(null);
                        if (username == null) {
                            compoundTag.method_10556("HasUsername", false);
                        } else {
                            compoundTag.method_10556("HasUsername", true);
                            compoundTag.method_10582("Username", username);
                        }
                        if (player.method_5667().equals(monster.method_6139())) {
                            compoundTag.method_10569("FP", monster.friendPoints(player));
                            BarnData barn = monster.getAssignedBarn();
                            if (barn != null) {
                                compoundTag.method_10556("HasBarn", true);
                                compoundTag.method_10566("Barn", (class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)barn.pos.comp_2208()).getOrThrow());
                            } else {
                                compoundTag.method_10556("HasBarn", false);
                            }
                            compoundTag.method_10582("Behaviour", monster.behaviourState().toString());
                        }
                    }
                }
                if (entity instanceof NPCEntity) {
                    NPCEntity npc = (NPCEntity)entity;
                    if (npc.followEntity() != null) {
                        compoundTag.method_10566("NPCFollow", (class_2520)class_8824.field_46597.encodeStart((DynamicOps)class_2509.field_11560, (Object)npc.followEntity().method_5476()).getOrThrow());
                    }
                    compoundTag.method_10569("FP", npc.friendPoints(player));
                }
            }

            public class_2960 getUid() {
                return ID;
            }
        }, class_1308.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
                class_2487 tag = blockAccessor.getServerData();
                if (blockAccessor.getBlockEntity() instanceof MonsterBarnBlockEntity) {
                    class_5250 sizeText;
                    int size = tag.method_10550("Size");
                    class_5250 class_52502 = sizeText = size > 1 ? class_2561.method_43470((String)("" + size)).method_27692(class_124.field_1060) : class_2561.method_43470((String)("" + size)).method_27692(class_124.field_1079);
                    if (!tag.method_10577("Roof")) {
                        iTooltip.add((class_2561)class_2561.method_43469((String)"runecraftory.dependency.tooltips.barn.1", (Object[])new Object[]{sizeText}));
                    } else {
                        iTooltip.add((class_2561)class_2561.method_43469((String)"runecraftory.dependency.tooltips.barn.1.alt", (Object[])new Object[]{class_2561.method_43471((String)("" + tag.method_10550("RoofHeight"))).method_27692(class_124.field_1054), sizeText}));
                    }
                    iTooltip.add((class_2561)class_2561.method_43469((String)"runecraftory.dependency.tooltips.barn.2", (Object[])new Object[]{tag.method_10550("Used"), tag.method_10550("Capacity")}));
                }
            }

            public class_2960 getUid() {
                return BARN_BLOCK_PLUGIN;
            }
        }, MonsterBarnBlock.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
                class_2487 tag = blockAccessor.getServerData();
                if (blockAccessor.getBlockEntity() instanceof TreeBlockEntity) {
                    iTooltip.add((class_2561)class_2561.method_43469((String)"runecraftory.dependency.tooltips.tree", (Object[])new Object[]{tag.method_10550("Health")}));
                }
            }

            public class_2960 getUid() {
                return TREE_BLOCK_PLUGIN;
            }
        }, TreeBaseBlock.class);
        registration.addRayTraceCallback((hitResult, accessor, origin) -> {
            MultiPartEntity entity;
            EntityAccessor entityAccessor;
            class_1297 patt0$temp;
            if (accessor instanceof EntityAccessor && (patt0$temp = (entityAccessor = (EntityAccessor)accessor).getEntity()) instanceof MultiPartEntity && class_7923.field_41177.method_10221((Object)(entity = (MultiPartEntity)patt0$temp).method_5864()).method_12836().equals("runecraftory")) {
                accessor = registration.entityAccessor().from(entityAccessor).entity((class_1297)entity.method_35057()).build();
                return accessor;
            }
            return accessor;
        });
        registration.registerEntityComponent((IComponentProvider)new IEntityComponentProvider(this){

            public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
                class_1297 pos;
                BaseMonster monster;
                class_1297 lvl2;
                class_2487 tag = entityAccessor.getServerData();
                if (tag.method_10545("RunecraftoryLevel")) {
                    float prog = tag.method_10583("RunecraftoryLevelPerc");
                    int lvl2 = tag.method_10550("RunecraftoryLevel");
                    iTooltip.add((IElement)new ProgressElement(prog, (class_2561)class_2561.method_43469((String)"runecraftory.tooltip.item.level", (Object[])new Object[]{lvl2}).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}), new SimpleProgressStyle().color(-12674274, -10965189), BoxStyle.getNestedBox(), true));
                }
                if ((lvl2 = entityAccessor.getEntity()) instanceof BaseMonster && (monster = (BaseMonster)lvl2).method_6139() != null) {
                    if (!tag.method_10577("HasUsername")) {
                        iTooltip.add((class_2561)class_2561.method_43471((String)"runecraftory.dependency.tooltips.owner.none").method_27692(class_124.field_1054));
                    } else {
                        String username = tag.method_10558("Username");
                        iTooltip.add((class_2561)class_2561.method_43469((String)"runecraftory.dependency.tooltips.owner", (Object[])new Object[]{username}).method_27692(class_124.field_1065));
                    }
                    if (entityAccessor.getPlayer().method_5667().equals(monster.method_6139())) {
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.friendpoints", (class_2561)class_2561.method_43470((String)("" + tag.method_10550("FP"))), class_124.field_1054, new class_124[0]);
                        if (tag.method_10577("HasBarn")) {
                            pos = (class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("Barn")).getOrThrow();
                            JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.barn", (class_2561)class_2561.method_43470((String)String.format("[%s, %s, %s]", pos.method_10263(), pos.method_10264(), pos.method_10260())), class_124.field_1060, new class_124[0]);
                        } else {
                            iTooltip.add((class_2561)class_2561.method_43471((String)"runecraftory.dependency.tooltips.barn.no").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
                        }
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.behaviour", (class_2561)class_2561.method_43470((String)tag.method_10558("Behaviour")), class_124.field_1054, new class_124[0]);
                    }
                }
                if (tag.method_10545("Attributes") && (pos = entityAccessor.getEntity()) instanceof BaseMonster) {
                    BaseMonster m = (BaseMonster)pos;
                    class_5131 map = new class_5131(class_5135.method_26873((class_1299)m.method_5864()));
                    map.method_26850(tag.method_10554("Attributes", 10));
                    ((AttributeMapAccessor)map).getAttributes().values().stream().sorted((inst, inst2) -> RuneCraftoryAttributes.SORTED.compare((class_6880<class_1320>)inst.method_6198(), (class_6880<class_1320>)inst2.method_6198())).forEach(inst -> iTooltip.add((class_2561)class_2561.method_43469((String)"runecraftory.tooltip.item.attribute", (Object[])new Object[]{class_2561.method_43471((String)((class_1320)inst.method_6198().comp_349()).method_26830()), inst.method_6194()}).method_27692(class_124.field_1065)));
                }
                if (entityAccessor.getEntity() instanceof NPCEntity) {
                    if (tag.method_10545("NPCFollow")) {
                        JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.npc.follow", (class_2561)class_8824.field_46597.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("NPCFollow")).getOrThrow(), class_124.field_1054, new class_124[0]);
                    }
                    JadePlugin.withText(iTooltip, "runecraftory.dependency.tooltips.friendpoints", (class_2561)class_2561.method_43470((String)("" + tag.method_10550("FP"))), class_124.field_1054, new class_124[0]);
                }
            }

            public class_2960 getUid() {
                return ID;
            }
        }, class_1308.class);
    }

    private static void withText(ITooltip tooltip, String key, class_2561 other, class_124 formatting, class_124 ... main) {
        class_2561 class_25612;
        Object[] objectArray = new Object[1];
        if (other instanceof class_5250) {
            class_5250 mut = (class_5250)other;
            class_25612 = mut.method_27692(formatting);
        } else {
            class_25612 = other;
        }
        objectArray[0] = class_25612;
        tooltip.add((class_2561)class_2561.method_43469((String)key, (Object[])objectArray).method_27695(main));
    }
}

