/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class CropProperties {
    public static final Codec<CropProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("growth").forGetter(CropProperties::growth), (App)Codec.INT.fieldOf("max_drops").forGetter(CropProperties::maxDrops), (App)Codec.BOOL.fieldOf("regrowable").forGetter(CropProperties::regrowable), (App)class_7923.field_41175.method_39673().optionalFieldOf("giant_crop").forGetter(CropProperties::getGiantVersion), (App)CodecUtils.stringEnumCodec(Season.class, (Enum)Season.SPRING).listOf().fieldOf("best_season").forGetter(d -> List.copyOf(d.bestSeasons)), (App)CodecUtils.stringEnumCodec(Season.class, (Enum)Season.SPRING).listOf().fieldOf("bad_season").forGetter(d -> List.copyOf(d.badSeasons))).apply((Applicative)instance, CropProperties::new));
    public static final class_9139<class_9129, CropProperties> STREAM_CODEC = new class_9139<class_9129, CropProperties>(){

        public CropProperties decode(class_9129 buf) {
            return new CropProperties(buf.readInt(), buf.readInt(), buf.readBoolean(), (Optional)class_9135.method_56382((class_9139)class_9135.method_56365((class_5321)class_7924.field_41254)).decode((Object)buf), buf.method_46251(Season.class), buf.method_46251(Season.class));
        }

        public void encode(class_9129 buf, CropProperties props) {
            buf.method_53002(props.growth());
            buf.method_53002(props.maxDrops());
            buf.method_52964(props.regrowable());
            class_9135.method_56382((class_9139)class_9135.method_56365((class_5321)class_7924.field_41254)).encode((Object)buf, props.getGiantVersion());
            buf.method_46253(props.bestSeasons, Season.class);
            buf.method_46253(props.badSeasons, Season.class);
        }
    };
    private final EnumSet<Season> bestSeasons = EnumSet.noneOf(Season.class);
    private final EnumSet<Season> badSeasons = EnumSet.noneOf(Season.class);
    private final int growth;
    private final int maxDrops;
    private final boolean regrowable;
    private final Optional<class_2248> giantVersion;
    private final List<class_2561> translationTexts;

    public CropProperties(int growth, int maxDrops, boolean regrowable, Optional<class_2248> giantVersion, Collection<Season> bestSeasons, Collection<Season> badSeasons) {
        this.growth = growth;
        this.maxDrops = maxDrops;
        this.giantVersion = giantVersion;
        this.regrowable = regrowable;
        this.bestSeasons.addAll(bestSeasons);
        this.badSeasons.addAll(badSeasons);
        this.translationTexts = this.generateText();
    }

    private List<class_2561> generateText() {
        ImmutableList.Builder list = ImmutableList.builder();
        if (!this.bestSeasons.isEmpty()) {
            class_5250 txt = null;
            for (Season season : this.bestSeasons) {
                if (txt == null) {
                    txt = class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor());
                    continue;
                }
                txt.method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor()));
            }
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.season.best", (Object[])new Object[]{txt}).method_27692(class_124.field_1080));
        }
        EnumSet<Season> badSeasons = EnumSet.copyOf(this.badSeasons);
        badSeasons.removeAll(this.bestSeasons);
        if (!badSeasons.isEmpty()) {
            class_5250 txt = null;
            for (Season season : badSeasons) {
                if (txt == null) {
                    txt = class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor());
                    continue;
                }
                txt.method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor()));
            }
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.season.bad", (Object[])new Object[]{txt}).method_27692(class_124.field_1080));
        }
        class_5250 growth = class_2561.method_43469((String)"runecraftory.tooltip.crops.growth", (Object[])new Object[]{this.growth()}).method_27692(class_124.field_1065);
        class_5250 class_52502 = class_2561.method_43469((String)"runecraftory.tooltip.crops.harvested", (Object[])new Object[]{this.maxDrops()}).method_27692(class_124.field_1065);
        if (this.regrowable()) {
            class_5250 regrowable = class_2561.method_43471((String)"runecraftory.tooltip.crops.regrowable").method_27692(class_124.field_1060);
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.entry.3", (Object[])new Object[]{growth, class_52502, regrowable}));
        } else {
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.entry.2", (Object[])new Object[]{growth, class_52502}));
        }
        return list.build();
    }

    public Set<Season> bestSeasons() {
        return ImmutableSet.copyOf(this.bestSeasons);
    }

    public Set<Season> badSeasons() {
        return ImmutableSet.copyOf(this.badSeasons);
    }

    public int growth() {
        return this.growth;
    }

    public int maxDrops() {
        return this.maxDrops;
    }

    public boolean regrowable() {
        return this.regrowable;
    }

    public Optional<class_2248> getGiantVersion() {
        return this.giantVersion;
    }

    public float seasonMultiplier(Season season) {
        if (this.bestSeasons.contains((Object)season)) {
            return 1.5f;
        }
        if (this.badSeasons.contains((Object)season)) {
            return 0.6666667f;
        }
        return 1.0f;
    }

    public List<class_2561> texts() {
        return this.translationTexts;
    }

    public String toString() {
        return "[BestSeasons:" + String.valueOf(this.bestSeasons) + ";BadSeasons:" + String.valueOf(this.badSeasons) + ";Growth:" + this.growth + ";Drops:" + this.maxDrops + ";Regrowable:" + this.regrowable + "]";
    }

    public static class Builder {
        private final EnumSet<Season> bestSeason = EnumSet.noneOf(Season.class);
        private final EnumSet<Season> badSeason = EnumSet.noneOf(Season.class);
        private final int growth;
        private final int maxDrops;
        private final boolean regrowable;
        private class_2248 giantVersion;

        public Builder(int growth, int maxDrops, boolean regrowable) {
            this.growth = growth;
            this.maxDrops = maxDrops;
            this.regrowable = regrowable;
        }

        public Builder addGoodSeason(Season season) {
            this.bestSeason.add(season);
            return this;
        }

        public Builder addBadSeason(Season season) {
            this.badSeason.add(season);
            return this;
        }

        public Builder withGiantVersion(class_2248 giantVersion) {
            this.giantVersion = giantVersion;
            return this;
        }

        public CropProperties build() {
            return new CropProperties(this.growth, this.maxDrops, this.regrowable, Optional.ofNullable(this.giantVersion), this.bestSeason, this.badSeason);
        }
    }
}

