/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GiftData {
    public static final Codec<GiftData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.either(ShopItemProperties.TAG_CODEC, (Codec)class_7923.field_41178.method_39673()).listOf().fieldOf("items").forGetter(d -> d.items), (App)Range.CODEC.optionalFieldOf("xp_range").forGetter(d -> Optional.ofNullable(d.xp_range)), (App)class_5699.method_36973((Codec)Codec.STRING.listOf()).fieldOf("translations").forGetter(d -> d.translations)).apply((Applicative)inst, GiftData::new));
    private final List<Either<class_6862<class_1792>, class_1792>> items;
    private final Range xp_range;
    private final List<String> translations;

    private GiftData(List<Either<class_6862<class_1792>, class_1792>> items, Optional<Range> xp_range, List<String> translations) {
        this(items, (Range)xp_range.orElse(null), translations);
    }

    private GiftData(List<Either<class_6862<class_1792>, class_1792>> items, Range xp_range, List<String> translations) {
        this.items = items;
        this.xp_range = xp_range;
        this.translations = translations;
    }

    public String translation(Random random) {
        return this.translations.get(random.nextInt(this.translations.size()));
    }

    public boolean is(class_1799 stack) {
        for (Either<class_6862<class_1792>, class_1792> item : this.items) {
            if (!((Boolean)item.map(arg_0 -> ((class_1799)stack).method_31573(arg_0), arg_0 -> ((class_1799)stack).method_31574(arg_0))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(int xp) {
        return !(this.xp_range == null || this.xp_range.min != null && this.xp_range.min > xp || this.xp_range.max != null && this.xp_range.max < xp);
    }

    public static Builder builder(class_6862<class_1792> tag, String key, String translation) {
        return new Builder(tag, key, translation);
    }

    public static Builder builder(class_1792 item, String key, String translation) {
        return new Builder(item, key, translation);
    }

    private record Range(@Nullable Integer min, @Nullable Integer max) {
        public static final Codec<Range> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.optionalFieldOf("min").forGetter(d -> Optional.ofNullable(d.min)), (App)Codec.INT.optionalFieldOf("max").forGetter(d -> Optional.ofNullable(d.max))).apply((Applicative)inst, (min, max) -> new Range(min.orElse(null), max.orElse(null))));
    }

    public static class Builder {
        private final List<Either<class_6862<class_1792>, class_1792>> items = new ArrayList<Either<class_6862<class_1792>, class_1792>>();
        private Range range;
        public Map<String, String> translations = new LinkedHashMap<String, String>();

        public Builder(class_6862<class_1792> tag, String key, String translation) {
            this.items.add((Either<class_6862<class_1792>, class_1792>)Either.left(tag));
            this.translations.put(key, translation);
        }

        public Builder(class_1792 item, String key, String translation) {
            this.items.add((Either<class_6862<class_1792>, class_1792>)Either.right((Object)item));
            this.translations.put(key, translation);
        }

        public Builder selectable() {
            this.range = new Range(null, null);
            return this;
        }

        public Builder min(int min) {
            this.range = new Range(min, null);
            return this;
        }

        public Builder max(int max) {
            this.range = new Range(null, max);
            return this;
        }

        public Builder range(int min, int max) {
            this.range = new Range(min, max);
            return this;
        }

        public Builder add(class_1792 ... items) {
            for (class_1792 item : items) {
                this.items.add((Either<class_6862<class_1792>, class_1792>)Either.right((Object)item));
            }
            return this;
        }

        public Builder add(class_6862<class_1792> tag) {
            this.items.add((Either<class_6862<class_1792>, class_1792>)Either.left(tag));
            return this;
        }

        public Builder addTranslation(String key, String translation) {
            this.translations.put(key, translation);
            return this;
        }

        public GiftData build() {
            return new GiftData(this.items, this.range, this.translations.keySet().stream().toList());
        }
    }
}

