/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.datapack.provider.AdditionalLanguages;
import io.github.flemmli97.runecraftory.api.datapack.provider.FileVerifier;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.GiftManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCActionManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCConversationManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCDataManager;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCLookManager;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackActions;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class NPCDataProvider
implements class_2405,
AdditionalLanguages {
    private final Map<class_2960, NPCLook> looks = new HashMap<class_2960, NPCLook>();
    private final Map<class_2960, ConversationSet> conversations = new HashMap<class_2960, ConversationSet>();
    private final Map<class_2960, GiftData> giftData = new LinkedHashMap<class_2960, GiftData>();
    private final Map<class_2960, NPCAttackActions> actions = new HashMap<class_2960, NPCAttackActions>();
    private final Map<class_2960, NPCData> data = new HashMap<class_2960, NPCData>();
    public final Map<String, Map<String, String>> dialogueTranslations = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    private final class_7784 packOutput;
    private final FileVerifier verifier;
    protected final String modid;
    protected final CompletableFuture<class_7225.class_7874> provider;

    public NPCDataProvider(class_7784 packOutput, FileVerifier verifier, String modid, CompletableFuture<class_7225.class_7874> provider) {
        this.packOutput = packOutput;
        this.verifier = verifier;
        this.modid = modid;
        this.provider = provider;
    }

    protected abstract void add(class_7225.class_7874 var1);

    public CompletableFuture<?> method_10319(class_7403 cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((class_7225.class_7874)provider);
            return provider;
        })).thenCompose(provider -> {
            class_6903 ops = provider.method_57093((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.data.forEach((arg_0, arg_1) -> this.lambda$run$1((DynamicOps)ops, futures, cache, arg_0, arg_1));
            this.looks.forEach((arg_0, arg_1) -> this.lambda$run$2((DynamicOps)ops, cache, futures, arg_0, arg_1));
            this.conversations.forEach((arg_0, arg_1) -> this.lambda$run$3((DynamicOps)ops, futures, cache, arg_0, arg_1));
            this.giftData.forEach((arg_0, arg_1) -> this.lambda$run$4((DynamicOps)ops, cache, futures, arg_0, arg_1));
            this.actions.forEach((arg_0, arg_1) -> this.lambda$run$5((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String method_10321() {
        return "NPCData for " + this.modid;
    }

    public void addNPCData(String id, NPCData.Builder data, Map<ConversationContext, ConversationSet.Builder> conversations, Map<class_2960, QuestResponseBuilder> questConversations) {
        conversations.forEach((key, value) -> {
            class_2960 conversationId = class_2960.method_60655((String)this.modid, (String)(id + "/" + key.key().method_12832()));
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.getTranslations());
            this.conversations.put(conversationId, value.build());
            data.addInteractionIfAbsent((ConversationContext)key, conversationId);
        });
        questConversations.forEach((key, value) -> {
            class_2960 startId = class_2960.method_60655((String)this.modid, (String)(id + "/quest_start_" + key.method_12832()));
            for (int i = 0; i < value.start.size(); ++i) {
                Object path = startId.method_12832();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                class_2960 runIdI = class_2960.method_60655((String)this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.start.get(i).getTranslations());
                this.conversations.put(runIdI, value.start.get(i).build());
            }
            class_2960 runId = class_2960.method_60655((String)this.modid, (String)(id + "/quest_active_" + key.method_12832()));
            for (int i = 0; i < value.active.size(); ++i) {
                Object path = runId.method_12832();
                if (i != 0) {
                    path = (String)path + "_" + i;
                }
                class_2960 runIdI = class_2960.method_60655((String)this.modid, (String)path);
                this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.active.get(i).getTranslations());
                this.conversations.put(runIdI, value.active.get(i).build());
            }
            class_2960 endId = class_2960.method_60655((String)this.modid, (String)(id + "/quest_end_" + key.method_12832()));
            this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(value.end.getTranslations());
            this.conversations.put(endId, value.end.build());
            data.addQuestResponse((class_2960)key, startId, runId, endId);
        });
        this.dialogueTranslations.computeIfAbsent(id, o -> new LinkedHashMap()).putAll(data.getTranslations());
        this.data.put(class_2960.method_60655((String)this.modid, (String)id), data.build());
    }

    public class_2960 addLook(class_2960 id, NPCLook look) {
        if (this.looks.put(id, look) != null) {
            throw new IllegalStateException("Look already registered");
        }
        this.verifier.track(id, class_3264.field_14190, NPCLookManager.DIRECTORY);
        return id;
    }

    public class_2960 addGiftData(class_2960 id, GiftData.Builder giftData) {
        if (this.giftData.put(id, giftData.build()) != null) {
            throw new IllegalStateException("GiftData already registered");
        }
        this.translations.putAll(giftData.translations);
        this.verifier.track(id, class_3264.field_14190, GiftManager.DIRECTORY);
        return id;
    }

    public class_2960 addAttackActions(class_2960 id, NPCAttackActions.Builder actions) {
        if (this.actions.put(id, actions.build()) != null) {
            throw new IllegalStateException("Attack action already registered");
        }
        this.verifier.track(id, class_3264.field_14190, NPCActionManager.DIRECTORY);
        return id;
    }

    private void verifyData(NPCData data) {
        if (data.look() != null) {
            for (NPCData.NPCLookId look : data.look()) {
                if (this.verifier.exists(look.id(), class_3264.field_14190, NPCLookManager.DIRECTORY)) continue;
                throw new IllegalStateException("No look registered for " + String.valueOf(look.id()));
            }
        }
        if (data.combatActions() != null) {
            for (class_2960 action : data.combatActions()) {
                if (this.verifier.exists(action, class_3264.field_14190, NPCActionManager.DIRECTORY)) continue;
                throw new IllegalStateException("No npc action registered for " + String.valueOf(action));
            }
        }
        data.giftItems().forEach((s, g) -> {
            if (g.giftID() != null && !this.verifier.exists(g.giftID(), class_3264.field_14190, GiftManager.DIRECTORY)) {
                throw new IllegalStateException("No gift registered for " + String.valueOf(g.giftID()));
            }
        });
    }

    @Override
    public Map<String, String> translations() {
        return this.translations;
    }

    private /* synthetic */ void lambda$run$5(DynamicOps ops, ImmutableList.Builder futures, class_7403 cache, class_2960 res, NPCAttackActions val) {
        Path path = this.packOutput.method_45972(class_7784.class_7490.field_39367).resolve(res.method_12836() + "/" + NPCActionManager.DIRECTORY + "/" + res.method_12832() + ".json");
        JsonElement obj = (JsonElement)NPCAttackActions.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        futures.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$4(DynamicOps ops, class_7403 cache, ImmutableList.Builder futures, class_2960 res, GiftData val) {
        Path path = this.packOutput.method_45972(class_7784.class_7490.field_39367).resolve(res.method_12836() + "/" + GiftManager.DIRECTORY + "/" + res.method_12832() + ".json");
        JsonElement obj = (JsonElement)GiftData.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
        futures.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$3(DynamicOps ops, ImmutableList.Builder futures, class_7403 cache, class_2960 res, ConversationSet val) {
        Path path = this.packOutput.method_45972(class_7784.class_7490.field_39367).resolve(res.method_12836() + "/" + NPCConversationManager.DIRECTORY + "/" + res.method_12832() + ".json");
        JsonElement obj = (JsonElement)ConversationSet.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        futures.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$2(DynamicOps ops, class_7403 cache, ImmutableList.Builder futures, class_2960 res, NPCLook val) {
        Path path = this.packOutput.method_45972(class_7784.class_7490.field_39367).resolve(res.method_12836() + "/" + NPCLookManager.DIRECTORY + "/" + res.method_12832() + ".json");
        JsonElement obj = (JsonElement)NPCLook.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
        futures.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
    }

    private /* synthetic */ void lambda$run$1(DynamicOps ops, ImmutableList.Builder futures, class_7403 cache, class_2960 res, NPCData val) {
        Path path = this.packOutput.method_45972(class_7784.class_7490.field_39367).resolve(res.method_12836() + "/" + NPCDataManager.DIRECTORY + "/" + res.method_12832() + ".json");
        this.verifyData(val);
        JsonElement obj = (JsonElement)NPCData.CODEC.encodeStart(ops, (Object)val).getOrThrow();
        futures.add((Object)class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path));
    }

    public record QuestResponseBuilder(List<ConversationSet.Builder> start, List<ConversationSet.Builder> active, ConversationSet.Builder end) {
        public QuestResponseBuilder(ConversationSet.Builder start, ConversationSet.Builder active, ConversationSet.Builder end) {
            this(List.of(start), List.of(active), end);
        }
    }
}

