/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.SpellProperties;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public abstract class Spell {
    public static boolean tryUseWithCost(class_1309 entity, class_1799 stack, Spell spell) {
        return Spell.tryUseWithCost(entity, stack, spell, 1.0f);
    }

    public static boolean tryUseWithCost(class_1309 entity, class_1799 stack, Spell spell, float costMultiplier) {
        return Spell.tryUseWithCost(entity, stack, spell, costMultiplier, stack.method_7909() instanceof ItemStaffBase);
    }

    public static boolean tryUseWithCost(class_1309 entity, class_1799 stack, Spell spell, float costMultiplier, boolean hurt) {
        if (!(entity instanceof class_3222)) {
            return true;
        }
        class_3222 player = (class_3222)entity;
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
        if (!LevelCalc.useRP(data, (float)spell.properties().rpCost() * costMultiplier, hurt, spell.properties().percentageCost(), true, spell.costReductionSkills())) {
            if (!hurt) {
                EntityUtils.playSoundForPlayer(player, (class_3414)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
            }
            return false;
        }
        return true;
    }

    public static void playSound(class_1309 entity, class_3414 sound, float volume, float pitch) {
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), sound, entity.method_5634(), volume, pitch);
    }

    public void levelSkill(class_3222 player) {
        Map<Skills, Float> skillXp = this.properties().skillXP();
        if (!skillXp.isEmpty()) {
            PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
            skillXp.forEach((skill, xp) -> LevelCalc.levelSkill(data, Skills.DARK, xp.floatValue()));
        }
    }

    public Skills[] costReductionSkills() {
        return (Skills[])DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor(this).skills().toArray(Skills[]::new);
    }

    public SpellProperties properties() {
        return DataPackHandler.INSTANCE.spellPropertiesManager().getPropertiesFor(this);
    }

    public boolean use(class_1309 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return this.use(serverLevel, entity, class_1799.field_8037);
        }
        return false;
    }

    public boolean use(class_1309 entity, boolean ignoreSeal) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return this.use(serverLevel, entity, class_1799.field_8037, ignoreSeal);
        }
        return false;
    }

    public boolean use(class_3218 level, class_1309 entity, class_1799 stack) {
        return this.use(level, entity, stack, false);
    }

    public boolean use(class_3218 level, class_1309 entity, class_1799 stack, boolean ignoreSeal) {
        if (!ignoreSeal && EntityUtils.sealed(entity)) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                EntityUtils.playSoundForPlayer(player, (class_3414)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
            }
            return false;
        }
        return this.use(level, entity, stack, 1.0f, 1, CombatUtils.getSpellLevelFromStack(stack));
    }

    public abstract boolean use(class_3218 var1, class_1309 var2, class_1799 var3, float var4, int var5, int var6);

    public AttackAction useAction() {
        return (AttackAction)RuneCraftoryAttackActions.STAFF_USE.get();
    }

    public boolean canUse(class_3218 serverLevel, class_1309 entity, class_1799 stack) {
        return entity.method_5854() == null || this.usableOnMounts();
    }

    public boolean delayedUse() {
        return true;
    }

    public boolean usableOnMounts() {
        return this.useAction().usableOnMounts(0);
    }

    public String toString() {
        return RuneCraftorySpells.SPELLS.registry().method_10221((Object)this).toString();
    }
}

