/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class BossBarTracker {
    private static final Map<class_2960, ClientBossBarType> BOSS_BARS = new HashMap<class_2960, ClientBossBarType>();
    private static final Map<UUID, BossBarData> ACTIVE_BOSS_BARS = new HashMap<UUID, BossBarData>();
    private static final Map<UUID, BossSoundInstance> ACTIVE_BOSS_BGM = new HashMap<UUID, BossSoundInstance>();
    private static class_1113 activeMusic;
    private static int lastPlay;
    private static int tick;

    public static void registerCustomBossbarType(class_2960 id, ClientBossBarType type) {
        BOSS_BARS.put(id, type);
    }

    public static void register() {
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.CHIMERA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.RAFFLESIA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.GRIMOIRE.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.DEAD_TREE.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.RACCOON.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.SKELEFANG.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.AMBROSIA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.THUNDERBOLT.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.MARIONETTA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.HANDONETTA.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.SANO_AND_UNO.getID());
        BossBarTracker.registerBossBarFor(RuneCraftoryEntities.SARCOPHAGUS.getID());
    }

    private static void registerBossBarFor(class_2960 id) {
        BossBarTracker.registerCustomBossbarType(id, new ClientBossBarType(new BossbarTexture(RuneCraftory.modRes(String.format("bossbar/%s_bossbar", id.method_12832())), 198, 15, 0, 0), new BossbarTexture(RuneCraftory.modRes(String.format("bossbar/%s_bossbar_progress", id.method_12832())), 198, 15, 0, 0), new BossbarTexture(RuneCraftory.modRes(String.format("bossbar/%s_bossbar_overlay", id.method_12832())), 198, 15, 0, 0)));
    }

    public static void tickSounds() {
        if (class_310.method_1551().field_1687 == null) {
            ACTIVE_BOSS_BGM.clear();
        }
        ++tick;
        ACTIVE_BOSS_BGM.values().removeIf(inst -> {
            if (inst.method_4793()) {
                BossBarTracker.stopMusic(inst);
                return true;
            }
            return false;
        });
    }

    public static void addActiveBossbar(UUID id, UUID musicID, class_2960 type, class_3414 music) {
        BossBarData old = ACTIVE_BOSS_BARS.get(id);
        if (old != null) {
            BossSoundInstance sound;
            if (!(old.music == null || (sound = ACTIVE_BOSS_BGM.get(old.music)) == null || music != null && sound.method_4775().equals((Object)music.method_14833()))) {
                sound.removeBossBar(id, true);
                BossBarTracker.createSound(musicID, music).ifPresent(bgm -> {
                    old.music = musicID;
                    ACTIVE_BOSS_BGM.put(musicID, (BossSoundInstance)((Object)bgm));
                    BossBarTracker.playMusic(bgm);
                });
            }
            return;
        }
        BossSoundInstance inst = ACTIVE_BOSS_BGM.get(musicID);
        if (inst != null) {
            inst.linkBossBar(id, false);
        } else {
            BossBarTracker.createSound(musicID, music).ifPresent(instance -> {
                instance.linkBossBar(id, true);
                BossBarTracker.playMusic(instance);
                ACTIVE_BOSS_BGM.put(musicID, (BossSoundInstance)((Object)instance));
            });
        }
        BossBarData data = new BossBarData(type, musicID);
        ACTIVE_BOSS_BARS.put(id, data);
    }

    public static void updateMusic(UUID id, UUID musicID, class_3414 sound) {
        BossSoundInstance bgm = ACTIVE_BOSS_BGM.get(musicID);
        if (bgm != null) {
            if (sound == null) {
                bgm.removeBossBar(id, true);
            } else {
                boolean empty = bgm.instances.isEmpty();
                bgm.linkBossBar(id, false);
                if (empty) {
                    BossBarTracker.playMusic(bgm);
                }
            }
        } else if (sound != null) {
            BossBarTracker.createSound(musicID, sound).ifPresent(instance -> {
                instance.linkBossBar(id, true);
                BossBarTracker.playMusic(instance);
                ACTIVE_BOSS_BGM.put(musicID, (BossSoundInstance)((Object)instance));
            });
        }
    }

    public static void removeActiveBossbar(UUID id, boolean immediate) {
        BossBarData data = ACTIVE_BOSS_BARS.remove(id);
        if (data != null && data.music != null) {
            BossSoundInstance sound = ACTIVE_BOSS_BGM.get(data.music);
            if (sound == null) {
                return;
            }
            sound.removeBossBar(id, immediate);
        }
    }

    public static Optional<BossSoundInstance> createSound(UUID id, class_3414 sound) {
        if (sound == null || !ClientConfig.bossMusic) {
            return Optional.empty();
        }
        return Optional.of(new BossSoundInstance(id, sound, class_3419.field_15247, 1.0f, 1.0f, ClientConfig.bossMusicFadeDelay));
    }

    private static void playMusic(BossSoundInstance sound) {
        if (lastPlay == tick) {
            return;
        }
        lastPlay = tick;
        if (activeMusic != null) {
            class_310.method_1551().method_1483().method_4870(activeMusic);
        }
        class_310.method_1551().method_1538().method_4859();
        class_310.method_1551().method_1483().method_4873((class_1113)sound);
        activeMusic = sound;
    }

    private static void stopMusic(BossSoundInstance sound) {
        class_310.method_1551().method_1483().method_4870((class_1113)sound);
        if (activeMusic == sound) {
            ACTIVE_BOSS_BGM.values().stream().filter(bgm -> bgm != sound && !bgm.instances.isEmpty()).findFirst().ifPresent(bgm -> {
                class_310.method_1551().method_1483().method_4873((class_1113)bgm);
                activeMusic = bgm;
            });
        }
    }

    public static boolean hasActiveMusic() {
        return activeMusic != null;
    }

    public static int tryRenderCustomBossbar(class_332 graphics, int x, int y, class_1259 bossEvent, boolean withName) {
        ClientBossBarType type;
        if (!ClientConfig.customBossbars) {
            return -1;
        }
        BossBarData data = ACTIVE_BOSS_BARS.get(bossEvent.method_5407());
        if (data != null && (type = BOSS_BARS.get(data.type)) != null) {
            return type.renderFrom(graphics, x, y, bossEvent, withName);
        }
        return -1;
    }

    public record ClientBossBarType(BossbarTexture background, BossbarTexture progress, BossbarTexture overlay) {
        private static final int BAR_WIDTH = 182;

        public int renderFrom(class_332 graphics, int x, int y, class_1259 bossEvent, boolean withName) {
            class_310 mc = class_310.method_1551();
            int diff = (this.background().width() - 182) / 2;
            graphics.method_52706(this.background().texture(), x -= diff, y, this.background().width(), this.background().height());
            int overlayWidth = (int)(bossEvent.method_5412() * 182.0f);
            GuiUtils.drawBorderedBar(graphics, this.progress().texture(), x, y, this.progress().width(), this.progress().height(), overlayWidth, 8, 5);
            graphics.method_52706(this.overlay().texture(), x, y, this.overlay().width(), this.overlay().height());
            if (withName) {
                int screenX = mc.method_22683().method_4486();
                class_2561 component = bossEvent.method_5414();
                int len = mc.field_1772.method_27525((class_5348)component);
                int txtX = screenX / 2 - len / 2;
                class_327 class_3272 = mc.field_1772;
                Objects.requireNonNull(mc.field_1772);
                graphics.method_27535(class_3272, component, txtX, y - 9, 0xFFFFFF);
            }
            Objects.requireNonNull(mc.field_1772);
            return 9 + this.background().height() + 1;
        }
    }

    public record BossbarTexture(class_2960 texture, int width, int height, int offsetX, int offsetY) {
    }

    public static class BossBarData {
        public final class_2960 type;
        public UUID music;

        public BossBarData(class_2960 type, UUID music) {
            this.type = type;
            this.music = music;
        }
    }

    public static class BossSoundInstance
    extends class_1101 {
        public final UUID id;
        private final int fadeTime;
        private final float defaultVol;
        private final float volDecrease;
        private int tick = 1;
        private boolean fadeAway;
        private boolean adjustingVolume;
        private final Set<UUID> instances = new HashSet<UUID>();

        public BossSoundInstance(UUID id, class_3414 soundEvent, class_3419 soundSource, float volume, float pitch, int fadeTime) {
            super(soundEvent, soundSource, class_1113.method_43221());
            this.id = id;
            this.field_5442 = volume;
            this.field_5441 = pitch;
            this.fadeTime = fadeTime;
            this.defaultVol = class_3532.method_15363((float)(volume * BossSoundInstance.getVolume(soundSource)), (float)0.0f, (float)1.0f);
            this.volDecrease = 1.0f / (float)this.fadeTime;
            this.field_5446 = true;
            this.field_18936 = true;
        }

        private static float getVolume(@Nullable class_3419 category) {
            if (category == null || category == class_3419.field_15250) {
                return 1.0f;
            }
            return class_310.method_1551().field_1690.method_1630(category);
        }

        public void linkBossBar(UUID barId, boolean init) {
            this.instances.add(barId);
            if (!init) {
                this.setFadeState(true);
            }
        }

        public void removeBossBar(UUID barId, boolean immediate) {
            this.instances.remove(barId);
            if (this.instances.isEmpty()) {
                if (immediate) {
                    this.method_24876();
                } else {
                    this.setFadeState(false);
                }
            }
        }

        private void setFadeState(boolean fadeAway) {
            this.fadeAway = fadeAway;
            this.tick = class_3532.method_15340((int)this.tick, (int)0, (int)this.fadeTime);
            this.adjustingVolume = true;
        }

        public boolean done() {
            return this.tick > this.fadeTime || this.tick < 0;
        }

        public void method_16896() {
            if (!this.adjustingVolume) {
                if (this.instances.isEmpty()) {
                    this.method_24876();
                }
                return;
            }
            boolean done = this.done();
            this.tick = this.fadeAway ? --this.tick : ++this.tick;
            this.field_5442 = this.defaultVol * class_3532.method_15363((float)(1.0f - this.volDecrease * (float)this.tick), (float)0.0f, (float)1.0f);
            if (done) {
                this.adjustingVolume = false;
            }
        }
    }
}

