/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandDataContainer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class ClientFarmlandHandler {
    public static final ClientFarmlandHandler INSTANCE = new ClientFarmlandHandler();
    private final Long2ObjectMap<FarmlandDataContainer> farmland = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<Set<FarmlandDataContainer>> farmlandChunks = new Long2ObjectOpenHashMap();

    private ClientFarmlandHandler() {
    }

    @Nullable
    public FarmlandDataContainer getData(class_2338 pos) {
        return (FarmlandDataContainer)this.farmland.get(pos.method_10063());
    }

    public void updateChunk(long packedChunk, List<FarmlandDataContainer> list) {
        Set chunkMap = (Set)this.farmlandChunks.computeIfAbsent(packedChunk, key -> new HashSet());
        list.forEach(d -> {
            this.farmland.put(d.pos().method_10063(), d);
            chunkMap.add(d);
        });
    }

    public void onChunkUnLoad(class_1923 pos) {
        Set farms = (Set)this.farmlandChunks.get(pos.method_8324());
        if (farms != null) {
            farms.forEach(d -> this.farmland.remove(d.pos().method_10063()));
            this.farmlandChunks.remove(pos.method_8324());
        }
    }

    public void onFarmBlockRemove(class_2338 pos) {
        long packedChunk;
        Set farms;
        FarmlandDataContainer cont = (FarmlandDataContainer)this.farmland.remove(pos.method_10063());
        if (cont != null && (farms = (Set)this.farmlandChunks.get(packedChunk = new class_1923(pos).method_8324())) != null) {
            farms.remove(cont);
            if (farms.isEmpty()) {
                this.farmlandChunks.remove(packedChunk);
            }
        }
    }

    public void onDisconnect() {
        this.farmland.clear();
        this.farmlandChunks.clear();
    }
}

