/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.TriggerKeyBind;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.client.gui.FarmlandInfo;
import io.github.flemmli97.runecraftory.client.gui.MonsterCompanionGui;
import io.github.flemmli97.runecraftory.client.gui.NPCCompanionGui;
import io.github.flemmli97.runecraftory.client.gui.NPCDialogueGui;
import io.github.flemmli97.runecraftory.client.gui.NPCGui;
import io.github.flemmli97.runecraftory.client.gui.NPCShopGui;
import io.github.flemmli97.runecraftory.client.gui.OverlayGui;
import io.github.flemmli97.runecraftory.client.gui.QuestGui;
import io.github.flemmli97.runecraftory.client.gui.SpawnEggScreen;
import io.github.flemmli97.runecraftory.client.gui.SpellInvOverlayGui;
import io.github.flemmli97.runecraftory.client.gui.widgets.QuestToast;
import io.github.flemmli97.runecraftory.client.model.AnimatedPlayerModel;
import io.github.flemmli97.runecraftory.client.model.armor.ArmorModels;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.network.S2CTriggers;
import io.github.flemmli97.runecraftory.common.quests.ClientSideQuestDisplay;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_366;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5498;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_8786;

public class ClientHandlers {
    public static OverlayGui OVERLAY;
    public static SpellInvOverlayGui SPELL_DISPLAY;
    public static FarmlandInfo FARM_DISPLAY;
    public static TriggerKeyBind SPELL_1;
    public static TriggerKeyBind SPELL_2;
    public static TriggerKeyBind SPELL_3;
    public static TriggerKeyBind SPELL_4;
    private static final AnimatedPlayerModel<?> ANIMATED_PLAYER_MODEL;
    private static class_5498 pastType;

    public static class_1657 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static float getPartialTicks() {
        return class_310.method_1551().method_60646().method_60637(false);
    }

    public static void updateClientCalendar(Calendar.Date date, Weather weather) {
        Season prev = ClientCalendarHolder.CLIENT_CALENDAR.currentSeason();
        ClientCalendarHolder.CLIENT_CALENDAR.updateDirect(date, weather);
        if (ClientCalendarHolder.CLIENT_CALENDAR.currentSeason() != prev) {
            class_310 mc = class_310.method_1551();
            class_638 level = mc.field_1687;
            if (mc.field_1687 != null) {
                int renderDist = mc.field_1690.method_38521();
                for (int x = -renderDist; x <= renderDist; ++x) {
                    for (int y = level.method_32891(); y < level.method_32890(); ++y) {
                        for (int z = -renderDist; z <= renderDist; ++z) {
                            mc.field_1769.method_8571(x, y, z);
                        }
                    }
                }
            }
        }
    }

    public static boolean disableMouseMove() {
        class_310 mc = class_310.method_1551();
        return !(mc.field_1724 == null || !EntityUtils.isDisabled((class_1309)mc.field_1724) && Platform.INSTANCE.getPlayerData((class_1657)mc.field_1724).getWeaponHandler().get(DataKey.FIXED_LOOK) == false || mc.field_1755 != null && !(mc.field_1755 instanceof class_465));
    }

    public static boolean disableMouseClick() {
        class_310 mc = class_310.method_1551();
        return mc.field_1724 != null && EntityUtils.isDisabled((class_1309)mc.field_1724) && (mc.field_1755 == null || mc.field_1755 instanceof class_465);
    }

    public static boolean disableScrollMouse() {
        class_310 mc = class_310.method_1551();
        return !(mc.field_1724 == null || !EntityUtils.isDisabled((class_1309)mc.field_1724) && !Platform.INSTANCE.getPlayerData((class_1657)mc.field_1724).getWeaponHandler().isItemSwapBlocked() || mc.field_1755 != null && !(mc.field_1755 instanceof class_465));
    }

    public static boolean disableKeys(int key, int scanCode) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1755 instanceof class_408 || !EntityUtils.isDisabled((class_1309)mc.field_1724)) {
            return false;
        }
        return key != 256 && !mc.field_1690.field_1894.method_1417(key, scanCode) && !mc.field_1690.field_1881.method_1417(key, scanCode) && !mc.field_1690.field_1913.method_1417(key, scanCode) && !mc.field_1690.field_1849.method_1417(key, scanCode) && !mc.field_1690.field_1832.method_1417(key, scanCode) && !mc.field_1690.field_1867.method_1417(key, scanCode) && !mc.field_1690.field_1822.method_1417(key, scanCode) && !mc.field_1690.field_1890.method_1417(key, scanCode) && !mc.field_1690.field_1845.method_1417(key, scanCode);
    }

    public static void recipeToast(Collection<class_2960> recipes) {
        recipes.forEach(res -> class_310.method_1551().field_1687.method_8433().method_8130(res).ifPresent(rec -> class_366.method_1985((class_374)class_310.method_1551().method_1566(), (class_8786)rec)));
    }

    public static void simpleToast(class_2561 title, class_2561 subtitle) {
        class_310.method_1551().method_1566().method_1999((class_368)new QuestToast(title, subtitle));
    }

    public static void setToThirdPerson(boolean reset) {
        if (reset == (pastType == null)) {
            return;
        }
        if (reset) {
            class_310.method_1551().field_1690.method_31043(pastType);
            pastType = null;
        } else {
            pastType = class_310.method_1551().field_1690.method_31044();
            class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
        }
    }

    public static void trySetPerspective(class_1309 entity, boolean flag) {
        if (entity == class_310.method_1551().method_1560()) {
            ClientHandlers.setToThirdPerson(!flag);
        }
    }

    public static void openCompanionGui(int id, boolean fullParty, boolean hasHome) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(id);
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (!class_310.method_1551().field_1724.method_5667().equals(monster.method_6139())) {
                return;
            }
            class_310.method_1551().method_1507((class_437)new MonsterCompanionGui(monster, fullParty, hasHome));
        }
    }

    public static void openNPCChat(int id, ShopState isShopOpen, SyncedFamilyData family, int followState, Map<String, List<class_2561>> actions, class_2960 quest) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(id);
        if (entity instanceof NPCEntity) {
            NPCEntity npc = (NPCEntity)entity;
            if (followState == 1) {
                class_310.method_1551().method_1507((class_437)new NPCCompanionGui(npc, isShopOpen == ShopState.OPEN, quest));
            } else {
                class_310.method_1551().method_1507(new NPCGui<NPCEntity>(npc, isShopOpen, followState == 0, family, actions, quest));
            }
        }
    }

    public static void handleShopRespone(class_2561 txt) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof NPCShopGui) {
            NPCShopGui shop = (NPCShopGui)class_4372;
            if (txt != null) {
                shop.drawBubble(txt);
            } else {
                shop.updateButtons();
            }
        }
    }

    public static AnimatedPlayerModel<?> getAnimatedPlayerModel() {
        return ANIMATED_PLAYER_MODEL;
    }

    public static void initNonRendererModels(class_5617.class_5618 ctx) {
        ArmorModels.initArmorModels(ctx);
    }

    public static void updateCurrentRecipeIndex(int index) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof CraftingGui) {
            CraftingGui gui = (CraftingGui)class_4372;
            gui.setSelectedRecipe(index);
        }
    }

    public static void handleTriggers(S2CTriggers.TriggerType type, class_2338 pos) {
        switch (type) {
            case FERTILIZER: {
                class_638 level = class_310.method_1551().field_1687;
                double x = (double)pos.method_10263() + 0.5;
                double y = (double)pos.method_10264() + 1.25;
                double z = (double)pos.method_10260() + 0.5;
                level.method_8406((class_2394)class_2398.field_11211, x, y, z, 0.0, 0.0, 0.0);
                class_5819 random = level.method_8409();
                for (int i = 0; i < 15; ++i) {
                    double nZ;
                    double nY;
                    double nX = x - 0.5 + random.method_43058();
                    if (level.method_8320(class_2338.method_49637((double)nX, (double)(nY = y - 0.35 + random.method_43058() * 0.5), (double)(nZ = z - 0.5 + random.method_43058())).method_10074()).method_26215()) continue;
                    level.method_8406((class_2394)class_2398.field_11211, nX, nY, nZ, random.method_43059() * 0.02, random.method_43059() * 0.02, random.method_43059() * 0.02);
                }
                break;
            }
        }
    }

    public static void updateNPCDialogue(NPCEntity npc, ConversationContext convCtx, String conversationID, class_2561 component, Map<String, class_2561> data, List<class_2561> actions) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof NPCDialogueGui) {
            NPCDialogueGui gui = (NPCDialogueGui)class_4372;
            gui.updateConversation(class_310.method_1551(), convCtx, conversationID, component, data, actions);
        } else {
            NPCDialogueGui<NPCEntity> gui = new NPCDialogueGui<NPCEntity>(npc);
            gui.updateConversation(class_310.method_1551(), convCtx, conversationID, component, data, actions);
            class_310.method_1551().method_1507(gui);
        }
    }

    public static void openQuestGui(boolean hasActive, List<ClientSideQuestDisplay> quests) {
        class_310.method_1551().method_1507((class_437)new QuestGui(hasActive, quests));
    }

    public static void openSpawneggGui(class_1268 hand) {
        class_310.method_1551().method_1507((class_437)new SpawnEggScreen(hand));
    }

    public static void translateRider(class_4587 poseStack, class_1309 entity, class_1297 rider) {
        class_243 attach = rider.method_55668((class_1297)entity);
        float scale = entity.method_55693();
        poseStack.method_22905(1.0f / scale, 1.0f / scale, 1.0f / scale);
        poseStack.method_22904(attach.method_10216(), attach.method_10214(), attach.method_10215());
    }

    static {
        ANIMATED_PLAYER_MODEL = new AnimatedPlayerModel();
        pastType = null;
    }
}

