/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class NPCDialogueLanguageManager {
    public static final NPCDialogueLanguageManager INSTANCE = new NPCDialogueLanguageManager();
    public static final String DIRECTORY = "lang/npc_conversations";
    private Map<String, String> translations = new HashMap<String, String>();

    private NPCDialogueLanguageManager() {
    }

    private static Map<String, String> loadFrom(class_3300 resourceManager, List<String> fileNames) {
        HashMap translations = new HashMap();
        HashMap result = new HashMap();
        for (Map.Entry entry : resourceManager.method_14488(DIRECTORY, p -> p.method_12832().endsWith(".json")).entrySet()) {
            String[] dirs = ((class_2960)entry.getKey()).method_12832().split("/");
            String lang = dirs[dirs.length - 1].replace(".json", "");
            if (!fileNames.contains(lang)) continue;
            HashMap map = new HashMap();
            try (InputStream inputStream = ((class_3298)entry.getValue()).method_14482();){
                class_2477.method_29425((InputStream)inputStream, map::put);
            }
            catch (IOException iOException) {
                RuneCraftory.LOGGER.warn("Failed to load dialog translations for language {}", (Object)lang, (Object)iOException);
            }
            translations.computeIfAbsent(lang, k -> new HashMap()).putAll(map);
        }
        for (String code : fileNames) {
            result.putAll(translations.getOrDefault(code, Map.of()));
        }
        return ImmutableMap.copyOf(result);
    }

    public void onResourceManagerReload(class_3300 resourceManager, List<String> infos) {
        this.translations = NPCDialogueLanguageManager.loadFrom(resourceManager, infos);
    }

    public String getOrDefault(String key) {
        return this.translations.getOrDefault(key, key);
    }
}

