/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.client.ClientCalendarHolder;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.ClientConfig;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class OverlayGui {
    private static final class_2960 HEALTH_BAR_BACKGROUND = RuneCraftory.modRes("hud/overlay/health_bar_background");
    private static final class_2960 HEALTH_BAR = RuneCraftory.modRes("hud/overlay/health_bar");
    private static final class_2960 RUNEPOINTS_BAR_BACKGROUND = RuneCraftory.modRes("hud/overlay/runepoints_bar_background");
    private static final class_2960 RUNEPOINTS_BAR = RuneCraftory.modRes("hud/overlay/runepoints_bar");
    private static final Map<Season, class_2960> DATE = Arrays.stream(Season.values()).collect(Collectors.toUnmodifiableMap(e -> e, e -> RuneCraftory.modRes("hud/overlay/date_" + e.name().toLowerCase())));
    private final class_310 mc;

    public OverlayGui(class_310 mc) {
        this.mc = mc;
    }

    public void renderBar(class_332 graphics) {
        int yPos;
        int xPos;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = this.mc.method_22683().method_4486();
        int guiHeight = this.mc.method_22683().method_4502();
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)this.mc.field_1724);
        if (ClientConfig.renderHealthRpBar != ClientConfig.HealthRPRenderType.NONE) {
            int barWidth = 76;
            int yHeight = ClientConfig.renderHealthRpBar == ClientConfig.HealthRPRenderType.BOTH ? 30 : 9;
            xPos = ClientConfig.healthBarWidgetPosition.positionX(guiWidth, barWidth, ClientConfig.healthBarWidgetX) + 1;
            yPos = ClientConfig.healthBarWidgetPosition.positionY(guiHeight, yHeight, ClientConfig.healthBarWidgetY) + 1;
            if (data != null && !this.mc.field_1724.method_7337()) {
                if (ClientConfig.renderHealthRpBar == ClientConfig.HealthRPRenderType.BOTH) {
                    graphics.method_52706(HEALTH_BAR_BACKGROUND, xPos, yPos, barWidth, 9);
                    int healthWidth = Math.min(barWidth, (int)(this.mc.field_1724.method_6032() / this.mc.field_1724.method_6063() * (float)barWidth));
                    GuiUtils.drawBorderedBar(graphics, HEALTH_BAR, xPos, yPos, barWidth, 9, healthWidth, 1, 1);
                    yPos += 12;
                }
                graphics.method_52706(RUNEPOINTS_BAR_BACKGROUND, xPos, yPos, barWidth, 9);
                int runePointsWidth = Math.min(barWidth, (int)((float)data.getRunePoints() / (float)data.getMaxRunePoints() * (float)barWidth));
                GuiUtils.drawBorderedBar(graphics, RUNEPOINTS_BAR, xPos, yPos, barWidth, 9, runePointsWidth, 1, 1);
            }
        }
        if (ClientConfig.renderCalendar) {
            Calendar calendar = ClientCalendarHolder.CLIENT_CALENDAR;
            Season season = calendar.currentSeason();
            xPos = ClientConfig.seasonDisplayPosition.positionX(guiWidth, 64, ClientConfig.seasonDisplayX);
            yPos = ClientConfig.seasonDisplayPosition.positionY(guiHeight, 51, ClientConfig.seasonDisplayY);
            graphics.method_52706(DATE.get((Object)season), xPos, yPos, 64, 32);
            GuiGraphicsExtension.drawCenteredString(graphics, this.mc.field_1772, (class_2561)class_2561.method_43469((String)"runecraftory.gui.date.format", (Object[])new Object[]{class_2561.method_43471((String)calendar.date().day().translation()), calendar.date().date()}).method_27695(new class_124[]{class_124.field_1063, class_124.field_1067}), (float)(xPos + 32), (float)(yPos + 15), 0, false);
            class_5250 money = class_2561.method_43470((String)("" + data.getMoney())).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
            xPos = ClientConfig.seasonDisplayPosition.positionX(guiWidth, this.mc.field_1772.method_27525((class_5348)money), ClientConfig.seasonDisplayX + 4);
            graphics.method_52706(SpriteResources.MONEY_ICON, xPos, yPos += 36, 15, 15);
            graphics.method_27535(this.mc.field_1772, (class_2561)money, xPos + 20, yPos + 4, 0);
        }
    }
}

