/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.common.components.NPCSpawnData;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.items.creative.NPCSpawnEgg;
import io.github.flemmli97.runecraftory.common.network.C2SSpawnEgg;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.tenshilib.client.gui.widget.SuggestionEditBox;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9331;

public class SpawnEggScreen
extends class_437 {
    private final class_1657 player;
    protected List<class_1309> entities;
    private final class_1268 hand;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 200;
    private final List<class_342> editBoxes = new ArrayList<class_342>();
    private class_342 levelEditor;
    private class_342 npcIDEditor;
    private int level;
    private class_2960 npcProfession;
    private class_2960 npcID;

    public SpawnEggScreen(class_1268 hand) {
        super((class_2561)class_2561.method_43470((String)""));
        this.hand = hand;
        this.player = class_310.method_1551().field_1724;
    }

    protected void method_25426() {
        super.method_25426();
        class_1799 stack = this.player.method_5998(this.hand);
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SpawnEgg)) {
            class_310.method_1551().method_1507(null);
            return;
        }
        SpawnEgg egg = (SpawnEgg)class_17922;
        class_1299 type = egg.method_8015(stack);
        class_1297 e = type.method_5883((class_1937)class_310.method_1551().field_1687);
        if (e instanceof EnsembleMonsters) {
            EnsembleMonsters ensemble = (EnsembleMonsters)e;
            ArrayList<class_1309> list = new ArrayList<class_1309>();
            for (Supplier<class_1299<?>> t : ensemble.entities()) {
                class_1297 sub = t.get().method_5883((class_1937)class_310.method_1551().field_1687);
                if (!(sub instanceof class_1309)) continue;
                class_1309 livingSub = (class_1309)sub;
                livingSub.method_18382();
                list.add(livingSub);
            }
            this.entities = List.copyOf(list);
        } else if (e instanceof class_1309) {
            class_1309 living = (class_1309)e;
            living.method_18382();
            this.entities = List.of(living);
        } else {
            class_310.method_1551().method_1507(null);
            return;
        }
        this.leftPos = this.field_22789 / 2 - this.sizeX / 2;
        this.topPos = this.field_22790 / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void method_25393() {
        super.method_25393();
        this.entities.forEach(entity -> ++entity.field_6012);
    }

    protected void method_57734(float partialTick) {
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int padding;
        super.method_25420(graphics, mouseX, mouseY, partialTick);
        graphics.method_25296(this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int yOff = padding = 16;
        graphics.method_27535(this.field_22787.field_1772, (class_2561)class_2561.method_43471((String)"runecraftory.gui.level"), this.leftPos + padding, this.topPos + yOff, 0xFFFFFF);
        if (this.npcIDEditor != null) {
            graphics.method_27535(this.field_22787.field_1772, (class_2561)class_2561.method_43471((String)"runecraftory.gui.npc.profession"), this.leftPos + padding, this.topPos + (yOff += 72), 0xFFFFFF);
            graphics.method_27535(this.field_22787.field_1772, (class_2561)class_2561.method_43471((String)"runecraftory.gui.npc.id"), this.leftPos + padding, this.topPos + (yOff += 36), 0xFFFFFF);
        }
        int max = Math.min(4, this.entities.size());
        for (int i = 0; i < max; ++i) {
            class_1309 entity = this.entities.get(i);
            float scale = 1.0f;
            float size = 80.0f * scale;
            int posX = this.sizeX - padding - 12;
            int posY = padding + 12;
            if (max > 1) {
                int idx = i;
                if (max % 2 == 1) {
                    --idx;
                }
                int offset = (int)(Math.ceil(((double)idx + 1.0) / 2.0) * (double)(idx % 2 == 0 ? -1 : 1));
                int abs = Math.max(0, Math.abs(offset) - 1);
                scale = Math.max(0.2f, 1.0f - (float)abs * 0.3f);
                posX += offset * 30;
                posY -= abs * 15;
            }
            posX = (int)((float)posX - size);
            RenderUtils.renderScaledEntityGui((class_332)graphics, (float)(this.leftPos + posX), (float)(this.topPos + posY), (float)size, (float)size, (float)(30.0f * scale), (float)0.0f, (float)mouseX, (float)mouseY, (class_1309)entity);
        }
    }

    protected void buttons() {
        this.editBoxes.clear();
        int padding = 16;
        int yOff = padding + 12;
        this.levelEditor = new class_342(this, this.field_22787.field_1772, this.leftPos + padding, this.topPos + yOff, 48, 16, (class_2561)class_2561.method_43470((String)"")){

            public boolean method_25400(char codePoint, int modifiers) {
                if (Character.isDigit(codePoint)) {
                    return super.method_25400(codePoint, modifiers);
                }
                return false;
            }
        };
        this.levelEditor.method_1863(s -> {
            try {
                this.level = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.editBoxes.add(this.levelEditor);
        class_1799 stack = this.player.method_5998(this.hand);
        this.level = (Integer)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.SPAWN_EGG_LEVEL.get(), (Object)1);
        this.levelEditor.method_1852("" + this.level);
        this.method_37063((class_364)this.levelEditor);
        if (stack.method_7909() instanceof NPCSpawnEgg) {
            SuggestionEditBox npcProfessionEditor = new SuggestionEditBox(this.field_22787.field_1772, this.leftPos + padding, this.topPos + (yOff += 72), 130, 16, (class_2561)class_2561.method_43470((String)""), 5, false, SuggestionEditBox.ofResourceLocation((Collection)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_10235()));
            NPCSpawnData itemData = (NPCSpawnData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.NPC_SPAWN_DATA.get(), (Object)NPCSpawnData.DEFAULT);
            this.npcProfession = itemData.profession().map(h -> ((class_5321)h.method_40230().orElseThrow()).method_29177()).orElse(null);
            if (this.npcProfession != null) {
                npcProfessionEditor.method_1852(this.npcProfession.toString());
            }
            npcProfessionEditor.method_1863(s -> {
                try {
                    this.npcProfession = s.isEmpty() ? null : class_2960.method_60654((String)s);
                }
                catch (class_151 class_1512) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)npcProfessionEditor);
            this.editBoxes.add((class_342)npcProfessionEditor);
            this.npcIDEditor = new class_342(this.field_22787.field_1772, this.leftPos + padding, this.topPos + (yOff += 36), this.sizeX - padding * 2, 16, (class_2561)class_2561.method_43470((String)""));
            this.npcID = itemData.npcDataId().orElse(null);
            if (this.npcID != null) {
                this.npcIDEditor.method_1852(this.npcID.toString());
            }
            this.npcIDEditor.method_1863(s -> {
                try {
                    this.npcID = s.isEmpty() ? null : class_2960.method_60654((String)s);
                }
                catch (class_151 class_1512) {
                    // empty catch block
                }
            });
            this.method_37063((class_364)this.npcIDEditor);
            this.editBoxes.add(this.npcIDEditor);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"runecraftory.gui.save"), b -> {
            LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SSpawnEgg(this.hand, this.level, this.npcProfession, this.npcID));
            this.field_22787.method_1507(null);
        }).method_46434(this.leftPos + this.sizeX / 2 - 50, this.topPos + this.sizeY - 32, 100, 20).method_46431());
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.editBoxes.stream().noneMatch(class_342::method_20315) && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean click = super.method_25402(mouseX, mouseY, button);
        if (!click) {
            this.method_25395(null);
        }
        return click;
    }
}

