/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.armor;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.armor.CustomHumanoidArmorModel;
import io.github.flemmli97.runecraftory.client.model.armor.SimpleItemArmorModel;
import io.github.flemmli97.runecraftory.common.items.equipment.ItemArmorBase;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import net.minecraft.class_918;

public class ArmorModels {
    private static final Map<class_1792, ArmorModelGetter> ARMOR_GETTER = ArmorModels.getArmorRenderer();
    private static final Map<class_1792, FirstPersonArmorRenderer> FIRST_PERSON_GETTER = ArmorModels.getFirstPersonHandRenderer();
    private static final SimpleItemArmorModel ITEM_MODEL = new SimpleItemArmorModel();
    private static final CustomHumanoidArmorModel<?> PIYO_SANDALS_MODEL = new CustomHumanoidArmorModel(RuneCraftory.modRes("armor/piyo_sandals"));
    private static final CustomHumanoidArmorModel<?> RINGS_MODEL = new CustomHumanoidArmorModel(RuneCraftory.modRes("armor/rings"));
    private static class_572<?> INNER;
    private static class_572<?> OUTER;

    private static Map<class_1792, ArmorModelGetter> getArmorRenderer() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((class_1792)RuneCraftoryItems.MAGIC_EARRINGS.get()), (entityLiving, itemStack, slot, origin) -> {
            origin.method_2805(false);
            origin.field_3398.field_3665 = true;
            origin.field_3394.field_3665 = true;
            return null;
        });
        ArmorModelGetter bracelet = (entityLiving, itemStack, slot, origin) -> {
            class_742 clientPlayer;
            origin.method_2805(false);
            boolean right = entityLiving.method_6068() == class_1306.field_6183;
            class_630 model = right ? origin.field_3401 : origin.field_27433;
            model.field_3665 = true;
            if (entityLiving instanceof class_742 && (clientPlayer = (class_742)entityLiving).method_52814().comp_1629() == class_8685.class_7920.field_41122) {
                model.field_3657 = (float)((double)model.field_3657 + (right ? 0.5 : -0.5));
            }
            return null;
        };
        for (RegistryEntrySupplier<class_1792, ?> registryEntrySupplier : ArmorModels.bracelets()) {
            builder.put((Object)((class_1792)registryEntrySupplier.get()), (Object)bracelet);
        }
        ArmorModelGetter normalItemModel = (entityLiving, itemStack, slot, origin) -> {
            ITEM_MODEL.setProperties(entityLiving, itemStack, origin.method_2838(), SimpleItemArmorModel.TRANSLATE_TO_HEAD);
            return ITEM_MODEL;
        };
        for (RegistryEntrySupplier<class_1792, ?> registryEntrySupplier : RuneCraftoryItems.ribbons()) {
            builder.put((Object)((class_1792)registryEntrySupplier.get()), (Object)normalItemModel);
        }
        builder.put((Object)((class_1792)RuneCraftoryItems.PIYO_SANDALS.get()), (entityLiving, itemStack, slot, origin) -> {
            PIYO_SANDALS_MODEL.copyFrom(origin);
            PIYO_SANDALS_MODEL.setAllVisible(false);
            ArmorModels.PIYO_SANDALS_MODEL.leftLeg.visible = true;
            ArmorModels.PIYO_SANDALS_MODEL.rightLeg.visible = true;
            return PIYO_SANDALS_MODEL;
        });
        for (RegistryEntrySupplier<class_1792, ?> registryEntrySupplier : RuneCraftoryItems.hatItems()) {
            builder.put((Object)((class_1792)registryEntrySupplier.get()), (Object)normalItemModel);
        }
        ArmorModelGetter armorModelGetter = (entityLiving, itemStack, slot, origin) -> {
            class_742 clientPlayer;
            RINGS_MODEL.copyFrom(origin);
            RINGS_MODEL.setAllVisible(false);
            boolean right = entityLiving.method_6068() == class_1306.field_6183;
            ModelPartsContainer.ModelPartExtended model = right ? ArmorModels.RINGS_MODEL.rightArm : ArmorModels.RINGS_MODEL.leftArm;
            model.visible = true;
            if (entityLiving instanceof class_742 && (clientPlayer = (class_742)entityLiving).method_52814().comp_1629() == class_8685.class_7920.field_41122) {
                model.x = (float)((double)model.x + (right ? 0.5 : -0.5));
            }
            return RINGS_MODEL;
        };
        for (RegistryEntrySupplier<class_1792, ?> sup : ArmorModels.rings()) {
            builder.put((Object)((class_1792)sup.get()), (Object)armorModelGetter);
        }
        return builder.build();
    }

    private static Map<class_1792, FirstPersonArmorRenderer> getFirstPersonHandRenderer() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        FirstPersonArmorRenderer bracelet = (player, stack, right, origin, poseStack, buffer, light) -> {
            origin.method_2818(OUTER);
            OUTER.method_2805(false);
            class_630 model = right ? ArmorModels.OUTER.field_3401 : ArmorModels.OUTER.field_27433;
            model.field_3665 = true;
            if (player.method_52814().comp_1629() == class_8685.class_7920.field_41122) {
                model.field_3657 = (float)((double)model.field_3657 + (right ? 0.5 : -0.5));
            }
            ArmorModels.renderModelPart(OUTER, player, buffer, stack, poseStack, light);
        };
        for (RegistryEntrySupplier<class_1792, ?> sup : ArmorModels.bracelets()) {
            builder.put((Object)((class_1792)sup.get()), (Object)bracelet);
        }
        FirstPersonArmorRenderer rings = (player, stack, right, origin, poseStack, buffer, light) -> {
            RINGS_MODEL.copyFrom((class_572<?>)origin);
            RINGS_MODEL.setAllVisible(false);
            ModelPartsContainer.ModelPartExtended model = right ? ArmorModels.RINGS_MODEL.rightArm : ArmorModels.RINGS_MODEL.leftArm;
            model.visible = true;
            if (player.method_52814().comp_1629() == class_8685.class_7920.field_41122) {
                model.x = (float)((double)model.x + (right ? 0.5 : -0.5));
            }
            ArmorModels.renderModelPart(RINGS_MODEL, player, buffer, stack, poseStack, light);
        };
        for (RegistryEntrySupplier<class_1792, ?> sup : ArmorModels.rings()) {
            builder.put((Object)((class_1792)sup.get()), (Object)rings);
        }
        return builder.build();
    }

    private static void renderModelPart(class_583<?> model, class_742 player, class_4597 buffer, class_1799 stack, class_4587 poseStack, int light) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ItemArmorBase) {
            ItemArmorBase armor = (ItemArmorBase)class_17922;
            for (class_1741.class_9196 layer : ((class_1741)armor.method_7686().comp_349()).comp_2302()) {
                class_4588 cons = class_918.method_27952((class_4597)buffer, (class_1921)class_1921.method_25448((class_2960)armor.getArmorTexture(stack, (class_1297)player, armor.method_7685(), layer, false)), (boolean)stack.method_7958());
                model.method_60879(poseStack, cons, light, class_4608.field_21444);
            }
        }
    }

    public static ArmorModelGetter fromItemStack(class_1799 stack) {
        return ARMOR_GETTER.get(stack.method_7909());
    }

    public static FirstPersonArmorRenderer getFirstPersonRenderer(class_1799 stack) {
        return FIRST_PERSON_GETTER.get(stack.method_7909());
    }

    public static class_572<?> getDefaultArmorModel(class_1304 slot) {
        return slot == class_1304.field_6172 ? INNER : OUTER;
    }

    public static void initArmorModels(class_5617.class_5618 ctx) {
        INNER = new class_572(ctx.method_32167(class_5602.field_27579));
        OUTER = new class_572(ctx.method_32167(class_5602.field_27580));
    }

    private static List<RegistryEntrySupplier<class_1792, ?>> bracelets() {
        return List.of(RuneCraftoryItems.CHEAP_BRACELET, RuneCraftoryItems.BRONZE_BRACELET, RuneCraftoryItems.SILVER_BRACELET, RuneCraftoryItems.GOLD_BRACELET, RuneCraftoryItems.PLATINUM_BRACELET);
    }

    private static List<RegistryEntrySupplier<class_1792, ?>> rings() {
        return List.of(RuneCraftoryItems.SILVER_RING, RuneCraftoryItems.GOLD_RING, RuneCraftoryItems.PLATINUM_RING, RuneCraftoryItems.ENGAGEMENT_RING, RuneCraftoryItems.SHIELD_RING, RuneCraftoryItems.CRITICAL_RING, RuneCraftoryItems.SILENT_RING, RuneCraftoryItems.PARALYSIS_RING, RuneCraftoryItems.POISON_RING, RuneCraftoryItems.MAGIC_RING, RuneCraftoryItems.THROWING_RING, RuneCraftoryItems.STAY_UP_RING, RuneCraftoryItems.AQUAMARINE_RING, RuneCraftoryItems.AMETHYST_RING, RuneCraftoryItems.EMERALD_RING, RuneCraftoryItems.SAPPHIRE_RING, RuneCraftoryItems.RUBY_RING, RuneCraftoryItems.CURSED_RING, RuneCraftoryItems.DIAMOND_RING, RuneCraftoryItems.FIRE_RING, RuneCraftoryItems.WIND_RING, RuneCraftoryItems.WATER_RING, RuneCraftoryItems.EARTH_RING, RuneCraftoryItems.HAPPY_RING);
    }

    public static interface ArmorModelGetter {
        public class_3879 getModel(class_1309 var1, class_1799 var2, class_1304 var3, class_572<?> var4);
    }

    public static interface FirstPersonArmorRenderer {
        public void render(class_742 var1, class_1799 var2, boolean var3, class_591<?> var4, class_4587 var5, class_4597 var6, int var7);
    }
}

