/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.render.npc.ModelFeatureRender;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderer;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import java.util.HashMap;
import java.util.Map;

public class NPCFeatureRenderers {
    private static final Map<NPCFeatureType<?>, NPCFeatureRenderer<?>> RENDERERS = new HashMap();

    public static void init() {
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.SLIM.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.SIZE.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get());
        NPCFeatureRenderers.empty((NPCFeatureType)RuneCraftoryNPCLooks.HAT.get());
        NPCFeatureRenderers.register((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get(), new ModelFeatureRender());
    }

    public static synchronized <F extends NPCFeature> void empty(NPCFeatureType<F> type) {
        RENDERERS.put(type, NPCFeatureRenderer.EMPTY);
    }

    public static synchronized <F extends NPCFeature> void register(NPCFeatureType<F> type, NPCFeatureRenderer<F> renderer) {
        RENDERERS.put(type, renderer);
    }

    public static <T extends NPCFeature> NPCFeatureRenderer<T> get(NPCFeature feature) {
        NPCFeatureRenderer<?> renderer = RENDERERS.get(feature.type());
        if (renderer == null) {
            throw new IllegalStateException("No npc feature renderer registered for " + String.valueOf(feature));
        }
        return renderer;
    }
}

