/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class DashSlashAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("attack_start") && !handler.getAnimation().isPast("attack_end"), 0).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.DASH_SLASH.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimationState anim) {
        if (handler.getComboCount() == 2) {
            handler.store(DataKey.MOVE_DIRECTION, null);
            entity.method_18799(entity.method_18798().method_18805(0.95, 1.0, 0.95));
            if (anim.isAt("attack")) {
                if (!entity.method_37908().field_9236) {
                    OrientedBoundingBox obb = new OrientedBoundingBox(new class_238((double)(-entity.method_17681()), 0.0, 0.0, (double)entity.method_17681(), 1.0, (double)(entity.method_17681() + 1.0f)).method_1014(0.3), entity.method_36454(), 0.0f, entity.method_19538());
                    CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(obb)).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.DASH_SLASH)).doOnSuccess(e -> CombatUtils.knockBackEntity(entity, e, 1.0f)).executeAttack();
                }
                entity.method_5783(class_3417.field_14840, 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
            }
        } else {
            class_243 dir;
            handler.store(DataKey.FIXED_LOOK, true);
            if (anim.isAt("move_start")) {
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.5).method_1031(0.0, 0.3, 0.0));
            }
            if (anim.isPast("attack_start")) {
                if (anim.isAt("attack_start")) {
                    dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.5));
                }
                handler.applyMoveDirection();
                if (anim.isAt("sound")) {
                    entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if (!entity.method_37908().field_9236 && !anim.isPast("attack_end")) {
                    double range = CombatUtils.getRange(entity, -1.0);
                    handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1009(range * 0.5, 0.0, 0.0).method_1012(0.0, 0.0, range))).withBonusAttributes((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.DASH_SLASH)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
            }
            if (anim.isAt("attack_end")) {
                handler.store(DataKey.MOVE_DIRECTION, null);
            }
            handler.applyMoveDirection();
        }
    }

    @Override
    public void onEnd(class_1309 entity, AttackActionHandler handler) {
        if (handler.getComboCount() != 1) {
            return;
        }
        class_243 mot = entity.method_18798();
        double lenHor = mot.field_1352 * mot.field_1352 + mot.field_1350 * mot.field_1350;
        entity.method_18799(mot.method_18805(lenHor > 0.5 ? 0.5 : 1.0, 1.0, lenHor > 0.5 ? 0.5 : 1.0));
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return handler.getComboCount() == 1;
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

