/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.item.AOEWeapon;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class DualBladeAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(ComboContainer.past("done"), 2).addCombo(handler -> handler.isCurrentAnimationDone() && CombatUtils.canPerform(handler.getEntity(), Skills.DUAL, 20), 0).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.DUAL_BLADES.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimationState anim) {
        if (handler.getComboCount() != 5 && handler.getComboCount() != 6 && handler.getComboCount() != 8 && anim.isAt("attack")) {
            if (!entity.method_37908().field_9236) {
                CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.obbTargets(AOEWeapon.createOBB((class_1309)entity, (double)CombatUtils.getRange(entity, 0.0), (double)CombatUtils.getWidth(entity, handler.getComboCount() == 7 ? 1.0 : 0.0), (double)0.5))).executeAttack();
            }
            entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
        }
        switch (handler.getComboCount()) {
            case 1: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.15));
                break;
            }
            case 2: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.2));
                break;
            }
            case 3: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.25));
                break;
            }
            case 4: {
                if (!anim.isAt("step")) break;
                class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.3));
                break;
            }
            case 5: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("step")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(0.3));
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 360.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                break;
            }
            case 6: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454() - 90.0f));
                    entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                    class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(0.3));
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() + 360.0f, 0.0f)) != null) {
                    handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f, handler.get(DataKey.SPIN_ROTATION).floatValue() + 180.0f + 360.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
                break;
            }
            case 7: {
                class_243 dir;
                if (anim.isAt("leap")) {
                    dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                    entity.method_18799(dir.method_1021(1.1).method_1031(0.0, 0.6, 0.0));
                }
                if (!anim.isAt("down")) break;
                dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
                entity.method_18799(dir.method_1021(0.9).method_1031(0.0, -0.4, 0.0));
                break;
            }
            case 8: {
                CombatUtils.EntityAttack attack;
                if (anim.isAt("spin_start")) {
                    handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454() + 120.0f));
                    entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if (anim.isAt("reset")) {
                    handler.resetHitEntityTracker();
                    entity.method_5783((class_3414)RuneCraftorySounds.PLAYER_ATTACK_SWOOSH.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.0f);
                }
                if (anim.isAt("last")) {
                    entity.method_5783((class_3414)RuneCraftorySounds.SPELL_GENERIC_WIND_LONG.get(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 1.5f);
                }
                if ((attack = DualBladeAttack.spinAttack(entity, anim, anim.getMarker("spin_start", 0), anim.getMarker("spin_end", 0), handler.get(DataKey.SPIN_ROTATION).floatValue(), handler.get(DataKey.SPIN_ROTATION).floatValue() - 1440.0f, 0.0f)) == null) break;
                handler.addHitEntityTracker(attack.withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        if (handler.getComboCount() != 8 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            LevelCalc.useRP(Platform.INSTANCE.getPlayerData((class_1657)player), GeneralConfig.dualBladeUltimate, true, 0.0f, false, new Skills[0]);
        }
    }

    @Override
    public boolean isInvulnerable(class_1309 entity, AttackActionHandler handler) {
        return handler.getComboCount() == 8;
    }

    @Override
    public float movementReduction(AnimationState current) {
        return GeneralConfig.MOVE_SPEED_ATTACK.get().floatValue();
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return targetCombo < 5;
    }
}

