/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.attackactions;

import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.registry.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.AttackActionHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class WindSlashAttack
extends AttackAction {
    private final ComboContainer combo = ComboContainer.Builder.builder().addCombo(handler -> handler.getAnimation().isPast("chain_start") && !handler.getAnimation().isPast("spin_end")).build();

    @Override
    public AnimationState getAnimation(class_1309 entity, int comboIdx) {
        float speed = (float)EntityUtils.attackSpeedModifier(entity);
        return AttackAction.create(PlayerModelAnimations.WIND_SLASH.get(comboIdx), speed);
    }

    @Override
    public void run(class_1309 entity, class_1799 stack, AttackActionHandler handler, AnimationState anim) {
        class_243 dir;
        handler.store(DataKey.FIXED_LOOK, true);
        if (anim.isAt("spin_start")) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
            handler.resetHitEntityTracker();
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14550, entity.method_5634(), 0.7f, 0.5f);
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.35));
        }
        if (anim.isAt("reset")) {
            handler.resetHitEntityTracker();
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14550, entity.method_5634(), 1.0f, 0.7f);
        }
        if (anim.isAt("leap")) {
            dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.35).method_1031(0.0, 0.3, 0.0));
        }
        if (anim.isAt("spin_end")) {
            handler.store(DataKey.MOVE_DIRECTION, null);
        }
        if (anim.isPast("spin_start") && !anim.isPast("spin_end")) {
            entity.method_38785();
            if (!entity.method_37908().field_9236) {
                handler.addHitEntityTracker(CombatUtils.EntityAttack.create(entity, CombatUtils.EntityAttack.aabbTargets(entity.method_5829().method_1014(0.75))).withBonusAttributesMultiplier((class_6880<class_1320>)class_5134.field_23721, CombatUtils.getAbilityDamageBonus(stack, RuneCraftorySpells.WIND_SLASH)).withTargetPredicate(e -> !handler.getHitEntityTracker().contains(e)).executeAttack());
            }
        }
        handler.applyMoveDirection();
    }

    @Override
    public void onStart(class_1309 entity, AttackActionHandler handler) {
        super.onStart(entity, handler);
        if (handler.getComboCount() == 2) {
            handler.store(DataKey.SPIN_ROTATION, Float.valueOf(entity.method_36454()));
            handler.resetHitEntityTracker();
            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14550, entity.method_5634(), 1.0f, (entity.method_59922().method_43057() - entity.method_59922().method_43057()) * 0.2f + 0.7f);
            class_243 dir = CombatUtils.fromRelativeVector((class_1297)entity, new class_243(0.0, 0.0, 1.0));
            handler.store(DataKey.MOVE_DIRECTION, dir.method_1021(0.35));
        }
    }

    @Override
    public ComboContainer combos() {
        return this.combo;
    }

    @Override
    public boolean usableOnMounts(int targetCombo) {
        return false;
    }
}

