/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class QuestboardBlock
extends class_2383 {
    public static final MapCodec<QuestboardBlock> CODEC = QuestboardBlock.method_54094(QuestboardBlock::new);
    public static final class_265[] BOTTOM_LEFT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)7.0, (double)2.0, (double)10.0, (double)9.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)11.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)0.0, (double)10.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)10.0, (double)6.0, (double)16.0, (double)11.0, (double)10.0)});
    public static final class_265[] BOTTOM_RIGHT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)14.0, (double)0.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)11.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)15.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)10.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0)});
    public static final class_265[] TOP_LEFT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)1.0, (double)0.0, (double)6.5, (double)16.0, (double)15.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)1.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0)});
    public static final class_265[] TOP_RIGHT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)6.5, (double)15.0, (double)15.0, (double)9.5), VoxelUtils.ShapeBuilder.of((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)15.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0)});
    public static final class_2754<Part> PART = class_2754.method_11850((String)"part", Part.class);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final double RANGE = 48.0;

    public QuestboardBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public MapCodec<QuestboardBlock> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return switch (((Part)((Object)state.method_11654(PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BOTTOM_LEFT[((class_2350)state.method_11654((class_2769)FACING)).method_10161()];
            case 1 -> BOTTOM_RIGHT[((class_2350)state.method_11654((class_2769)FACING)).method_10161()];
            case 2 -> TOP_LEFT[((class_2350)state.method_11654((class_2769)FACING)).method_10161()];
            case 3 -> TOP_RIGHT[((class_2350)state.method_11654((class_2769)FACING)).method_10161()];
        };
    }

    public class_2680 method_9559(class_2680 state, class_2350 fromDir, class_2680 fromState, class_1936 level, class_2338 pos, class_2338 fromPos) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        Part part = (Part)((Object)state.method_11654(PART));
        class_2350 normalizedFrom = QuestboardBlock.rotateBy(fromDir, dir);
        if (part.neighbors.contains(normalizedFrom) && (!fromState.method_27852((class_2248)this) || fromState.method_11654((class_2769)FACING) != dir || fromState.method_11654(PART) != Part.getPartFor(part, normalizedFrom))) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, fromDir, fromState, level, pos, fromPos);
    }

    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        if (!(player instanceof class_3222)) {
            return class_9062.field_47729;
        }
        class_3222 serverPlayer = (class_3222)player;
        QuestHandler.openGui(serverPlayer, class_243.method_24953((class_2382)pos));
        return class_9062.field_47728;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state;
        class_2338 blockpos = ctx.method_8037();
        if (ctx.method_8045().method_8320(blockpos).method_26166(ctx) && QuestboardBlock.getPosMap(blockpos, state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).stream().allMatch(p -> ctx.method_8045().method_8320((class_2338)p.getSecond()).method_26166(ctx))) {
            return state;
        }
        return null;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 living, class_1799 stack) {
        super.method_9567(level, pos, state, living, stack);
        if (!level.field_9236) {
            QuestboardBlock.getPosMap(pos, state).forEach(p -> level.method_8652((class_2338)p.getSecond(), (class_2680)state.method_11657(PART, (Comparable)((Object)((Part)((Object)((Object)p.getFirst()))))), 3));
        }
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.field_9236 && player.method_7337()) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            QuestboardBlock.getPosMap(pos, state).forEach(p -> {
                class_2680 other = level.method_8320((class_2338)p.getSecond());
                if (other.method_27852((class_2248)this) && other.method_11654((class_2769)FACING) == facing && other.method_11654(PART) == p.getFirst()) {
                    level.method_8652((class_2338)p.getSecond(), class_2246.field_10124.method_9564(), 3);
                    level.method_8444(player, 2001, (class_2338)p.getSecond(), class_2248.method_9507((class_2680)other));
                }
            });
        }
        return super.method_9576(level, pos, state, player);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, PART});
    }

    public static List<Pair<Part, class_2338>> getPosMap(class_2338 from, class_2680 state) {
        class_2470 rotation = EntityUtils.fromDirection((class_2350)state.method_11654((class_2769)FACING));
        class_2338 offset = ((Part)((Object)state.method_11654(QuestboardBlock.PART))).offset;
        return Arrays.stream(Part.values()).map(p -> Pair.of((Object)p, (Object)p.offset.method_10069(-offset.method_10263(), -offset.method_10264(), -offset.method_10260()).method_10070(rotation).method_10081((class_2382)from))).toList();
    }

    private static class_2350 rotateBy(class_2350 direction, class_2350 rotate) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return direction;
        }
        return switch (rotate) {
            case class_2350.field_11035 -> direction.method_10153();
            case class_2350.field_11034 -> direction.method_10160();
            case class_2350.field_11039 -> direction.method_10170();
            default -> direction;
        };
    }

    public static enum Part implements class_3542
    {
        BOTTOM_LEFT(class_2338.field_10980, List.of(class_2350.field_11036, class_2350.field_11034)),
        BOTTOM_RIGHT(new class_2338(1, 0, 0), List.of(class_2350.field_11036, class_2350.field_11039)),
        TOP_LEFT(new class_2338(0, 1, 0), List.of(class_2350.field_11033, class_2350.field_11034)),
        TOP_RIGHT(new class_2338(1, 1, 0), List.of(class_2350.field_11033, class_2350.field_11039));

        public final class_2338 offset;
        public final List<class_2350> neighbors;

        private Part(class_2338 offset, List<class_2350> neighbors) {
            this.offset = offset;
            this.neighbors = neighbors;
        }

        @Nullable
        public static Part getPartFor(Part part, class_2350 direction) {
            class_2338 otherPos = part.offset.method_10081(direction.method_10163());
            for (Part p : Part.values()) {
                if (!p.offset.equals((Object)otherPos)) continue;
                return p;
            }
            return null;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

