/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.components.StaffData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9331;

public class RunecraftoryCommand {
    public static void reg(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"runecraftory").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"skill").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"skill", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9264(Stream.concat(Stream.of(Skills.values()).map(Object::toString), Stream.of("ALL")), (SuggestionsBuilder)builder)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillLevel)))).then(class_2170.method_9247((String)"xp").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillXP))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setSkillLevel))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"level").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setLevel)))).then(class_2170.method_9247((String)"xp").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addLevelXP)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlockRecipes").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"all").executes(RunecraftoryCommand::unlockRecipes))).then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(RunecraftoryCommand::allRecipes).executes(RunecraftoryCommand::unlockRecipe)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"recalcStats").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(RunecraftoryCommand::recalcStats)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"weather").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"weather", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9264(Stream.of(Weather.values()).map(Object::toString), (SuggestionsBuilder)builder)).executes(RunecraftoryCommand::setWeather)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(src -> src.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"all").executes(RunecraftoryCommand::resetAll))).then(class_2170.method_9247((String)"recipes").executes(RunecraftoryCommand::resetRecipes))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spell").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"cast").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"spell", (ArgumentType)class_7733.method_45603((class_7157)buildContext, RuneCraftorySpells.SPELL_REGISTRY_KEY)).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<class_2168>)ctx, Set.of(((class_2168)ctx.getSource()).method_9229())))).then(class_2170.method_9244((String)"as", (ArgumentType)class_2186.method_9306()).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<class_2168>)ctx, class_2186.method_9317((CommandContext)ctx, (String)"as"))))))).then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"spell", (ArgumentType)class_7733.method_45603((class_7157)buildContext, RuneCraftorySpells.SPELL_REGISTRY_KEY)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<class_2168>)ctx, Set.of(((class_2168)ctx.getSource()).method_9229())))).then(class_2170.method_9244((String)"as", (ArgumentType)class_2186.method_9306()).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<class_2168>)ctx, class_2186.method_9317((CommandContext)ctx, (String)"as")))))))));
    }

    private static int addSkillLevel(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
                PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                for (Skills skill : Skills.values()) {
                    XpLevelHolder skLvl = data.getSkillLevel(skill);
                    data.setSkillLevel(skill, skLvl.getLevel() + amount, skLvl.getXp(), true);
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.lvl.add", (Object[])new Object[]{s, player.method_5477(), amount}), false);
                ++ret;
            }
            return ret;
        }
        Skills skill = Skills.read(s);
        if (skill == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.no", (Object[])new Object[]{s}), false);
            return 0;
        }
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
            XpLevelHolder skLvl = data.getSkillLevel(skill);
            data.setSkillLevel(skill, skLvl.getLevel() + amount, skLvl.getXp(), true);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.lvl.add", (Object[])new Object[]{s, player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addSkillXP(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
                PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                for (Skills skill : Skills.values()) {
                    data.increaseSkill(skill, amount);
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.lvl.add", (Object[])new Object[]{s, player.method_5477(), amount}), false);
                ++ret;
            }
            return ret;
        }
        Skills skill = Skills.read(s);
        if (skill == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.no", (Object[])new Object[]{s}), false);
            return 0;
        }
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).increaseSkill(skill, amount);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.xp.add", (Object[])new Object[]{s, player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setSkillLevel(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
                PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
                for (Skills skill : Skills.values()) {
                    data.setSkillLevel(skill, amount, 0.0f, true);
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.lvl.set", (Object[])new Object[]{s, player.method_5477(), amount}), false);
                ++ret;
            }
            return ret;
        }
        Skills skill = Skills.read(s);
        if (skill == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.no", (Object[])new Object[]{s}), false);
            return 0;
        }
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).setSkillLevel(skill, amount, 0.0f, true);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.skill.lvl.set", (Object[])new Object[]{class_2561.method_43471((String)skill.getTranslation()), player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addLevelXP(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).addXp(amount);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.lvl.xp.add", (Object[])new Object[]{player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setLevel(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).setPlayerLevel(amount, 0.0f, true);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.lvl.set", (Object[])new Object[]{player.method_5477(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetAll(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
            data.resetAll();
            LoaderNetwork.INSTANCE.sendToPlayer((class_8710)new S2CCapSync(data), player);
            QuestHandler.getData(player).resetAll();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.reset.all", (Object[])new Object[]{player.method_5477()}), false);
            ++ret;
        }
        return ret;
    }

    private static CompletableFuture<Suggestions> allRecipes(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)((class_2168)ctx.getSource()).method_9207());
        if (data != null) {
            for (class_8786 r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.FORGE.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.comp_1932());
            }
            for (class_8786 r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.CHEMISTRY.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.comp_1932());
            }
            for (class_8786 r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.ARMOR.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.comp_1932());
            }
            for (class_8786 r : ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.COOKING.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.comp_1932());
            }
        }
        return class_2172.method_9264(allRecipes.stream().map(class_2960::toString), (SuggestionsBuilder)builder);
    }

    private static int unlockRecipe(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2960 res = class_2232.method_9443(ctx, (String)"id");
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).getRecipeKeeper().unlockRecipesRes((class_1657)player, List.of(res));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.unlock.recipe", (Object[])new Object[]{player.method_5477(), res.toString()}), false);
            ++ret;
        }
        return ret;
    }

    private static int unlockRecipes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.FORGE.get()).forEach(r -> allRecipes.add(r.comp_1932()));
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.CHEMISTRY.get()).forEach(r -> allRecipes.add(r.comp_1932()));
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.ARMOR.get()).forEach(r -> allRecipes.add(r.comp_1932()));
        ((class_2168)ctx.getSource()).method_9211().method_3772().method_30027((class_3956)RuneCraftoryCrafting.COOKING.get()).forEach(r -> allRecipes.add(r.comp_1932()));
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((class_1657)player).getRecipeKeeper().unlockRecipesRes((class_1657)player, allRecipes);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.unlock.recipes", (Object[])new Object[]{player.method_5477()}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetRecipes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (class_3222 player : class_2186.method_9312(ctx, (String)"player")) {
            PlayerData data = Platform.INSTANCE.getPlayerData((class_1657)player);
            data.getRecipeKeeper().lockRecipesRes((class_1657)player, data.getRecipeKeeper().unlockedRecipes());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.reset.recipe", (Object[])new Object[]{player.method_5477()}), false);
            ++ret;
        }
        return ret;
    }

    private static int setWeather(CommandContext<class_2168> ctx) {
        Weather weather;
        String s = StringArgumentType.getString(ctx, (String)"weather");
        try {
            weather = Weather.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"runecraftory.command.weather.no", (Object[])new Object[]{s}));
            return 0;
        }
        Calendar.get((class_1937)((class_2168)ctx.getSource()).method_9225()).updateWeatherTo(((class_2168)ctx.getSource()).method_9225(), weather);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.set.weather", (Object[])new Object[]{class_2561.method_43471((String)weather.translation)}), false);
        return 1;
    }

    private static int recalcStats(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection entities = class_2186.method_9317(ctx, (String)"entities");
        int i = 0;
        for (class_1297 e : entities) {
            if (e instanceof class_3222) {
                class_3222 player = (class_3222)e;
                Platform.INSTANCE.getPlayerData((class_1657)player).recalculateStats(false);
                ++i;
                continue;
            }
            if (e instanceof NPCEntity) {
                NPCEntity npc = (NPCEntity)e;
                npc.recalcStatsFull();
                ++i;
                continue;
            }
            if (!(e instanceof BaseMonster)) continue;
            BaseMonster monster = (BaseMonster)e;
            monster.recalcStatsFull();
            ++i;
        }
        int affected = i;
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"runecraftory.command.recalc.stats", (Object[])new Object[]{affected}), false);
        return i;
    }

    private static int castSpell(CommandContext<class_2168> ctx, Collection<? extends class_1297> entities) throws CommandSyntaxException {
        int success = 0;
        class_6880.class_6883 spell = class_7733.method_45602(ctx, (String)"spell", (class_5321)RuneCraftorySpells.SPELLS.registry().method_30517());
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1309)) continue;
            class_1309 living = (class_1309)class_12972;
            ((Spell)spell.comp_349()).use(living);
            ++success;
        }
        return success;
    }

    private static int applySpellTo(CommandContext<class_2168> ctx, Collection<? extends class_1297> entities) throws CommandSyntaxException {
        int success = 0;
        class_6880.class_6883 spell = class_7733.method_45602(ctx, (String)"spell", (class_5321)RuneCraftorySpells.SPELLS.registry().method_30517());
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        for (class_1297 class_12972 : entities) {
            class_1309 living;
            class_1799 stack;
            if (!(class_12972 instanceof class_1309) || !((stack = (living = (class_1309)class_12972).method_6047()).method_7909() instanceof ItemStaffBase)) continue;
            StaffData data = (StaffData)stack.method_57825((class_9331)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT);
            class_9331 class_93312 = (class_9331)RuneCraftoryDataComponentTypes.STAFF.get();
            stack.method_57379(class_93312, (Object)(switch (tier) {
                case 3 -> data.setTier3Spell((class_6880<Spell>)spell);
                case 2 -> data.setTier2Spell((class_6880<Spell>)spell);
                default -> data.setTier1Spell((class_6880<Spell>)spell);
            }));
            ++success;
        }
        return success;
    }
}

