/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record StaffData(Optional<class_6880<Spell>> tier1, Optional<class_6880<Spell>> tier2, Optional<class_6880<Spell>> tier3, int chargeTime) {
    private final int chargeTime;
    public static final StaffData DEFAULT = new StaffData(Optional.empty(), Optional.empty(), Optional.empty(), 0);
    public static final Codec<StaffData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuneCraftorySpells.SPELLS.registry().method_40294().optionalFieldOf("first_spell").forGetter(StaffData::tier1), (App)RuneCraftorySpells.SPELLS.registry().method_40294().optionalFieldOf("second_spell").forGetter(StaffData::tier2), (App)RuneCraftorySpells.SPELLS.registry().method_40294().optionalFieldOf("third_spell").forGetter(StaffData::tier3), (App)Codec.INT.fieldOf("charge_time").forGetter(d -> d.chargeTime)).apply((Applicative)instance, StaffData::new));
    private static final class_9139<class_9129, Optional<class_6880<Spell>>> SPELL_CODEC = class_9135.method_56382((class_9139)class_9135.method_56383((class_5321)RuneCraftorySpells.SPELLS.registry().method_30517()));
    public static final class_9139<class_9129, StaffData> STREAM_CODEC = new class_9139<class_9129, StaffData>(){

        public StaffData decode(class_9129 buf) {
            return new StaffData((Optional)SPELL_CODEC.decode((Object)buf), (Optional)SPELL_CODEC.decode((Object)buf), (Optional)SPELL_CODEC.decode((Object)buf), buf.readInt());
        }

        public void encode(class_9129 buf, StaffData component) {
            SPELL_CODEC.encode((Object)buf, component.tier1());
            SPELL_CODEC.encode((Object)buf, component.tier2());
            SPELL_CODEC.encode((Object)buf, component.tier3());
            buf.method_53002(component.chargeTime);
        }
    };

    public StaffData setTier1Spell(@Nullable class_6880<Spell> spell) {
        return new StaffData(Optional.ofNullable(spell), this.tier2, this.tier3, spell != null ? ((Spell)spell.comp_349()).properties().cooldown() : this.chargeTime);
    }

    public StaffData setTier2Spell(@Nullable class_6880<Spell> spell) {
        return new StaffData(this.tier1, Optional.ofNullable(spell), this.tier3, spell != null && this.tier1.isEmpty() ? ((Spell)spell.comp_349()).properties().cooldown() : this.chargeTime);
    }

    public StaffData setTier3Spell(@Nullable class_6880<Spell> spell) {
        return new StaffData(this.tier1, this.tier2, Optional.ofNullable(spell), spell != null && this.tier1.isEmpty() && this.tier2.isEmpty() ? ((Spell)spell.comp_349()).properties().cooldown() : this.chargeTime);
    }

    public Spell fromChargeLevel(class_1799 stack, int level) {
        Spell spell;
        switch (level) {
            case 3: {
                Spell spell2 = this.tier3.map(class_6880::comp_349).orElse(null);
                break;
            }
            case 2: {
                Spell spell2 = this.tier2.map(class_6880::comp_349).orElse(null);
                break;
            }
            case 1: {
                Spell spell2 = this.tier1.map(class_6880::comp_349).orElse(null);
                break;
            }
            default: {
                Spell spell2 = spell = null;
            }
        }
        if (spell == null) {
            return DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).flatMap(stat -> switch (level) {
                case 3 -> stat.getTier3Spell();
                case 2 -> stat.getTier2Spell();
                case 1 -> stat.getTier1Spell();
                default -> Optional.empty();
            }).map(class_6880::comp_349).orElse(null);
        }
        return spell;
    }

    public int getChargeLevel() {
        if (this.tier3.isPresent()) {
            return 3;
        }
        if (this.tier2.isPresent()) {
            return 2;
        }
        if (this.tier1.isPresent()) {
            return 1;
        }
        return 0;
    }

    public int chargeTime() {
        return this.chargeTime == 0 ? (int)((RuneCraftoryAttributes.OrderedAttribute)((Object)RuneCraftoryAttributes.CHARGE_TIME.get())).method_6169() : this.chargeTime;
    }
}

