/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.datapack.SyncableListener;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class CropManager
extends class_4309
implements SyncableListener<Map<class_1792, ReloadableHolder<CropProperties>>> {
    public static final class_2960 ID = RuneCraftory.modRes("crop_property");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static final class_9139<class_9129, ReloadableHolder<CropProperties>> HOLDER_CODEC = ReloadableHolder.streamCodec(CropProperties.STREAM_CODEC);
    public static final class_9139<class_9129, Map<class_1792, ReloadableHolder<CropProperties>>> CODEC = new class_9139<class_9129, Map<class_1792, ReloadableHolder<CropProperties>>>(){

        public Map<class_1792, ReloadableHolder<CropProperties>> decode(class_9129 buf) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                builder.put((Object)((class_1792)class_9135.method_56365((class_5321)class_7924.field_41197).decode((Object)buf)), (Object)((ReloadableHolder)HOLDER_CODEC.decode((Object)buf)));
            }
            return builder.build();
        }

        public void encode(class_9129 buf, Map<class_1792, ReloadableHolder<CropProperties>> props) {
            buf.method_10804(props.size());
            props.forEach((item, prop) -> {
                class_9135.method_56365((class_5321)class_7924.field_41197).encode((Object)buf, item);
                HOLDER_CODEC.encode((Object)buf, prop);
            });
        }
    };
    private Map<class_1792, ReloadableHolder<CropProperties>> crops = ImmutableMap.of();
    private boolean resolved;
    private Map<class_6862<class_1792>, ReloadableHolder<CropProperties>> tagCrops = ImmutableMap.of();
    private class_7225.class_7874 provider;

    public CropManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    @Nullable
    public CropProperties get(class_1792 item) {
        ReloadableHolder<CropProperties> value = this.getWithId(item);
        return value != null ? value.value() : null;
    }

    @Nullable
    public ReloadableHolder<CropProperties> getWithId(class_1792 item) {
        if (GeneralConfig.disableCropSystem) {
            return null;
        }
        this.resolveTags(false);
        return this.crops.get(item);
    }

    public void resolveTags(boolean forced) {
        if (!this.resolved || forced) {
            this.resolved = true;
            HashMap<class_1792, ReloadableHolder<CropProperties>> itemEntries = new HashMap<class_1792, ReloadableHolder<CropProperties>>(this.crops);
            this.tagCrops.entrySet().stream().sorted(Comparator.comparing(e -> ((class_6862)e.getKey()).comp_327())).forEach(entry -> HolderUtils.expandTag(this.provider, class_7924.field_41197, (class_6862)entry.getKey()).forEach(item -> {
                if (!itemEntries.containsKey(item)) {
                    itemEntries.put((class_1792)item, (ReloadableHolder)entry.getValue());
                }
            }));
            this.crops = ImmutableMap.copyOf(itemEntries);
        }
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        this.resolved = false;
        ImmutableMap.Builder itemEntries = ImmutableMap.builder();
        ImmutableMap.Builder tagEntries = ImmutableMap.builder();
        class_6903 ops = this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$4((DynamicOps)ops, tagEntries, itemEntries, arg_0, arg_1));
        this.crops = itemEntries.build();
        this.tagCrops = tagEntries.build();
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    @Override
    public class_9139<class_9129, Map<class_1792, ReloadableHolder<CropProperties>>> codec() {
        return CODEC;
    }

    @Override
    public Map<class_1792, ReloadableHolder<CropProperties>> toSync() {
        this.resolveTags(false);
        return Collections.unmodifiableMap(this.crops);
    }

    @Override
    public void update(class_7225.class_7874 provider, Map<class_1792, ReloadableHolder<CropProperties>> value) {
        this.insertRegistryAccess(provider);
        this.crops = value;
    }

    private /* synthetic */ void lambda$apply$4(DynamicOps ops, ImmutableMap.Builder tagEntries, ImmutableMap.Builder itemEntries, class_2960 fres, JsonElement el) {
        try {
            JsonObject obj = el.getAsJsonObject();
            String key = class_3518.method_15265((JsonObject)obj, (String)"item");
            if (key.startsWith("#")) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)key.substring(1)));
                CropProperties props = (CropProperties)CropProperties.CODEC.parse(ops, (Object)el).getOrThrow();
                tagEntries.put((Object)tag, new ReloadableHolder<CropProperties>(fres, props));
            } else {
                Optional<class_1792> item = HolderUtils.get(this.provider, class_7924.field_41197, class_2960.method_60654((String)key));
                item.ifPresent(i -> {
                    CropProperties props = (CropProperties)CropProperties.CODEC.parse(ops, (Object)el).getOrThrow();
                    itemEntries.put(i, new ReloadableHolder<CropProperties>(fres, props));
                });
            }
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse crop properties json {} {}", (Object)fres, (Object)ex);
            ex.fillInStackTrace();
        }
    }
}

