/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GateSpawnData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.ListenerExtension;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.common.utils.HolderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2048;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3486;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class GateSpawnsManager
extends class_4309
implements ListenerExtension {
    public static final class_2960 ID = RuneCraftory.modRes("gate_spawn");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private Map<class_6862<class_1959>, List<SpawnResource>> biomeSpawns = new HashMap<class_6862<class_1959>, List<SpawnResource>>();
    private Map<class_3195, List<SpawnResource>> structureSpawns = new HashMap<class_3195, List<SpawnResource>>();
    private class_7225.class_7874 provider;

    public GateSpawnsManager() {
        super(DataPackHandler.GSON, DIRECTORY);
    }

    public List<class_1299<?>> pickRandomMobs(class_3218 level, GateEntity gate, class_6880<class_1959> biome, class_5819 rand, int amount, class_2338 pos, List<class_3222> players) {
        List<SpawnResource> list = this.structureSpawns.entrySet().stream().filter(e -> level.method_27056().method_38854(pos, (class_3195)e.getKey()).method_16657()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        if (list.isEmpty()) {
            biome.method_40228().forEach(tag -> {
                List<SpawnResource> l = this.biomeSpawns.get(tag);
                if (l != null) {
                    list.addAll(l);
                }
            });
        }
        list.removeIf(w -> w.playerPredicate.isPresent() && players.stream().noneMatch(p -> w.playerPredicate.get().method_8914(p, (class_1297)p)));
        if (list.isEmpty()) {
            return new ArrayList();
        }
        double dist = pos.method_10262((class_2382)level.method_43126());
        class_2680 state = level.method_8320(pos);
        list.removeIf(w -> !w.matches(level, pos, state, dist, gate));
        ArrayList ret = new ArrayList();
        if (amount > list.size()) {
            list.forEach(w -> ret.add((class_1299)w.entity.comp_349()));
        } else {
            class_1299 type;
            int totalWeight = class_6011.method_34984(list);
            for (int i = amount; i > 0 && !ret.contains(type = (class_1299)class_6011.method_34987((class_5819)rand, list, (int)totalWeight).map(w -> (class_1299)w.entity.comp_349()).orElse(null)); --i) {
                if (type == null) continue;
                ret.add(type);
            }
        }
        return ret;
    }

    public boolean hasSpawns(class_5425 level, class_2338 pos, class_2680 state) {
        if (level.method_23753(pos).method_40228().anyMatch(t -> {
            List<SpawnResource> l = this.biomeSpawns.get(t);
            return l != null && l.stream().anyMatch(r -> r.canSpawn(level.method_8410(), pos, state));
        })) {
            return true;
        }
        return this.hasStructureSpawns(level.method_8410(), pos);
    }

    public boolean hasStructureSpawns(class_3218 level, class_2338 pos) {
        return this.structureSpawns.entrySet().stream().anyMatch(e -> level.method_27056().method_38854(pos, (class_3195)e.getKey()).method_16657());
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        LinkedHashMap biomeSpawns = new LinkedHashMap();
        LinkedHashMap structureSpawns = new LinkedHashMap();
        class_6903 ops = this.provider.method_57093((DynamicOps)JsonOps.INSTANCE);
        data.forEach((arg_0, arg_1) -> this.lambda$apply$18((DynamicOps)ops, biomeSpawns, structureSpawns, arg_0, arg_1));
        this.biomeSpawns = ImmutableMap.copyOf(biomeSpawns);
        this.structureSpawns = ImmutableMap.copyOf(structureSpawns);
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public void insertRegistryAccess(class_7225.class_7874 provider) {
        this.provider = provider;
    }

    private /* synthetic */ void lambda$apply$18(DynamicOps ops, Map biomeSpawns, Map structureSpawns, class_2960 fres, JsonElement el) {
        try {
            GateSpawnData spawnData = (GateSpawnData)GateSpawnData.CODEC.parse(ops, (Object)el).getOrThrow();
            Optional<class_6880<class_6880>> optType = HolderUtils.getHolder(this.provider, class_7924.field_41266, spawnData.entity());
            optType.ifPresentOrElse(type -> {
                spawnData.biomes().forEach((key, weight) -> {
                    SpawnResource resource = new SpawnResource((class_6880<class_1299<?>>)type, spawnData, (int)weight);
                    biomeSpawns.computeIfAbsent(key, o -> new ArrayList()).add(resource);
                });
                spawnData.structures().forEach((key, weight) -> {
                    Optional<class_3195> optFeat = HolderUtils.get(this.provider, class_7924.field_41246, key);
                    optFeat.ifPresentOrElse(feat -> {
                        SpawnResource resource = new SpawnResource((class_6880<class_1299<?>>)type, spawnData, (int)weight);
                        structureSpawns.computeIfAbsent(feat, o -> new ArrayList()).add(resource);
                    }, () -> RuneCraftory.LOGGER.error("No such structure {} for spawn data {}", key, (Object)fres));
                });
            }, () -> RuneCraftory.LOGGER.error("No such entity {} for spawn data {}", (Object)spawnData.entity(), (Object)fres));
        }
        catch (Exception ex) {
            RuneCraftory.LOGGER.error("Couldn't parse spawn data json {} {}", (Object)fres, (Object)ex);
            ex.fillInStackTrace();
        }
    }

    public static class SpawnResource
    extends class_6008.class_6009 {
        private final class_6880<class_1299<?>> entity;
        private final int distToSpawnSq;
        private final int minGateLevel;
        private final boolean allowWater;
        private final Optional<class_2048> gatePredicate;
        private final Optional<class_2048> playerPredicate;

        public SpawnResource(class_6880<class_1299<?>> entity, GateSpawnData spawnData, int weight) {
            super(weight);
            this.entity = entity;
            this.distToSpawnSq = spawnData.minDistanceFromSpawn() * spawnData.minDistanceFromSpawn();
            this.minGateLevel = spawnData.minGateLevel();
            this.allowWater = spawnData.canSpawnInWater();
            this.gatePredicate = spawnData.gatePredicate();
            this.playerPredicate = spawnData.playerPredicate();
        }

        public boolean canSpawn(class_3218 serverLevel, class_2338 pos, class_2680 state) {
            return pos.method_10262((class_2382)serverLevel.method_43126()) >= (double)this.distToSpawnSq && (state.method_26227().method_15769() || this.allowWater && state.method_26227().method_15767(class_3486.field_15517) && serverLevel.method_22348(pos));
        }

        public boolean matches(class_3218 serverLevel, class_2338 pos, class_2680 state, double dist, GateEntity gate) {
            return dist >= (double)this.distToSpawnSq && (state.method_26227().method_15769() || this.allowWater && state.method_26227().method_15767(class_3486.field_15517) && serverLevel.method_22348(pos)) && gate.xpLevel().getLevel() >= this.minGateLevel && (this.gatePredicate.isEmpty() || this.gatePredicate.get().method_8909(serverLevel, gate.method_19538(), (class_1297)gate));
        }

        public String toString() {
            return String.format("Entity: %s, MinSpawnSq: %d, Weight: %s, MinGateLevel: %s", this.entity.method_55840(), this.distToSpawnSq, this.method_34979(), this.minGateLevel);
        }
    }
}

