/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackAction;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class DoNPCAttackAction
extends ExtendedBehaviour<NPCEntity> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).hasMemories(new class_4140[]{(class_4140)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()});
    private NPCAttackAction current;

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(NPCEntity entity) {
        BrainUtils.withMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()), selected -> {
            this.current = selected;
            entity.weaponHandler.doWeaponAttack(selected.action(), entity.method_6047(), selected.spell().orElse(null));
        });
        BrainUtils.clearMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()));
    }

    protected boolean shouldKeepRunning(NPCEntity entity) {
        if (this.current == null) {
            return false;
        }
        if (entity.weaponHandler.isScheduledAction()) {
            return true;
        }
        return this.tryScheduleCombo(entity);
    }

    protected void stop(NPCEntity entity) {
        super.stop((class_1309)entity);
        BrainUtils.clearMemory((class_1309)entity, (class_4140)((class_4140)RuneCraftoryMemoryTypes.NPC_ATTACK_ACTION.get()));
        this.current = null;
    }

    private boolean tryScheduleCombo(NPCEntity npc) {
        if (npc.weaponHandler.isScheduledAction()) {
            return false;
        }
        int combo = npc.weaponHandler.getComboCount();
        if (this.current != null && combo < this.current.comboCount()) {
            npc.weaponHandler.doWeaponAttack(this.current.action(), npc.method_6047(), this.current.spell().orElse(null));
            return true;
        }
        return false;
    }
}

