/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;

public class ElementalBallEntity
extends BaseProjectile {
    protected static final class_2940<Integer> ELEMENT_DATA = class_2945.method_12791(ElementalBallEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> VARIANT = class_2945.method_12791(ElementalBallEntity.class, (class_2941)class_2943.field_13327);
    private ItemElement element = ItemElement.NONE;
    private int maxLivingTicks = 6;

    public ElementalBallEntity(class_1299<? extends ElementalBallEntity> type, class_1937 level) {
        super(type, level);
    }

    public ElementalBallEntity(class_1937 level, class_1309 shooter, ItemElement element) {
        super((class_1299<? extends BaseProjectile>)((class_1299)RuneCraftoryEntities.ELEMENTAL_BALL.get()), level, shooter);
        this.element = element;
        this.field_6011.method_12778(ELEMENT_DATA, (Object)this.element.ordinal());
        this.damageMultiplier = 0.8f;
    }

    public ItemElement getElement() {
        return this.element;
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void withMaxLivingTicks(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public float radius() {
        return 0.5f;
    }

    public void method_5674(class_2940<?> key) {
        int i;
        super.method_5674(key);
        if (key == ELEMENT_DATA && (i = ((Integer)this.field_6011.method_12789(ELEMENT_DATA)).intValue()) < ItemElement.values().length) {
            this.element = ItemElement.values()[i];
        }
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ELEMENT_DATA, (Object)0);
        builder.method_56912(VARIANT, (Object)0);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new DynamicDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().element(this.element).hurtResistant(5), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.method_31472();
        this.playHitSound();
        return att;
    }

    protected void onBlockHit(class_3965 result) {
        this.method_31472();
        this.playHitSound();
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(ELEMENT_DATA, (Object)compound.method_10550("Element"));
        this.field_6011.method_12778(VARIANT, (Object)compound.method_10550("Variant"));
        this.maxLivingTicks = compound.method_10550("MaxLivingTicks");
        int i = (Integer)this.field_6011.method_12789(ELEMENT_DATA);
        if (i < ItemElement.values().length) {
            this.element = ItemElement.values()[i];
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Element", this.element.ordinal());
        compound.method_10569("Variant", ((Integer)this.field_6011.method_12789(VARIANT)).intValue());
        compound.method_10569("MaxLivingTicks", this.maxLivingTicks);
    }

    protected void playHitSound() {
        if (this.element == ItemElement.WATER) {
            class_3414 event = this.getVariant() == 1 ? (class_3414)class_3417.field_15152.comp_349() : (class_3414)RuneCraftorySounds.SPELL_GENERIC_WATER.get();
            this.method_5783(event, this.getVariant() == 1 ? 0.9f : 0.35f, 1.0f);
        }
    }
}

