/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_6880;

public class ElementalTrailEntity
extends BaseDamageCloud {
    private static final class_2940<Integer> ELEMENT_DATA = class_2945.method_12791(ElementalTrailEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> STATIONARY = class_2945.method_12791(ElementalTrailEntity.class, (class_2941)class_2943.field_13323);
    private ItemElement element = ItemElement.NONE;
    private boolean piercing = true;
    private boolean hasKnockback;
    private boolean homing;
    private class_1309 targetMob;
    private int livingTicksMax = 100;

    public ElementalTrailEntity(class_1299<? extends ElementalTrailEntity> type, class_1937 level) {
        super(type, level);
    }

    public ElementalTrailEntity(class_1937 level, class_1309 thrower, ItemElement element) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)RuneCraftoryEntities.ELEMENTAL_TRAIL.get()), level, thrower);
        this.method_5814(this.method_23317(), this.method_23318() + (double)thrower.method_17682() * 0.5, this.method_23321());
        this.setElement(element);
        this.setRadius(0.5f);
    }

    public void shootAtEntity(class_243 targetPos, float velocity, float inaccuracy) {
        class_243 dir = new class_243(targetPos.method_10216() - this.method_23317(), targetPos.method_10214() - this.method_23318(), targetPos.method_10215() - this.method_23321());
        this.shoot(dir.field_1352, dir.field_1351, dir.field_1350, velocity, inaccuracy);
    }

    public void shoot(class_1297 entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -class_3532.method_15374((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -class_3532.method_15374((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(rotationYawIn * ((float)Math.PI / 180))) * class_3532.method_15362((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        class_243 throwerMotion = entityThrower.method_18798();
        this.method_18799(this.method_18798().method_1031(throwerMotion.field_1352, entityThrower.method_24828() ? 0.0 : throwerMotion.field_1351, throwerMotion.field_1350));
        this.method_18798().method_1031(throwerMotion.field_1352, 0.0, throwerMotion.field_1350);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vector3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vector3d);
        double f = Math.sqrt(AdvancedProjectile.horizontalMag((class_243)vector3d));
        this.method_36456((float)(class_3532.method_15349((double)vector3d.field_1352, (double)vector3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vector3d.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void setElement(ItemElement element) {
        this.element = element;
        this.field_6011.method_12778(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public ItemElement element() {
        return this.element;
    }

    public void setStationary(boolean stationary) {
        this.field_6011.method_12778(STATIONARY, (Object)stationary);
    }

    public void setPiercing(boolean piercing) {
        this.piercing = piercing;
    }

    public void knockback() {
        this.hasKnockback = true;
    }

    public void homing() {
        this.homing = true;
    }

    public void withMaxLiving(int livingTicksMax) {
        this.livingTicksMax = livingTicksMax;
    }

    public void method_5674(class_2940<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = ItemElement.values()[(Integer)this.field_6011.method_12789(ELEMENT_DATA)];
        }
        super.method_5674(key);
    }

    public int livingTickMax() {
        return this.livingTicksMax;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ELEMENT_DATA, (Object)0);
        builder.method_56912(STATIONARY, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        if (!((Boolean)this.field_6011.method_12789(STATIONARY)).booleanValue()) {
            class_243 motion = this.method_18798();
            double newX = this.method_23317() + motion.field_1352;
            double newY = this.method_23318() + motion.field_1351;
            double newZ = this.method_23321() + motion.field_1350;
            this.method_5814(newX, newY, newZ);
        }
        if (!this.method_37908().field_9236) {
            if (this.homing) {
                if (this.targetMob == null || this.targetMob.method_29504()) {
                    this.targetMob = EntityUtils.ownedProjectileTarget(this.method_24921(), 10);
                } else {
                    class_243 dir = this.targetMob.method_19538().method_1020(this.method_19538());
                    if (dir.method_1027() > 0.0484) {
                        dir = dir.method_1029().method_1021(0.22);
                    }
                    this.method_18799(dir);
                    this.field_6007 = true;
                }
            }
        } else if (this.livingTicks % 2 == 0) {
            if (this.element == ItemElement.WATER) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)RuneCraftorySounds.ENTITY_ELEMENTAL_TRAIL_WATER.get(), this.method_5634(), 0.7f, 0.8f, false);
            }
            if (this.element == ItemElement.EARTH) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)RuneCraftorySounds.ENTITY_ELEMENTAL_TRAIL_EARTH.get(), this.method_5634(), 1.0f, 0.8f, false);
            }
        }
    }

    protected boolean damageEntity(class_1309 target) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), (class_1297)target, new DynamicDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(10).element(this.element), CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null)) {
            if (this.hasKnockback) {
                target.method_6005(0.5, this.method_23317() - target.method_23317(), this.method_23321() - target.method_23321());
            }
            if (!this.piercing) {
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        try {
            this.setElement(ItemElement.values()[compound.method_10550("Element")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.field_6011.method_12778(STATIONARY, (Object)compound.method_10577("Stationary"));
        this.piercing = compound.method_10577("Piercing");
        this.hasKnockback = compound.method_10577("Knockback");
        this.homing = compound.method_10577("Homing");
        this.livingTicksMax = compound.method_10550("LivingTicksMax");
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Element", this.element.ordinal());
        compound.method_10556("Stationary", ((Boolean)this.field_6011.method_12789(STATIONARY)).booleanValue());
        compound.method_10556("Piercing", this.piercing);
        compound.method_10556("Knockback", this.hasKnockback);
        compound.method_10556("Homing", this.homing);
        compound.method_10569("LivingTicksMax", this.livingTicksMax);
    }
}

