/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.attachment.EntityData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1320;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MarionettaTrapEntity
extends class_1297
implements class_6025,
AnimatedEntity {
    public static int SWORDS = 7;
    public static int DURATION = 120;
    public static int SPIN_START = 80;
    public static int SPIN_STOP = 40;
    public static int[] ATTACK_TIMES = MarionettaTrapEntity.calculateAttackTimes();
    private static final class_2940<class_2487> CAUGHT_ENTITIES = class_2945.method_12791(MarionettaTrapEntity.class, (class_2941)class_2943.field_13318);
    private static final AnimationDefinitionContainer ANIMS = new AnimationDefinitionContainer(Map.of());
    private final List<class_1309> caughtEntities = new ArrayList<class_1309>();
    private final AnimationHandler<MarionettaTrapEntity> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private int tickLeft = DURATION;
    private class_1309 shooter;
    private UUID shooterUUID;
    private float damageMultiplier = 0.7f;
    private final boolean[] playSpawnSound = new boolean[SWORDS];
    private int shakeTicks;

    public MarionettaTrapEntity(class_1299<? extends MarionettaTrapEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
    }

    public MarionettaTrapEntity(class_1937 level, class_1309 shooter) {
        this((class_1299<? extends MarionettaTrapEntity>)((class_1299)RuneCraftoryEntities.TRAP_CHEST.get()), level);
        this.shooter = shooter;
        this.shooterUUID = shooter.method_5667();
        this.method_5814(shooter.method_23317(), shooter.method_23320(), shooter.method_23321());
    }

    public static double horizontalMag(class_243 vec) {
        return vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350;
    }

    private static int[] calculateAttackTimes() {
        int[] times = new int[SWORDS];
        int time = 27;
        for (int i = 0; i < SWORDS; ++i) {
            times[i] = time;
            time -= 3;
        }
        return times;
    }

    public void addCaughtEntity(class_1309 entity) {
        this.caughtEntities.add(entity);
        this.field_6011.method_12778(CAUGHT_ENTITIES, (Object)this.writeCaughtEntities());
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void throwIn(class_243 dir) {
        this.setMotionWithRotation(dir);
    }

    private void setMotionWithRotation(class_243 motion) {
        this.method_18799(motion);
        double f = Math.sqrt(MarionettaTrapEntity.horizontalMag(motion));
        this.method_36456((float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(CAUGHT_ENTITIES, (Object)new class_2487());
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key == CAUGHT_ENTITIES) {
            class_2487 tag = (class_2487)this.field_6011.method_12789(CAUGHT_ENTITIES);
            this.readCaughtEntities(tag);
        }
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public void method_5670() {
        super.method_5670();
        if (!this.method_24828()) {
            class_243 motion = this.method_18798();
            double f = Math.sqrt(MarionettaTrapEntity.horizontalMag(motion));
            this.method_36456(this.updateRotation(this.field_5982, (float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.29577951308232)));
            this.method_36457(this.updateRotation(this.field_6004, (float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 57.2957763671875)));
            boolean water = this.method_5799();
            float friction = water ? 0.8f : 0.85f;
            this.method_18799(motion.method_1021((double)friction).method_1023(0.0, (double)0.05f, 0.0));
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        --this.tickLeft;
        this.caughtEntities.forEach(entity -> {
            if (entity.method_5805()) {
                Platform.INSTANCE.getEntityData((class_1309)entity).setInvis(10);
                if (entity instanceof class_3222) {
                    class_3222 player = (class_3222)entity;
                    player.method_24203(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.05, this.method_23321());
                } else {
                    entity.method_5814(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.05, this.method_23321());
                }
                EntityData data = Platform.INSTANCE.getEntityData((class_1309)entity);
                if (!data.thirdPersonView()) {
                    data.setThirdPersonView(true);
                }
            }
        });
        if (!this.method_37908().field_9236) {
            if (this.method_35057() != null && this.canAttack(0)) {
                boolean[] success = new boolean[]{false};
                this.caughtEntities.forEach(e -> {
                    if (CombatUtils.mobAttack(this.method_35057(), (class_1297)e, new DynamicDamage.Builder(this, (class_1297)this.method_35057()).hurtResistant(0), CombatUtils.getAttributeValue((class_1297)this.method_35057(), (class_6880<class_1320>)class_5134.field_23721) * (double)this.damageMultiplier) && !success[0]) {
                        success[0] = true;
                    }
                });
                if (success[0]) {
                    this.method_5783(class_3417.field_15016, 1.0f, 1.0f);
                }
            }
            if (this.tickLeft <= 0) {
                this.caughtEntities.forEach(entity -> {
                    Platform.INSTANCE.getEntityData((class_1309)entity).setInvis(0);
                    Platform.INSTANCE.getEntityData((class_1309)entity).setThirdPersonView(false);
                });
                this.method_31472();
            }
        } else {
            --this.shakeTicks;
            if (this.canAttack(1) && !this.caughtEntities.isEmpty()) {
                this.shakeTicks = 2;
            }
        }
    }

    protected boolean canAttack(int offset) {
        for (int i : ATTACK_TIMES) {
            if (this.tickLeft + offset != i) continue;
            return true;
        }
        return false;
    }

    public void method_5749(class_2487 compound) {
        this.damageMultiplier = compound.method_10583("DamageMultiplier");
    }

    public void method_5652(class_2487 compound) {
        compound.method_10548("DamageMultiplier", this.damageMultiplier);
    }

    public boolean method_30948() {
        return true;
    }

    public int getTickLeft() {
        return this.tickLeft;
    }

    public float getSpinProgress(float partialTicks) {
        int duration = SPIN_START - SPIN_STOP;
        return 1.0f - class_3532.method_15363((float)(((float)(this.getTickLeft() - SPIN_STOP) - partialTicks) / (float)duration), (float)0.0f, (float)1.0f);
    }

    public float getAttackProgress(int idx, float partialTicks) {
        int time = ATTACK_TIMES[idx] - 1;
        return 1.0f - class_3532.method_15363((float)(((float)(this.getTickLeft() - time) - partialTicks) / 6.0f), (float)0.0f, (float)1.0f);
    }

    public float shake(float partialTicks) {
        if (this.shakeTicks <= 0) {
            return 0.0f;
        }
        return (float)this.shakeTicks - partialTicks;
    }

    public void playSpawnSound(int idx) {
        if (idx < 0 || idx >= this.playSpawnSound.length) {
            return;
        }
        if (!this.playSpawnSound[idx]) {
            this.playSpawnSound[idx] = true;
            if (this.method_37908().field_9236) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14600, this.method_5634(), 1.0f, 1.0f, false);
            } else {
                this.method_5783(class_3417.field_14600, 1.0f, 1.0f);
            }
        }
    }

    private float updateRotation(float prev, float current) {
        while (current - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (current - prev >= 180.0f) {
            prev += 360.0f;
        }
        return class_3532.method_16439((float)0.2f, (float)prev, (float)current);
    }

    public UUID method_6139() {
        return this.shooterUUID;
    }

    @Nullable
    public class_1309 method_35057() {
        UUID uuid;
        if ((this.shooter == null || this.shooter.method_31481()) && (uuid = this.method_6139()) != null) {
            this.shooter = (class_1309)EntityUtils.findFromUUID(class_1309.class, (class_1937)this.method_37908(), (UUID)uuid);
        }
        return this.shooter;
    }

    private class_2487 writeCaughtEntities() {
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        this.caughtEntities.forEach(e -> list.add((Object)class_2497.method_23247((int)e.method_5628())));
        tag.method_10566("Caught", (class_2520)list);
        return tag;
    }

    private void readCaughtEntities(class_2487 tag) {
        class_2499 list = tag.method_10554("Caught", 3);
        this.caughtEntities.clear();
        list.forEach(t -> {
            class_1297 e = this.method_37908().method_8469(((class_2497)t).method_10701());
            if (e instanceof class_1309) {
                class_1309 entity = (class_1309)e;
                this.caughtEntities.add(entity);
            }
        });
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

