/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_6880;

public class SpikeEntity
extends BaseDamageCloud {
    private static final int ATTACK_DURATION = 20;
    private static final int ATTACK_TICK = 10;
    private static final class_2940<Integer> TYPE = class_2945.method_12791(SpikeEntity.class, (class_2941)class_2943.field_13327);
    private int targetDuration;
    private int attackDelay;
    private int attackTime;
    private int clientAttackTime;
    private class_1309 targetMob;
    private boolean attacking;
    public int clientLightLevelHeight;

    public SpikeEntity(class_1299<? extends SpikeEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public SpikeEntity(class_1937 level, class_1309 livingEntity, int targetDuration, int attackDelay, SpikeType spikeType) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)RuneCraftoryEntities.HOMING_SPIKES.get()), level, livingEntity);
        this.targetDuration = targetDuration;
        this.attackDelay = attackDelay;
        this.field_6011.method_12778(TYPE, (Object)spikeType.ordinal());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TYPE, (Object)0);
    }

    public void setEntityTarget(class_1309 target) {
        this.targetMob = target;
    }

    public class_243 method_31166(float partialTicks) {
        return this.method_30950(partialTicks).method_1031(0.0, 2.1, 0.0);
    }

    public int livingTickMax() {
        return this.targetDuration + this.attackDelay + 20;
    }

    public int spikeType() {
        return (Integer)this.field_6011.method_12789(TYPE);
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.attackDelay = compound.method_10550("AttackDelay");
        this.targetDuration = compound.method_10550("TargetDuration");
        this.attackTime = compound.method_10550("AttackTime");
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("AttackDelay", this.attackDelay);
        compound.method_10569("TargetDuration", this.targetDuration);
        compound.method_10569("AttackTime", this.attackTime);
    }

    public void method_5773() {
        super.method_5773();
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        this.method_5814(newX, newY, newZ);
        if (this.method_37908().field_9236) {
            if (!this.attacking) {
                double y = this.method_23318();
                class_2680 current = this.method_37908().method_8320(this.method_24515());
                if (current.method_26215()) {
                    current = this.method_37908().method_8320(this.method_24515().method_10074());
                    if (current.method_26215()) {
                        current = class_2246.field_10566.method_9564();
                    } else {
                        y = class_3532.method_15357((double)y);
                    }
                } else {
                    y = class_3532.method_15384((double)y);
                }
                for (int i = 0; i < 6; ++i) {
                    double dX = (this.field_5974.method_43058() * 2.0 - 1.0) * 0.3;
                    double dY = 0.3 + this.field_5974.method_43058() * 0.3;
                    double dZ = (this.field_5974.method_43058() * 2.0 - 1.0) * 0.3;
                    double pY = y + this.field_5974.method_43058() * 0.5 - 0.25;
                    this.clientLightLevelHeight = class_3532.method_15357((double)y);
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, current), this.method_23322(2.0), pY, this.method_23325(2.0), dX, dY, dZ);
                }
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), current.method_26231().method_10594(), this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.1f + 0.75f, false);
            }
        } else if (this.livingTicks < this.targetDuration) {
            if (this.targetMob == null || this.targetMob.method_29504()) {
                this.targetMob = EntityUtils.ownedProjectileTarget(this.method_24921(), 12);
            }
            if (this.targetMob != null) {
                class_243 dir = this.targetMob.method_19538().method_1020(this.method_19538()).method_1029().method_1021(0.2);
                if (this.damageBoundingBox().method_1014(-0.25).method_994(this.targetMob.method_5829())) {
                    dir = class_243.field_1353;
                    this.livingTicks = this.targetDuration;
                }
                this.method_18799(dir);
                this.field_6007 = true;
            }
        } else if (++this.attackTime > this.attackDelay) {
            this.method_18799(class_243.field_1353);
            if (!this.attacking) {
                this.method_37908().method_8421((class_1297)this, (byte)4);
                this.attacking = true;
            }
        }
    }

    public boolean canStartDamage() {
        return this.attackTime == 10;
    }

    protected class_238 damageBoundingBox() {
        return new class_238(-0.6, -0.2, -0.6, 0.6, 2.2, 0.6).method_997(this.method_19538());
    }

    protected boolean damageEntity(class_1309 target) {
        DynamicDamage.Builder builder = new DynamicDamage.Builder((class_1297)this, this.method_24921()).element(ItemElement.EARTH).knock(DynamicDamage.KnockBackType.UP, 0.5f).magic().hurtResistant(0);
        return CombatUtils.damageWithFaintAndCrit(this.method_24921(), (class_1297)target, builder, CombatUtils.getAttributeValue(this.method_24921(), (class_6880<class_1320>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
    }

    public void method_5711(byte id) {
        super.method_5711(id);
        if (id == 4) {
            this.attacking = true;
            this.clientAttackTime = this.livingTicks;
            if (!this.method_5701()) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)RuneCraftorySounds.ENTITY_EARTH_SPIKE_ATTACK.get(), this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.1f + 0.75f, false);
            }
        }
    }

    public float getAnimationProgress(float partialTicks) {
        if (!this.attacking) {
            return 0.0f;
        }
        int i = this.livingTicks - this.clientAttackTime;
        float lerped = Math.min(20.0f, class_3532.method_16439((float)partialTicks, (float)i, (float)(i + 1)));
        return class_3532.method_15374((float)(lerped * (float)Math.PI / 20.0f)) * 1.2f;
    }

    public static enum SpikeType {
        EARTH,
        ROOT;

    }
}

