/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Beetle
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String CHARGE_ATTACK = BUILDER.add("ramm", AnimationsBuilder.definition((double)1.52).marker("attack_start", new double[]{0.16}));
    public static final String MELEE = BUILDER.add("attack", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.4}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Beetle> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Beetle(class_1299<? extends Beetle> type, class_1937 level) {
        super((class_1299<? extends ChargingMonster>)type, level);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(new String[]{CHARGE_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(1).start(new String[]{CHARGE_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(4.0)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(1).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(4, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(1, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public MoveType calculateMoveType() {
        if (!this.method_6062() && !this.method_24828()) {
            return MoveType.FLY;
        }
        return super.calculateMoveType();
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 2.6;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    public AnimationHandler<Beetle> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(CHARGE_ATTACK);
    }

    @Override
    public double chargingSpeed() {
        return 0.35;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE_ATTACK);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

