/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.ArrayList;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Duck
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("slap", AnimationsBuilder.definition((double)0.72).marker("attack", new double[]{0.4}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String DIVE = BUILDER.add("dive", AnimationsBuilder.definition((double)1.84).marker("dive", new double[]{1.08}).infinite());
    public static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.48));
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Duck> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public Duck(class_1299<? extends Duck> type, class_1937 level) {
        super((class_1299<? extends ChargingMonster>)type, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.25);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{DIVE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(6))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(3).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.withCondition(MonsterBehaviourUtils.ifCloserThan(9.0)), new ExtendedBehaviour[]{new Idle()}).build();
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.8;
        double length = (double)this.method_17681() * 2.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{DIVE})) {
            if (anim.isPast("dive")) {
                if (this.getChargeMotion() == null) {
                    this.setChargeMotion(this.getChargeTo(anim.getAnimation()));
                }
                this.method_18800(this.getChargeMotion().field_1352, -0.25, this.getChargeMotion().field_1350);
                if (!this.method_24828()) {
                    if (this.hitEntity == null) {
                        this.hitEntity = new ArrayList();
                    }
                    this.mobAttack(anim, null, e -> {
                        if (!this.hitEntity.contains(e)) {
                            this.hitEntity.add(e);
                            this.method_6121((class_1297)e);
                        }
                    });
                } else {
                    this.getAnimationHandler().setAnimation(LAND);
                    this.setChargeMotion(null);
                }
            } else {
                class_243 delta = this.method_18798();
                this.method_18800(delta.field_1352, 0.17f, delta.field_1350);
                if (this.method_5968() != null) {
                    this.method_5951((class_1297)this.method_5968(), 20.0f, 30.0f);
                }
            }
        } else if (!anim.is(new String[]{LAND})) {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<? extends Duck> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(DIVE) || anim.equals(LAND);
    }

    @Override
    protected boolean fixedYaw() {
        AnimationState anim = this.getAnimationHandler().getAnimation();
        return anim != null && (anim.is(new String[]{DIVE}) ? anim.isPast("dive") : anim.is(new String[]{LAND}));
    }

    @Override
    public class_243 getChargeTo(String animation) {
        return EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(0.7);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(DIVE);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

