/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.SleepAuraSpell;
import io.github.flemmli97.runecraftory.common.spells.WindBladeSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import org.jetbrains.annotations.Nullable;

public class LeafBall
extends BaseMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("tackle", AnimationsBuilder.definition((double)0.68).marker("attack", new double[]{0.36}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String WIND = BUILDER.add("wind_blade", AnimationsBuilder.definition((double)1.12).marker("attack", new double[]{0.52}));
    public static final String SLEEP_ATTACK = BUILDER.add("sleep_aura", AnimationsBuilder.definition((double)0.8).marker("attack", new double[]{0.44}));
    public static final String STILL = BUILDER.add("still", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<LeafBall> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public LeafBall(class_1299<? extends LeafBall> type, class_1937 level) {
        super(type, level);
        this.method_5875(true);
        this.field_6207 = new FreeMoveControl((class_1308)this, 60.0f, 30.0f, () -> true);
    }

    @Override
    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.28);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.inAABBRange(MELEE)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{WIND}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(6.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(6).start(new String[]{SLEEP_ATTACK}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(5))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new StayWithinDistanceOfAttackTarget().maxDistance(15.0f)}).add(2, MonsterBehaviourUtils.ifCloserThan(10.0), new ExtendedBehaviour[]{new SetRandomHoverTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_59922().method_43048(20) + 30 + diffAdd;
        }
        return this.method_59922().method_43048(40) + 25 + diffAdd;
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = this.method_17681() * 2.0f;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{WIND})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((WindBladeSpell)RuneCraftorySpells.DOUBLE_SONIC.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{SLEEP_ATTACK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((SleepAuraSpell)RuneCraftorySpells.SLEEP_AURA.get()).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<LeafBall> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 0 ? (Spell)RuneCraftorySpells.DOUBLE_BULLET.get() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return STILL;
    }
}

