/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.MultiArrowSpell;
import io.github.flemmli97.runecraftory.common.spells.ThrowHandItemSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1335;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Mimic
extends LeapingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("attack", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)0.6).marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{0.48}));
    public static final String THROW = BUILDER.add("throw", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String ARROW = BUILDER.add("arrow", THROW);
    public static final String CAST = BUILDER.add("cast", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String CLOSE = BUILDER.add("close", AnimationsBuilder.definition((double)0.32));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final class_2940<Boolean> AWAKE = class_2945.method_12791(Mimic.class, (class_2941)class_2943.field_13323);
    private final AnimationHandler<Mimic> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final List<class_1799> throwables = List.of(new class_1799((class_1935)class_1802.field_8279), new class_1799((class_1935)RuneCraftoryItems.BATTLE_AXE.get()), new class_1799((class_1935)RuneCraftoryItems.STEEL_SWORD.get()), new class_1799((class_1935)RuneCraftoryItems.MUSHROOM.get()));
    private int sleepTick = -1;
    private boolean sleeping;

    public Mimic(class_1299<? extends Mimic> type, class_1937 level) {
        super((class_1299<? extends LeapingMonster>)type, level);
        this.field_6207 = new JumpingMover(this);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(AWAKE, (Object)false);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.5);
        super.applyAttributes();
    }

    @Override
    public List<? extends ExtendedSensor<? extends BaseMonster>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setRadius(5.0).setPredicate((target, entity) -> !entity.isAwake() && entity.targetPred.test(target)).setScanRate(e -> 4), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.isAwake() && entity.targetPred.test(target)).setScanRate(e -> 10), new HurtBySensor());
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(1))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{LEAP}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(7.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{LEAP}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(7.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{THROW}).play(MonsterBehaviourUtils.cooldownedPlay()).end(3).start(new String[]{ARROW}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{CAST}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new Idle();
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        boolean ret = super.method_5643(source, amount);
        if (ret && !this.sleeping) {
            this.setAwake();
        }
        return ret;
    }

    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().field_9236) {
            if (this.method_5968() == null) {
                --this.sleepTick;
            }
            if (this.sleepTick == 0) {
                this.field_6011.method_12778(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.method_5942().method_6340();
            }
        }
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.isTamed() && !this.isAwake()) {
            BrainUtils.setTargetOfEntity((class_1309)this, (class_1309)player);
            this.method_5783(class_3417.field_14982, this.method_6107() * 0.5f, 1.0f);
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public class_238 attackBB(AnimationState anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 1.8;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{THROW})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                class_1799 held = this.method_6047();
                this.method_5673(class_1304.field_6173, this.throwables.get(this.field_5974.method_43048(this.throwables.size())));
                ((ThrowHandItemSpell)RuneCraftorySpells.THROW_HAND_ITEM.get()).use((class_1309)this);
                this.method_5673(class_1304.field_6173, held);
            }
        } else if (anim.is(new String[]{CAST})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((WaterLaserSpell)RuneCraftorySpells.WATER_LASER.get()).use((class_1309)this);
            }
        } else if (anim.is(new String[]{ARROW})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((MultiArrowSpell)RuneCraftorySpells.DOUBLE_ARROW.get()).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<? extends Mimic> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isLeapingAnim(String anim) {
        return anim.equals(LEAP);
    }

    @Override
    public double leapHeightMotion() {
        return 0.3;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (class_1297)this.method_5642(), command == 2 ? (Spell)RuneCraftorySpells.THROW_HAND_ITEM.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(THROW);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            this.sleeping = true;
            if (this.isAwake()) {
                this.field_6011.method_12778(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.method_5942().method_6340();
            }
        } else {
            this.sleeping = false;
        }
    }

    @Override
    public void method_5980(@Nullable class_1309 livingEntity) {
        super.method_5980(livingEntity);
        if (livingEntity != null && !this.sleeping) {
            this.setAwake();
        }
    }

    public void setAwake() {
        this.field_6011.method_12778(AWAKE, (Object)true);
        this.sleepTick = 200;
    }

    public boolean isAwake() {
        return (Boolean)this.field_6011.method_12789(AWAKE);
    }

    public boolean method_30948() {
        return !this.isAwake();
    }

    protected float method_6106() {
        if (this.method_5968() != null) {
            return 0.24f * this.method_23313();
        }
        return 0.36f * this.method_23313();
    }

    public void method_6043() {
        class_243 vec3 = this.method_18798();
        this.method_18800(vec3.field_1352, this.method_6106(), vec3.field_1350);
        this.field_6007 = true;
    }

    private int getJumpDelay() {
        if (this.method_5968() != null) {
            return this.field_5974.method_43048(5) + 4;
        }
        return this.field_5974.method_43048(6) + 8;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public boolean hasSleepingAnimation() {
        return true;
    }

    protected static class JumpingMover
    extends class_1335 {
        private final Mimic mimic;
        private int jumpDelay;

        public JumpingMover(Mimic mimic) {
            super((class_1308)mimic);
            this.mimic = mimic;
        }

        public void method_6240() {
            this.field_6371.method_5847(this.field_6371.method_36454());
            this.field_6371.method_5636(this.field_6371.method_36454());
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.field_6371.method_5930(0.0f);
                return;
            }
            this.mimic.setAwake();
            this.field_6374 = class_1335.class_1336.field_6377;
            double dX = this.field_6370 - this.field_6371.method_23317();
            double dZ = this.field_6367 - this.field_6371.method_23321();
            float n = (float)(class_3532.method_15349((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
            this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), n, 90.0f));
            if (this.field_6371.method_24828()) {
                this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23719)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.mimic.getJumpDelay();
                    this.mimic.method_5993().method_6233();
                    this.mimic.method_5783(class_3417.field_14982, this.mimic.method_6107() * 0.5f, 1.0f);
                } else {
                    this.mimic.field_6212 = 0.0f;
                    this.mimic.field_6250 = 0.0f;
                    this.field_6371.method_6125(0.0f);
                }
            } else {
                this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_45325(class_5134.field_23719)));
            }
        }
    }
}

